package jp.snowgoose.treno.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * @author snowgoose
 */
public final class ThreadLocalMap<K, V> extends InheritableThreadLocal<Map<K, V>> implements
        Map<K, V> {

    public ThreadLocalMap() {
        super();
    }

    @Override
    protected Map<K, V> initialValue() {
        return Maps.newLinkedHashMap();
    }

    public void clear() {
        super.get().clear();
    }

    public boolean containsKey(Object key) {
        return super.get().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.get().containsValue(value);
    }

    public Set<Entry<K, V>> entrySet() {
        return super.get().entrySet();
    }

    public V get(Object key) {
        return super.get().get(key);
    }

    public boolean isEmpty() {
        return super.get().isEmpty();
    }

    public Set<K> keySet() {
        return super.get().keySet();
    }

    public V put(K key, V value) {
        return super.get().put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        super.get().putAll(map);
    }

    public V remove(Object key) {
        return super.get().remove(key);
    }

    public int size() {
        return super.get().size();
    }

    public Collection<V> values() {
        return super.get().values();
    }

}
