/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.config;

import javax.servlet.FilterConfig;
import jp.snowgoose.treno.component.SimpleInstanceProvider;
import jp.snowgoose.treno.config.WebConfig;
import jp.snowgoose.treno.exception.AssertionFailedException;
import jp.snowgoose.treno.metadata.Suffix;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WebConfigTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Mockery mockery = new JUnit4Mockery();
    private final FilterConfig filterConfig = (FilterConfig)this.mockery.mock(FilterConfig.class);

    @Test
    public void create_config() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(1.returnValue((Object)"jp.co.tiny.reno.test.pages"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(1.returnValue((Object)"annotation"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(1.returnValue((Object)"jp.co.tiny.reno.test"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(1.returnValue((Object)".do"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(1.returnValue((Object)"foo.baa.Hoge"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(1.returnValue((Object)"foo.baa.Fuga"));
            }
        });
        WebConfig config = new WebConfig(this.filterConfig);
        Assert.assertThat(config.getComponentPackageNames().get(0), (Matcher)Is.is((Object)"jp.co.tiny.reno.test"));
        Assert.assertThat(config.getActionPackageNames().get(0), (Matcher)Is.is((Object)"jp.co.tiny.reno.test.pages"));
        Assert.assertThat((Object)config.getSuffix(), (Matcher)Is.is((Object)new Suffix(".do")));
        Assert.assertThat((Object)config.getActionInstanceProviderClassName(), (Matcher)Is.is((Object)"foo.baa.Hoge"));
        Assert.assertThat((Object)config.getComponentInstanceProviderClassName(), (Matcher)Is.is((Object)"foo.baa.Fuga"));
        Assert.assertThat((Object)config.getActionDescriptorFactoryId(), (Matcher)Is.is((Object)"annotation"));
    }

    @Test
    public void testCreateConfig_ApplyDefaultValue() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(2.returnValue((Object)"jp.co.tiny.reno.test.pages"));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(2.returnValue(null));
            }
        });
        WebConfig config = new WebConfig(this.filterConfig);
        Assert.assertThat(config.getComponentPackageNames().get(0), (Matcher)Is.is((Object)"jp.snowgoose.treno"));
        Assert.assertThat(config.getActionPackageNames().get(0), (Matcher)Is.is((Object)"jp.co.tiny.reno.test.pages"));
        Assert.assertThat((Object)config.getSuffix(), (Matcher)Is.is((Object)new Suffix(".rn")));
        Assert.assertThat((Object)config.getActionInstanceProviderClassName(), (Matcher)Is.is((Object)SimpleInstanceProvider.class.getCanonicalName()));
        Assert.assertThat((Object)config.getComponentInstanceProviderClassName(), (Matcher)Is.is((Object)SimpleInstanceProvider.class.getCanonicalName()));
        Assert.assertThat((Object)config.getActionDescriptorFactoryId(), (Matcher)Is.is((Object)"annotation"));
    }

    @Test
    public void testCreateConfig_ValidateRequiredParameter() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(WebConfigTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(3.returnValue(null));
            }
        });
        this.thrown.expect(AssertionFailedException.class);
        new WebConfig(this.filterConfig);
    }

    @Test
    public void testCreateConfig_FilterConfigIsNull() {
        this.thrown.expect(AssertionFailedException.class);
        this.thrown.expectMessage("FilterConfig is required.");
        new WebConfig(null);
    }
}

