/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import jp.snowgoose.treno.exception.ActionNotFoundException;
import jp.snowgoose.treno.junit.MockActionDescriptor;
import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.metadata.ActionDescriptors;
import jp.snowgoose.treno.metadata.MappedPath;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ActionDescriptorsTest {
    private ActionDescriptors actionDescs;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.actionDescs = new ActionDescriptors();
    }

    @Test
    public void testRegister() {
        MockActionDescriptor desc1 = new MockActionDescriptor();
        desc1.setMappedPath(new MappedPath("/foo/baa"));
        MockActionDescriptor desc2 = new MockActionDescriptor();
        desc2.setMappedPath(new MappedPath("/foo/baz"));
        this.actionDescs.put((ActionDescriptor)desc1);
        this.actionDescs.put((ActionDescriptor)desc2);
        Assert.assertThat((Object)this.actionDescs.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testRegister_DuplicatieMountedPath() {
        MockActionDescriptor desc1 = new MockActionDescriptor();
        desc1.setMappedPath(new MappedPath("/foo/baa"));
        MockActionDescriptor desc2 = new MockActionDescriptor();
        desc2.setMappedPath(new MappedPath("/foo/baa"));
        this.actionDescs.put((ActionDescriptor)desc1);
        this.actionDescs.put((ActionDescriptor)desc2);
        Assert.assertThat((Object)this.actionDescs.getActionDescriptor(new MappedPath("/foo/baa")), (Matcher)Is.is((Object)((Object)desc1)));
    }

    @Test
    public void testGetActionDescriptor() {
        MockActionDescriptor desc1 = new MockActionDescriptor();
        desc1.setMappedPath(new MappedPath("/foo/baa"));
        MockActionDescriptor desc2 = new MockActionDescriptor();
        desc2.setMappedPath(new MappedPath("/foo/baz"));
        this.actionDescs.put((ActionDescriptor)desc1);
        this.actionDescs.put((ActionDescriptor)desc2);
        Assert.assertThat((Object)this.actionDescs.size(), (Matcher)Is.is((Object)2));
        ActionDescriptor actual = this.actionDescs.getActionDescriptor(new MappedPath("/foo/baa"));
        Assert.assertSame((Object)actual, (Object)((Object)desc1));
    }

    @Test
    public void testGetActionDescriptor_NotFound() {
        this.thrown.expect(ActionNotFoundException.class);
        MockActionDescriptor desc1 = new MockActionDescriptor();
        desc1.setMappedPath(new MappedPath("/foo/baa"));
        MockActionDescriptor desc2 = new MockActionDescriptor();
        desc2.setMappedPath(new MappedPath("/foo/baz"));
        this.actionDescs.put((ActionDescriptor)desc1);
        this.actionDescs.put((ActionDescriptor)desc2);
        Assert.assertThat((Object)this.actionDescs.size(), (Matcher)Is.is((Object)2));
        this.actionDescs.getActionDescriptor(new MappedPath("/foo/not/found"));
    }
}

