/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result.type;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jp.snowgoose.treno.annotation.BindValue;
import jp.snowgoose.treno.annotation.Direction;
import jp.snowgoose.treno.annotation.InvokeAction;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.exception.ResultEvaluationFailureException;
import jp.snowgoose.treno.junit.MockResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.result.type.Stream;
import jp.snowgoose.treno.util.Maps;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class StreamTest {
    private final Stream stream = new Stream();
    private final Mockery mockery = new JUnit4Mockery();
    private final HttpServletResponse response = (HttpServletResponse)this.mockery.mock(HttpServletResponse.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private MockResultDescriptor resultDesc;
    private MockFileDownloader mockAction;
    private OutputStream out;
    private RequestContext context = (RequestContext)this.mockery.mock(RequestContext.class);
    private ActionInstance actionInstance = (ActionInstance)this.mockery.mock(ActionInstance.class);
    private RequestValueMapper valueMapper = (RequestValueMapper)this.mockery.mock(RequestValueMapper.class);

    @Before
    public void setUp() {
        this.mockAction = new MockFileDownloader();
        this.resultDesc = new MockResultDescriptor();
        this.resultDesc.setResultType(Stream.class);
        this.resultDesc.setWhen("success");
    }

    @Test
    public void evaluate_stream_result() throws Exception {
        String downLoadText = "this is test download file!";
        File downloadFile = this.folder.newFile("download.txt");
        FileWriter writer = new FileWriter(downloadFile);
        writer.write(downLoadText);
        writer.flush();
        writer.close();
        final Map responseScopeMap = Maps.newLinkedHashMap();
        responseScopeMap.put("downloadFile", downloadFile);
        File destFile = this.folder.newFile("tmp.txt");
        this.out = new FileOutputStream(destFile);
        final ServletOutputStream sout = new ServletOutputStream(){

            public void write(int b) throws IOException {
                StreamTest.this.out.write(b);
            }
        };
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.oneOf(StreamTest.this.context)).getResponse();
                this.will(2.returnValue((Object)StreamTest.this.response));
                ((HttpServletResponse)this.oneOf(StreamTest.this.response)).getOutputStream();
                this.will(2.returnValue((Object)sout));
                ((RequestValueMapper)this.oneOf(StreamTest.this.valueMapper)).getAll(Scope.RESPONSE);
                this.will(2.returnValue((Object)responseScopeMap));
            }
        });
        this.mockAction.download("snowgoose");
        this.stream.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
        this.mockery.assertIsSatisfied();
        BufferedReader reader = new BufferedReader(new FileReader(destFile));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Is.is((Object)downLoadText));
    }

    @Test
    public void evaluate_stream_result_with_custom_header() throws Exception {
        String downLoadText = "this is test download file!";
        File downloadFile = this.folder.newFile("download.txt");
        FileWriter writer = new FileWriter(downloadFile);
        writer.write(downLoadText);
        writer.flush();
        writer.close();
        final Map responseScopeMap = Maps.newLinkedHashMap();
        responseScopeMap.put("downloadFile", downloadFile);
        Map responseHeaders = Maps.newLinkedHashMap();
        responseHeaders.put("Content-Disposition", "attachment; filename=download.txt");
        responseScopeMap.put("headers", responseHeaders);
        File destFile = this.folder.newFile("tmp.txt");
        this.out = new FileOutputStream(destFile);
        final ServletOutputStream sout = new ServletOutputStream(){

            public void write(int b) throws IOException {
                StreamTest.this.out.write(b);
            }
        };
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.oneOf(StreamTest.this.context)).getResponse();
                this.will(4.returnValue((Object)StreamTest.this.response));
                ((HttpServletResponse)this.oneOf(StreamTest.this.response)).getOutputStream();
                this.will(4.returnValue((Object)sout));
                ((RequestValueMapper)this.oneOf(StreamTest.this.valueMapper)).getAll(Scope.RESPONSE);
                this.will(4.returnValue((Object)responseScopeMap));
                ((HttpServletResponse)this.oneOf(StreamTest.this.response)).setHeader("Content-Disposition", "attachment; filename=download.txt");
            }
        });
        MockFileDownloaderWithCustomHeader mockAction = new MockFileDownloaderWithCustomHeader();
        mockAction.download("snowgoose");
        this.stream.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
        this.mockery.assertIsSatisfied();
        BufferedReader reader = new BufferedReader(new FileReader(destFile));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Is.is((Object)downLoadText));
    }

    @Test
    public void evaluate_stream_result_no_download_contents() throws Exception {
        String downLoadText = "this is test download file!";
        File downloadFile = this.folder.newFile("download.txt");
        FileWriter writer = new FileWriter(downloadFile);
        writer.write(downLoadText);
        writer.flush();
        writer.close();
        final Map responseScopeMap = Maps.newLinkedHashMap();
        File destFile = this.folder.newFile("tmp.txt");
        this.out = new FileOutputStream(destFile);
        final ServletOutputStream sout = new ServletOutputStream(){

            public void write(int b) throws IOException {
                StreamTest.this.out.write(b);
            }
        };
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.oneOf(StreamTest.this.context)).getResponse();
                this.will(6.returnValue((Object)StreamTest.this.response));
                ((HttpServletResponse)this.oneOf(StreamTest.this.response)).getOutputStream();
                this.will(6.returnValue((Object)sout));
                ((RequestValueMapper)this.oneOf(StreamTest.this.valueMapper)).getAll(Scope.RESPONSE);
                this.will(6.returnValue((Object)responseScopeMap));
            }
        });
        MockFileDownloaderWithCustomHeader mockAction = new MockFileDownloaderWithCustomHeader();
        mockAction.download("snowgoose");
        this.thrown.expect(ResultEvaluationFailureException.class);
        this.stream.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
        this.mockery.assertIsSatisfied();
    }

    @InvokeActions(value="/files/*")
    public class MockFileDownloaderWithCustomHeader {
        @BindValue(scope=Scope.RESPONSE)
        private File downloadFile;
        @BindValue(scope=Scope.RESPONSE)
        private Map<String, String> headers;

        @InvokeAction(path="download", directions={@Direction(type=Stream.class)})
        public String download(@BindValue(value="fileName") String fileName) {
            this.headers = Maps.newLinkedHashMap();
            this.downloadFile = new File(fileName);
            this.headers.put("Content-Disposition", "attachment; filename=download.txt");
            return "success";
        }
    }

    @InvokeActions(value="/files/*")
    public class MockFileDownloader {
        @BindValue(scope=Scope.RESPONSE)
        private File downloadFile;

        @InvokeAction(path="download", directions={@Direction(type=Stream.class)})
        public String download(@BindValue(value="fileName") String fileName) {
            this.downloadFile = new File(fileName);
            return "success";
        }
    }
}

