/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import jp.snowgoose.treno.util.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testIsEmpty() {
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)"test!"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)"t !"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)" test!"));
        Assert.assertTrue((boolean)StringUtils.isEmpty((String)" "));
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((String)"     "));
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)"test!"));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)"t !"));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)" test!"));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)" "));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty(null));
        Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)"     "));
    }

    @Test
    public void testDecapitalize() {
        Assert.assertThat((Object)StringUtils.decapitalize((String)"Foo"), (Matcher)Is.is((Object)"foo"));
        Assert.assertThat((Object)StringUtils.decapitalize((String)"FooBaa"), (Matcher)Is.is((Object)"fooBaa"));
        Assert.assertThat((Object)StringUtils.decapitalize((String)"FooBaaBaz"), (Matcher)Is.is((Object)"fooBaaBaz"));
        Assert.assertThat((Object)StringUtils.decapitalize((String)" FooBaaBaz"), (Matcher)Is.is((Object)" FooBaaBaz"));
        Assert.assertThat((Object)StringUtils.decapitalize((String)"A"), (Matcher)Is.is((Object)"a"));
        Assert.assertNull((Object)StringUtils.decapitalize(null));
        Assert.assertThat((Object)StringUtils.decapitalize((String)""), (Matcher)Is.is((Object)""));
    }
}

