/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.component;

import java.util.ArrayList;
import java.util.Collection;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.Scanner;
import jp.snowgoose.treno.component.SimpleInstanceProvider;
import jp.snowgoose.treno.component.UniqueAddon;
import jp.snowgoose.treno.junit.CollectionAssert;
import jp.snowgoose.treno.util.FileClassCollector;
import jp.snowgoose.treno.util.JarClassCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScannerTest {
    private Scanner ac;

    @Before
    public void setUp() {
    }

    @Test
    public void scan_classes_implements_specific_interface() {
        ArrayList<Object> classCollectors = new ArrayList<Object>();
        classCollectors.add(new JarClassCollector());
        classCollectors.add(new FileClassCollector());
        this.ac = new Scanner(classCollectors, (InstanceProvider)new SimpleInstanceProvider());
        String[] packageNames = new String[]{Scanner.class.getPackage().getName()};
        Scanner.Scanned scanned = this.ac.scan(packageNames);
        Collection actual = scanned.getInstances(Scanner.Scanned.Conditions.implementsInterface(MockIF.class));
        CollectionAssert.assertContainsInstanceOfTypes(actual, MockA.class, MockB.class, MockC.class);
    }

    @Test
    public void scan_classes_annotated_specific_annotation() {
        ArrayList<Object> classCollectors = new ArrayList<Object>();
        classCollectors.add(new JarClassCollector());
        classCollectors.add(new FileClassCollector());
        this.ac = new Scanner(classCollectors, (InstanceProvider)new SimpleInstanceProvider());
        String[] packageNames = new String[]{Scanner.class.getPackage().getName()};
        Scanner.Scanned scanned = this.ac.scan(packageNames);
        Collection actual = scanned.getInstances(Scanner.Scanned.Conditions.annotateWith(InvokeActions.class));
        CollectionAssert.assertContainsInstanceOfTypes(actual, MockB.class, MockC.class);
    }

    @Test
    public void scan_classes_implements_specific_interface_and_distinct_id() {
        ArrayList<Object> classCollectors = new ArrayList<Object>();
        classCollectors.add(new JarClassCollector());
        classCollectors.add(new FileClassCollector());
        this.ac = new Scanner(classCollectors, (InstanceProvider)new SimpleInstanceProvider());
        String[] packageNames = new String[]{Scanner.class.getPackage().getName()};
        Scanner.Scanned scanned = this.ac.scan(packageNames);
        MockUniqueObject actual = (MockUniqueObject)scanned.getInstance(Scanner.Scanned.Conditions.implementsInterface(MockUniqueObject.class), "b");
        Assert.assertTrue((boolean)(actual instanceof MockUniqueB));
    }

    @Test
    public void scan_classes_extends_specific_class() {
        ArrayList<Object> classCollectors = new ArrayList<Object>();
        classCollectors.add(new JarClassCollector());
        classCollectors.add(new FileClassCollector());
        this.ac = new Scanner(classCollectors, (InstanceProvider)new SimpleInstanceProvider());
        String[] packageNames = new String[]{Scanner.class.getPackage().getName()};
        Scanner.Scanned scanned = this.ac.scan(packageNames);
        Collection actual = scanned.getInstances(Scanner.Scanned.Conditions.extendsClass(MockA.class));
        CollectionAssert.assertContainsInstanceOfTypes(actual, MockD.class);
    }

    public static class MockUniqueC
    implements MockUniqueObject {
        public String getUniqueId() {
            return "c";
        }
    }

    public static class MockUniqueB
    implements MockUniqueObject {
        public String getUniqueId() {
            return "b";
        }
    }

    public static class MockUniqueA
    implements MockUniqueObject {
        public String getUniqueId() {
            return "a";
        }
    }

    public static interface MockUniqueObject
    extends UniqueAddon {
    }

    @InvokeActions
    public static class MockD
    extends MockA {
    }

    @InvokeActions
    public static class MockC
    implements MockIF {
    }

    @InvokeActions
    public static class MockB
    implements MockIF {
    }

    public static class MockA
    implements MockIF {
    }

    public static interface MockIF {
    }
}

