/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.context;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.junit.MockBindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.Scope;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class AutoParameterProxyTest {
    private ParameterConverter proxy;

    @Test
    public void auto_convert_parameter_to_integer() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(new Integer(0).getClass());
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Integer actual = (Integer)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)1));
    }

    @Test
    public void auto_convert_parameter_to_long() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(new Long(0L).getClass());
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Long actual = (Long)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)1L));
    }

    @Test
    public void auto_convert_parameter_to_short() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Short.valueOf("1").getClass());
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Short actual = (Short)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)Short.valueOf("1")));
    }

    @Test
    public void auto_convert_parameter_to_bool() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Boolean.valueOf("false").getClass());
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Boolean actual = (Boolean)this.proxy.convert((Object)"true", (BindDescriptor)mockBindDesc);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void auto_convert_parameter_to_float() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Float.class);
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Float actual = (Float)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void auto_convert_parameter_to_char() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Character.class);
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Character actual = (Character)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)Character.valueOf('1')));
    }

    @Test
    public void auto_convert_parameter_to_decimal() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(BigDecimal.class);
        this.proxy = new ParameterConverter.AutoParameterConverter();
        BigDecimal actual = (BigDecimal)this.proxy.convert((Object)"1", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)BigDecimal.ONE));
    }

    @Test
    public void auto_convert_parameter_to_formatted_decimal() {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("number");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(BigDecimal.class);
        mockBindDesc.setFormat("#,##0");
        this.proxy = new ParameterConverter.AutoParameterConverter();
        BigDecimal actual = (BigDecimal)this.proxy.convert((Object)"1,000,000", (BindDescriptor)mockBindDesc);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)new BigDecimal(1000000L)));
    }

    @Test
    public void auto_convert_parameter_to_date() throws Exception {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("date");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Date.class);
        mockBindDesc.setFormat("yyyy/MM/dd");
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Date actual = (Date)this.proxy.convert((Object)"2019/02/01", (BindDescriptor)mockBindDesc);
        Date expected = new SimpleDateFormat("yyyy/MM/dd").parse("2019/02/01");
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void auto_convert_parameter_is_null() throws Exception {
        MockBindDescriptor mockBindDesc = new MockBindDescriptor();
        mockBindDesc.setName("date");
        mockBindDesc.setScope(Scope.REQUEST);
        mockBindDesc.setParameterType(Date.class);
        mockBindDesc.setFormat("yyyy/MM/dd");
        this.proxy = new ParameterConverter.AutoParameterConverter();
        Date actual = (Date)this.proxy.convert(null, (BindDescriptor)mockBindDesc);
        Assert.assertNull((Object)actual);
    }
}

