/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.context;

import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.snowgoose.treno.context.DefaultRequestContext;
import jp.snowgoose.treno.context.ParameterConverters;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.SimpleValueMapper;
import jp.snowgoose.treno.metadata.Scope;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleValueMapperTest {
    private SimpleValueMapper mapping;
    private final Mockery mockery = new JUnit4Mockery();
    private final HttpServletRequest request = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);
    private final HttpSession session = (HttpSession)this.mockery.mock(HttpSession.class);

    @Before
    public void setUp() {
        ParameterConverters parameterConverters = new ParameterConverters((Collection)Collections.EMPTY_LIST);
        DefaultRequestContext context = new DefaultRequestContext(this.request, null);
        this.mapping = new SimpleValueMapper((RequestContext)context, parameterConverters);
    }

    @Test
    public void get_available_value_via_parameter() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getParameter("name");
                this.will(1.returnValue((Object)"value1"));
            }
        });
        Object value = this.mapping.get(Scope.PARAMETER, "name");
        Assert.assertThat((Object)value.toString(), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void get_available_value_via_request() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getParameter("name");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getAttribute("name");
                this.will(2.returnValue((Object)"value1"));
            }
        });
        String value = this.mapping.get(Scope.REQUEST, "name").toString();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void get_available_value_via_session() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getSession(false);
                this.will(3.returnValue((Object)SimpleValueMapperTest.this.session));
                ((HttpSession)this.one(SimpleValueMapperTest.this.session)).getAttribute("name");
                this.will(3.returnValue((Object)"value1"));
            }
        });
        String value = this.mapping.get(Scope.SESSION, "name").toString();
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void get_value_returns_null_when_session_not_available() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getSession(false);
                this.will(4.returnValue(null));
            }
        });
        Object value = this.mapping.get(Scope.SESSION, "name");
        Assert.assertNull((Object)value);
    }

    @Test
    public void put_value_to_request_scope() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).setAttribute("name", (Object)"value");
            }
        });
        this.mapping.put("name", (Object)"value", Scope.REQUEST);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void put_value_to_session_scope() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(SimpleValueMapperTest.this.request)).getSession(true);
                this.will(6.returnValue((Object)SimpleValueMapperTest.this.session));
                ((HttpSession)this.one(SimpleValueMapperTest.this.session)).setAttribute("name", (Object)"value");
            }
        });
        this.mapping.put("name", (Object)"value", Scope.SESSION);
        this.mockery.assertIsSatisfied();
    }
}

