/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import jp.snowgoose.treno.exception.InvalidActionSuffixException;
import jp.snowgoose.treno.metadata.Suffix;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SuffixTest {
    private Suffix suffix;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
    }

    @Test
    public void testMatch() {
        this.suffix = new Suffix("");
        Assert.assertTrue((boolean)this.suffix.match("/foo/baa"));
    }

    @Test
    public void testMatch_NotMatch() {
        this.suffix = new Suffix("");
        Assert.assertFalse((boolean)this.suffix.match("/foo/baa.do"));
    }

    @Test
    public void testMatch_ExistingMatch() {
        this.suffix = new Suffix(".do");
        Assert.assertTrue((boolean)this.suffix.match("/foo/baa.do"));
    }

    @Test
    public void testMatch_ExistingNotMatch() {
        this.suffix = new Suffix(".do");
        Assert.assertFalse((boolean)this.suffix.match("/foo/baa"));
    }

    @Test
    public void testInit_StartWithoutComma() {
        this.thrown.expect(InvalidActionSuffixException.class);
        this.thrown.expectMessage(Is.is((Object)"action destinate suffix must be start with comma."));
        this.suffix = new Suffix("do");
    }

    @Test
    public void testMatch_RootPathIsAlwaysNotMatch() {
        this.suffix = Suffix.NONE;
        Assert.assertFalse((boolean)this.suffix.match("/"));
    }
}

