/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result.type;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.component.InvokerTest;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.exception.ResultEvaluationFailureException;
import jp.snowgoose.treno.junit.MockResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.result.type.Forward;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ForwardTest {
    private final Forward forward = new Forward();
    private final Mockery mockery = new JUnit4Mockery();
    private final HttpServletRequest request = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);
    private final HttpServletResponse response = (HttpServletResponse)this.mockery.mock(HttpServletResponse.class);
    private final RequestDispatcher requestDispatcher = (RequestDispatcher)this.mockery.mock(RequestDispatcher.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private MockResultDescriptor resultDesc;
    private InvokerTest.MockAction mockAction;
    private RequestContext context = (RequestContext)this.mockery.mock(RequestContext.class);
    private RequestValueMapper valueMapper = (RequestValueMapper)this.mockery.mock(RequestValueMapper.class);
    private ActionInstance actionInstance = (ActionInstance)this.mockery.mock(ActionInstance.class);

    @Before
    public void setUp() {
        this.mockAction = new InvokerTest.MockAction();
        this.resultDesc = new MockResultDescriptor();
        this.resultDesc.setResultType(Forward.class);
        this.resultDesc.setTo("/foo/baa/baz.do");
        this.resultDesc.setWhen("success");
    }

    @Test
    public void testRender() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.oneOf(ForwardTest.this.context)).getRequest();
                this.will(1.returnValue((Object)ForwardTest.this.request));
                ((HttpServletRequest)this.oneOf(ForwardTest.this.request)).getRequestDispatcher("/foo/baa/baz.do");
                this.will(1.returnValue((Object)ForwardTest.this.requestDispatcher));
                ((RequestContext)this.oneOf(ForwardTest.this.context)).getResponse();
                this.will(1.returnValue((Object)ForwardTest.this.response));
                ((RequestDispatcher)this.oneOf(ForwardTest.this.requestDispatcher)).forward((ServletRequest)ForwardTest.this.request, (ServletResponse)ForwardTest.this.response);
            }
        });
        this.mockAction.baz("snowgoose");
        this.forward.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testRender_ThrowsException() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.oneOf(ForwardTest.this.context)).getRequest();
                this.will(2.returnValue((Object)ForwardTest.this.request));
                ((HttpServletRequest)this.oneOf(ForwardTest.this.request)).getRequestDispatcher("/foo/baa/baz.do");
                this.will(2.returnValue((Object)ForwardTest.this.requestDispatcher));
                ((RequestContext)this.oneOf(ForwardTest.this.context)).getResponse();
                this.will(2.returnValue((Object)ForwardTest.this.response));
                ((RequestDispatcher)this.oneOf(ForwardTest.this.requestDispatcher)).forward((ServletRequest)ForwardTest.this.request, (ServletResponse)ForwardTest.this.response);
                this.will(2.throwException((Throwable)new ServletException()));
            }
        });
        this.mockAction.baz("snowgoose");
        this.thrown.expect(ResultEvaluationFailureException.class);
        this.thrown.expectMessage(Is.is((Object)"result evaluation failure at success : /foo/baa/baz.do"));
        this.forward.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
    }
}

