/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import jp.snowgoose.treno.util.ThreadLocalMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThreadLocalMapTest {
    private ThreadLocalMap<String, String> testTarget;

    @Before
    public void setUp() {
        this.testTarget = new ThreadLocalMap();
    }

    @Test
    public void testPutAndGet() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_1")).toString(), (Matcher)Is.is((Object)"HOGE1"));
    }

    @Test
    public void testPutAndRemove() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_1")).toString(), (Matcher)Is.is((Object)"HOGE1"));
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_2")).toString(), (Matcher)Is.is((Object)"HOGE2"));
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_3")).toString(), (Matcher)Is.is((Object)"HOGE3"));
        this.testTarget.remove((Object)"SESSION_2");
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_1")).toString(), (Matcher)Is.is((Object)"HOGE1"));
        Assert.assertNull((Object)this.testTarget.get((Object)"SESSION_2"));
        Assert.assertThat((Object)((String)this.testTarget.get((Object)"SESSION_3")).toString(), (Matcher)Is.is((Object)"HOGE3"));
    }

    @Test
    public void testPutAllAndSize() {
        HashMap<String, String> puttingMap = new HashMap<String, String>();
        puttingMap.put("SESSION_1", "HOGE1");
        puttingMap.put("SESSION_2", "HOGE2");
        puttingMap.put("SESSION_3", "HOGE3");
        this.testTarget.putAll(puttingMap);
        Assert.assertThat((Object)this.testTarget.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void testPutAllAndClear() {
        HashMap<String, String> puttingMap = new HashMap<String, String>();
        puttingMap.put("SESSION_1", "HOGE1");
        puttingMap.put("SESSION_2", "HOGE2");
        puttingMap.put("SESSION_3", "HOGE3");
        this.testTarget.putAll(puttingMap);
        this.testTarget.clear();
        Assert.assertTrue((boolean)this.testTarget.isEmpty());
        Assert.assertNull((Object)this.testTarget.get((Object)"SESSION_1"));
        Assert.assertNull((Object)this.testTarget.get((Object)"SESSION_2"));
        Assert.assertNull((Object)this.testTarget.get((Object)"SESSION_3"));
    }

    @Test
    public void testPutAndContainsKey() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Assert.assertTrue((boolean)this.testTarget.containsKey((Object)"SESSION_1"));
        Assert.assertTrue((boolean)this.testTarget.containsKey((Object)"SESSION_2"));
        Assert.assertTrue((boolean)this.testTarget.containsKey((Object)"SESSION_3"));
        Assert.assertFalse((boolean)this.testTarget.containsKey((Object)"SESSION_4"));
        Assert.assertFalse((boolean)this.testTarget.containsKey((Object)"SESSION_5"));
    }

    @Test
    public void testPutAndContainsValue() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Assert.assertTrue((boolean)this.testTarget.containsValue((Object)"HOGE1"));
        Assert.assertTrue((boolean)this.testTarget.containsValue((Object)"HOGE2"));
        Assert.assertTrue((boolean)this.testTarget.containsValue((Object)"HOGE3"));
        Assert.assertFalse((boolean)this.testTarget.containsValue((Object)"HOGE4"));
    }

    @Test
    public void testPutAndEntrySet() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Set entries = this.testTarget.entrySet();
        Assert.assertThat((Object)entries.toString(), (Matcher)Is.is((Object)"[SESSION_1=HOGE1, SESSION_2=HOGE2, SESSION_3=HOGE3]"));
    }

    @Test
    public void testPutAndKeys() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Set values = this.testTarget.keySet();
        Assert.assertArrayEquals((Object[])new Object[]{"SESSION_1", "SESSION_2", "SESSION_3"}, (Object[])values.toArray(new Object[this.testTarget.size()]));
    }

    @Test
    public void testPutAndValues() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        Collection values = this.testTarget.values();
        Assert.assertArrayEquals((Object[])new Object[]{"HOGE1", "HOGE2", "HOGE3"}, (Object[])values.toArray(new Object[this.testTarget.size()]));
    }

    @Test
    public void testReadableFromChildThread() {
        this.testTarget.put((Object)"SESSION_1", (Object)"HOGE1");
        this.testTarget.put((Object)"SESSION_2", (Object)"HOGE2");
        this.testTarget.put((Object)"SESSION_3", (Object)"HOGE3");
        new Thread(){

            public void run() {
                Assert.assertThat((Object)((String)ThreadLocalMapTest.this.testTarget.get((Object)"SESSION_1")).toString(), (Matcher)Is.is((Object)"HOGE1"));
            }
        }.start();
    }
}

