/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno;

import java.util.Collection;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.InstanceProvider;
import jp.snowgoose.treno.component.Scanner;
import jp.snowgoose.treno.config.Config;
import jp.snowgoose.treno.context.ParameterConverter;
import jp.snowgoose.treno.context.ParameterConverters;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.context.RequestValueMappers;
import jp.snowgoose.treno.exception.ActionNotRegisterdException;
import jp.snowgoose.treno.exception.ExceptionTreat;
import jp.snowgoose.treno.exception.RenoException;
import jp.snowgoose.treno.exception.ResultNotRegisterdException;
import jp.snowgoose.treno.exception.SimpleExceptionTreat;
import jp.snowgoose.treno.metadata.ActionDescriptorFactory;
import jp.snowgoose.treno.metadata.ActionDescriptors;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.DirectionTypes;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application<C extends Config> {
    private C config;
    private ActionDescriptors actionDescriptors;
    private DirectionTypes resultTypeRegistry;
    private InstanceProvider actionInstanceProvider;
    private ExceptionTreat exceptionTreat;
    private ParameterConverters parameterProxies;
    private RequestValueMappers valueMappers;

    public Application(C renoConfig) {
        this.config = renoConfig;
        InstanceProvider componentsInstanceResolver = this.getInstanceResolver(this.config.getComponentInstanceProviderClassName());
        Scanner componentsScanner = new Scanner(ClassCollector.COLLECTORS, componentsInstanceResolver);
        Scanner.Scanned components = componentsScanner.scan(this.config.getComponentPackageNames());
        this.actionInstanceProvider = this.getInstanceResolver(this.config.getActionInstanceProviderClassName());
        Scanner actionsScanner = new Scanner(ClassCollector.COLLECTORS);
        Collection<Class<?>> scannedActionClasses = actionsScanner.scan(this.config.getActionPackageNames()).getClasses(Scanner.Scanned.Conditions.annotateWith(InvokeActions.class));
        ActionDescriptorFactory foundActionDescFactory = components.getInstance(Scanner.Scanned.Conditions.implementsInterface(ActionDescriptorFactory.class), this.config.getActionDescriptorFactoryId());
        this.actionDescriptors = new ActionDescriptors(this.config.getActionPackageNames(), foundActionDescFactory, scannedActionClasses);
        Collection<DirectionType> collectedDirectionTypes = components.getInstances(Scanner.Scanned.Conditions.implementsInterface(DirectionType.class));
        this.resultTypeRegistry = new DirectionTypes(collectedDirectionTypes);
        Collection<ParameterConverter> collectedParameterProxies = components.getInstances(Scanner.Scanned.Conditions.implementsInterface(ParameterConverter.class));
        this.parameterProxies = new ParameterConverters(collectedParameterProxies);
        this.exceptionTreat = new SimpleExceptionTreat();
        Collection<RequestValueMapper> collectiodValueMappers = components.getInstances(Scanner.Scanned.Conditions.implementsInterface(RequestValueMapper.class));
        this.valueMappers = new RequestValueMappers(collectiodValueMappers);
        this.validate();
    }

    protected InstanceProvider getInstanceResolver(String className) {
        return (InstanceProvider)ClassUtils.newInstanceSilentry(className, null);
    }

    private void validate() throws RenoException {
        if (this.actionDescriptors.size() == 0) {
            throw new ActionNotRegisterdException();
        }
        if (this.resultTypeRegistry.size() == 0) {
            throw new ResultNotRegisterdException();
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public ActionDescriptors getActionDescriptors() {
        return this.actionDescriptors;
    }

    public DirectionTypes getDirectionTypes() {
        return this.resultTypeRegistry;
    }

    public void shutdown() {
    }

    public InstanceProvider getActionInstanceProvider() {
        return this.actionInstanceProvider;
    }

    public ExceptionTreat getExceptionTreat() {
        return this.exceptionTreat;
    }

    public ParameterConverters getParameterConverters() {
        return this.parameterProxies;
    }

    public RequestValueMappers getRequestValueMappers() {
        return this.valueMappers;
    }
}

