/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.io.Serializable;
import jp.snowgoose.treno.exception.InvalidActionSuffixException;
import jp.snowgoose.treno.util.StringUtils;

public class Suffix
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Suffix NONE = new Suffix("");
    public static final Suffix DEFAULT = new Suffix(".rn");
    private String suffix;
    private boolean suffixNone;

    public Suffix(String suffix) {
        if (StringUtils.isEmpty(suffix)) {
            this.suffixNone = true;
        }
        if (this.notStartWithComma(suffix) && !this.suffixNone) {
            throw new InvalidActionSuffixException();
        }
        this.suffix = suffix;
    }

    private boolean notStartWithComma(String suffix) {
        return suffix.indexOf(46) != 0;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean match(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        int index = path.lastIndexOf(47);
        String tmp = path.substring(index);
        if (this.isRootPath(path, index)) {
            return false;
        }
        if (this.suffixNone) {
            return tmp.indexOf(46) == -1;
        }
        return tmp.endsWith(this.getSuffix());
    }

    private boolean isRootPath(String path, int index) {
        return index == 0 && path.length() == 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Suffix) {
            Suffix other = (Suffix)Suffix.class.cast(obj);
            return other.suffixNone == this.suffixNone && other.suffix.equals(this.suffix);
        }
        return false;
    }

    public int hashCode() {
        return this.suffix.hashCode();
    }

    public String toString() {
        return this.suffix;
    }
}

