#!/usr/bin/env python
# -*- coding: utf-8 -*-

from lxml import etree

player = "http://video\.fc2\.com/(?:a/)?content/(?:[^/]+/)?(\w+)/?"
doc = None


def fetch(url):
  global doc
  parser = etree.HTMLParser(encoding="utf-8")
  doc = etree.parse(url, parser)


def get_html():
  global doc
  r = doc.xpath('//div[@id="main"]/div[@id="content"]/div[4]')
  player_script = etree.tostring(r[0], method="html")
  content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
%(player_script)s
</body></html>
"""
  return content % {"player_script": player_script
                    .replace("no_progressive=1", "no_progressive=0")
                    .replace("640", "100%").replace("392", "100%")}


def get_title():
  global doc
  r = doc.xpath('//title')
  title = r[0].text
  return title
