#!/usr/bin/env python
# -*- coding: utf-8 -*-

from lxml import etree

player = "http://www\.youtube\.com/watch\?v=[^&]+"
doc = None


def fetch(url):
  global doc
  parser = etree.HTMLParser(encoding="utf-8")
  doc = etree.parse(url, parser)


def get_html():
  global doc
  r = doc.xpath('//div[@id="watch-video-container"]')
  player_script = etree.tostring(r[0], method="html")
  content = """
<html><body>
<style type="text/css">* {padding: 0; margin: 0;}</style>
%(player_script)s
</body></html>
"""
  return content % {"player_script": player_script
                    .replace("38\" + \"5", "100%")
                    .replace("64\" + \"0", "100%")}


def get_title():
  global doc
  r = doc.xpath('//meta[@name="title"]/@content')
  title = r[0]
  return title
