import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import uic

form_class, base_class = uic.loadUiType(
        os.path.join(
            "plugins","hotTab","extractionConfigDialog.ui"))
class ExtractionConfigDialog(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)

        self.parent = args[0]

        self.setupUi(self)

        self.settings = QSettings("Twitturn")
        self.connectActions()

        self.loadSettings()

    def connectActions(self):
        pass

    def accept(self):
        base_class.accept(self)
        self.saveSettings()

    def loadSettings(self):
        str = QString()
        for word in self.parent.filter.textExt:
            str += word + " "
        self.textEditHot.setText(str)

        if not self.settings.value("plugins/hotTab/configured").toBool(): 
            return
        self.settings.beginGroup('plugins/hotTab')
        self.textEditNG.setText(
                self.settings.value("textEditNG").toString())
        self.comboBoxNG.setCurrentIndex(
                self.settings.value('comboBoxNG').toInt()[0])
        self.checkBoxNG.setChecked(
                self.settings.value('checkBoxNG').toBool())
        self.checkBoxNotify.setChecked(
                self.settings.value('checkBoxNotify').toBool())
        self.checkBoxHilght.setChecked(
                self.settings.value('checkBoxHilght').toBool())
        self.settings.endGroup()

    def saveSettings(self):
        self.settings.beginGroup('plugins/hotTab')
        self.settings.setValue("configured", QVariant(True))
        self.settings.setValue('textEditNG', 
                QVariant(self.textEditNG.toPlainText()))
        self.settings.setValue('comboBoxNG',
                QVariant(self.comboBoxNG.currentIndex()))
        self.settings.setValue('checkBoxNG',
                QVariant(self.checkBoxNG.isChecked()))
        self.settings.setValue('checkBoxNotify',
                QVariant(self.checkBoxNotify.isChecked()))
        self.settings.setValue('checkBoxHilght',
                QVariant(self.checkBoxHilght.isChecked()))
        self.settings.endGroup()

