/*
 * Decompiled with CFR 0.152.
 */
package jp.postclass.commons.http.filter.trimWhitespaces;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.postclass.commons.http.filter.trimWhitespaces.ByteArrayServletOutputStream;
import jp.postclass.commons.http.filter.trimWhitespaces.ByteArrayServletResponse;
import jp.postclass.commons.http.filter.trimWhitespaces.SelectableServletResponse;
import jp.postclass.commons.utils.UtilsForTag;

public class TrimWhitespacesFilter
implements Filter {
    private boolean trimNewline;

    public void init(FilterConfig config) throws ServletException {
        String trimNewline = config.getInitParameter("trimNewline");
        if (trimNewline != null && !trimNewline.isEmpty()) {
            this.trimNewline = Boolean.valueOf(trimNewline);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        SelectableServletResponse selectableResponse = new SelectableServletResponse((HttpServletResponse)servletResponse);
        try {
            chain.doFilter(servletRequest, (ServletResponse)selectableResponse);
            if (selectableResponse.getResponse() instanceof ByteArrayServletResponse) {
                ByteArrayServletOutputStream impl = (ByteArrayServletOutputStream)selectableResponse.getOutputStream();
                impl.getWriter().flush();
                impl.getOut().flush();
                String outputtedString = impl.getOut().toString();
                servletResponse.getWriter().print(UtilsForTag.trimWhiteSpacesAndNewline(outputtedString, this.trimNewline));
            }
        }
        finally {
            ByteArrayServletOutputStream impl = (ByteArrayServletOutputStream)selectableResponse.getPoolableResponse().getOutputStream();
            try {
                impl.getWriter().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                impl.getOut().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

