/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.opentxp.txf.TxF32;
import org.opentxp.txf.TxFile;
import org.opentxp.txf.TxFileTransaction;
import org.opentxp.txf.TxFileUnsupportedException;

public class TxFileInputStream
extends FileInputStream {
    public TxFileInputStream(TxFile txFile) throws FileNotFoundException, TxFileUnsupportedException, IOException {
        this(new FileDescriptor());
        this.open(txFile);
    }

    private TxFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    private void open(TxFile txFile) throws FileNotFoundException, IOException {
        boolean fLoadDLL = true;
        try {
            System.loadLibrary("TxF32");
        }
        catch (Throwable e) {
            fLoadDLL = false;
        }
        if (fLoadDLL) {
            this.open(txFile._getTrans(), txFile._getProvider(), txFile._getFile());
        } else {
            Method method = null;
            String strFileName = null;
            boolean fAccess = false;
            try {
                method = FileInputStream.class.getDeclaredMethod("open", String.class);
                fAccess = method.isAccessible();
                if (!fAccess) {
                    method.setAccessible(true);
                }
                fAccess = method.isAccessible();
                strFileName = txFile._getFile().getCanonicalPath();
                method.invoke((Object)this, strFileName);
                if (fAccess) {
                    method.setAccessible(false);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private native void open(TxFileTransaction var1, TxF32 var2, File var3) throws FileNotFoundException, TxFileUnsupportedException, IOException;
}

