/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.opentxp.txf.TxF32;
import org.opentxp.txf.TxFile;
import org.opentxp.txf.TxFileTransaction;
import org.opentxp.txf.TxFileUnsupportedException;

public class TxFileOutputStream
extends FileOutputStream {
    public TxFileOutputStream(TxFile txfile) throws FileNotFoundException, TxFileUnsupportedException, IOException {
        this(txfile, false);
    }

    public TxFileOutputStream(TxFile txfile, boolean append) throws FileNotFoundException, TxFileUnsupportedException, IOException {
        this(new FileDescriptor());
        this.open(txfile, append);
    }

    private TxFileOutputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    protected void open(TxFile txFile, boolean append) throws FileNotFoundException, TxFileUnsupportedException, IOException {
        boolean fLoadDLL = true;
        try {
            System.loadLibrary("TxF32");
        }
        catch (Throwable e) {
            fLoadDLL = false;
        }
        if (fLoadDLL) {
            if (append) {
                this.openAppend(txFile._getTrans(), txFile._getProvider(), txFile._getFile());
            } else {
                this.open(txFile._getTrans(), txFile._getProvider(), txFile._getFile());
            }
        } else {
            Method method = null;
            String strFileName = null;
            boolean fAccess = false;
            try {
                method = FileOutputStream.class.getDeclaredMethod("open", String.class);
                fAccess = method.isAccessible();
                if (!fAccess) {
                    method.setAccessible(true);
                }
                fAccess = method.isAccessible();
                strFileName = txFile._getFile().getCanonicalPath();
                method.invoke((Object)this, strFileName);
                if (fAccess) {
                    method.setAccessible(false);
                }
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private native void open(TxFileTransaction var1, TxF32 var2, File var3) throws FileNotFoundException, TxFileUnsupportedException, IOException;

    private native void openAppend(TxFileTransaction var1, TxF32 var2, File var3) throws FileNotFoundException, TxFileUnsupportedException, IOException;
}

