/*
 * Decompiled with CFR 0.152.
 */
package org.opentxp.txf;

import org.opentxp.txf.KTM32;
import org.opentxp.txf.TxFileTransactionException;
import org.opentxp.txf.Win32Error;

public class TxFileTransaction {
    public static String NULL_TRANSACTION_ID = "NULL_TRANSACTION";
    public static TxFileTransaction NULL_TRANSACTION = new TxFileTransaction(new byte[0]);
    private static String ERROR_ALREADY_CLOSED = "This transaction is already closed.";
    private byte[] abTransactionHandle_ = null;
    private int nLengthOfTransactionHandle_ = -1;

    private synchronized byte[] getTransactionHandle() {
        return this.abTransactionHandle_;
    }

    private synchronized int getLengthOfTransactionHandle() {
        return this.nLengthOfTransactionHandle_;
    }

    private synchronized byte[] setTransactionHandle(byte[] abTransactionHandle, int nLengthOfTransactionHandle) {
        byte[] bak = this.abTransactionHandle_;
        this.abTransactionHandle_ = abTransactionHandle;
        this.nLengthOfTransactionHandle_ = nLengthOfTransactionHandle;
        return bak;
    }

    private TxFileTransaction() {
    }

    private TxFileTransaction(byte[] abTransactionHandle) {
        this.abTransactionHandle_ = abTransactionHandle;
        this.nLengthOfTransactionHandle_ = null != abTransactionHandle ? abTransactionHandle.length : -1;
    }

    protected void finalize() {
        try {
            if (null != this.getTransactionHandle()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkSequence() {
        if (null == this.getTransactionHandle()) {
            throw new IllegalStateException(ERROR_ALREADY_CLOSED);
        }
    }

    public boolean isValid() {
        boolean fRet = true;
        if (null == this.getTransactionHandle()) {
            fRet = false;
        }
        return fRet;
    }

    public static TxFileTransaction begin() {
        TxFileTransaction trans = null;
        try {
            trans = KTM32.begin();
        }
        catch (Throwable e) {
            trans = null;
        }
        if (null == trans) {
            trans = NULL_TRANSACTION;
        }
        return trans;
    }

    public void close() {
        int nRet = Win32Error.UNKNOWN_ERROR;
        if (NULL_TRANSACTION == this) {
            return;
        }
        if (null == this.getTransactionHandle()) {
            return;
        }
        nRet = KTM32.close(this);
    }

    public void commit() throws TxFileTransactionException {
        int nRet = Win32Error.UNKNOWN_ERROR;
        if (NULL_TRANSACTION == this) {
            return;
        }
        this.checkSequence();
        nRet = KTM32.commit(this);
        if (Win32Error.NO_ERROR != nRet) {
            String str = String.format("Win32 error (%d) : %s", nRet, "");
            throw new TxFileTransactionException(str);
        }
    }

    public void rollback() throws TxFileTransactionException {
        int nRet = Win32Error.UNKNOWN_ERROR;
        if (NULL_TRANSACTION == this) {
            return;
        }
        this.checkSequence();
        nRet = KTM32.rollback(this);
        if (Win32Error.NO_ERROR != nRet) {
            String str = String.format("Win32 error (%d) : %s", nRet, "");
            throw new TxFileTransactionException(str);
        }
    }

    public String getTransactionId() throws TxFileTransactionException {
        String strTransactionId = null;
        this.checkSequence();
        strTransactionId = NULL_TRANSACTION != this ? KTM32.getTransactionId(this) : NULL_TRANSACTION_ID;
        return strTransactionId;
    }

    public static TxFileTransaction open(String strTransactionId) {
        TxFileTransaction trans = null;
        if (null == strTransactionId) {
            throw new NullPointerException("strTransactionId");
        }
        trans = KTM32.open(strTransactionId);
        return trans;
    }

    public void recover() throws TxFileTransactionException {
        int nRet = Win32Error.UNKNOWN_ERROR;
        if (NULL_TRANSACTION == this) {
            return;
        }
        this.checkSequence();
        nRet = KTM32.recover(this);
        if (Win32Error.NO_ERROR != nRet) {
            String str = String.format("Win32 error (%d) : %s", nRet, "");
            throw new TxFileTransactionException(str);
        }
    }

    public void forget() throws TxFileTransactionException {
        int nRet = Win32Error.UNKNOWN_ERROR;
        if (NULL_TRANSACTION == this) {
            return;
        }
        this.checkSequence();
        nRet = KTM32.forget(this);
        if (Win32Error.NO_ERROR != nRet) {
            String str = String.format("Win32 error (%d) : %s", nRet, "");
            throw new TxFileTransactionException(str);
        }
    }

    public static boolean canTransaction() {
        boolean fRet = false;
        try {
            fRet = KTM32.canTransaction();
        }
        catch (Throwable e) {
            fRet = false;
        }
        return fRet;
    }
}

