/**********************************************************************
 * core.c                                                   August 2005
 *
 * ASYM: An implementation of Asymetric Cryptography in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#define __KERNEL_SYSCALLS__

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>

#include "pk.h"
#include "base64.h"
#include "test_util.h"
#include "unsx.h"

#define KSSL_DAEMON_NAME "asym"

#ifndef VERSION
#define "unknown"
#endif

static int __init asym_init(void)
{
	printk(KERN_NOTICE "asym: (C) Jean-Luc Cooke <jlcooke@certainkey.com>. "
			"Version %s. Build %s %s\n", VERSION, 
			__DATE__, __TIME__);
	return(0);
}


static void __exit asym_cleanup(void)
{
	;
}

EXPORT_SYMBOL_GPL(pk_getKeyID);
EXPORT_SYMBOL_GPL(pk_keygen);
EXPORT_SYMBOL_GPL(pk_encrypt);
EXPORT_SYMBOL_GPL(pk_decrypt);
EXPORT_SYMBOL_GPL(pk_verify);
EXPORT_SYMBOL_GPL(pk_sign);
EXPORT_SYMBOL_GPL(pk_errstr);
EXPORT_SYMBOL_GPL(pk_init);
EXPORT_SYMBOL_GPL(pk_deinit);

EXPORT_SYMBOL_GPL(base64_encode);
EXPORT_SYMBOL_GPL(base64_decode);

EXPORT_SYMBOL_GPL(asym_print_char);
EXPORT_SYMBOL_GPL(asym_print_unsx);
EXPORT_SYMBOL_GPL(unsx_stackMaxDepth);
EXPORT_SYMBOL_GPL(unsx_stack);

module_init(asym_init);
module_exit(asym_cleanup);
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("RSA and EGAMAL");
MODULE_AUTHOR("Jean-Luc Cooke <jlcooke@certainkey.com>");
