/**********************************************************************
 * key_tool.h                                               August 2005
 *
 * KSSLD(key_tool): An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSL_KEY_TOOL_H
#define KSSL_KEY_TOOL_H

#include <vanessa_logger.h>
#include <vanessa_socket.h>

#include "kssl.h"

#define ACTION_GET      1
#define ACTION_GET_STR  "get"
#define ACTION_SET      2
#define ACTION_SET_STR  "set"

#define CMD_RSA                        1
#define CMD_RSA_STR                    "rsa"
#define CMD_DSA                        2
#define CMD_DSA_STR                    "dsa"
#define CMD_DH                         3
#define CMD_DH_STR                     "dh"
#define CMD_REAL                       4
#define CMD_REAL_STR                   "real"
#define CMD_CIPHERS                    5
#define CMD_CIPHERS_STR                "ciphers"
#define CMD_AVAILABLE_CIPHERS          6
#define CMD_AVAILABLE_CIPHERS_STR      "available_ciphers"
#define CMD_MODE                       7
#define CMD_MODE_STR                   "mode"
#define CMD_ASYM_METHODS               8
#define CMD_ASYM_METHODS_STR           "asym_methods"
#define CMD_AVAILABLE_ASYM_METHODS     9
#define CMD_AVAILABLE_ASYM_METHODS_STR "available_asym_methods"
#define CMD_DEL_DAEMON                 10
#define CMD_DEL_DAEMON_STR             "del_daemon"
#define CMD_ADD_DAEMON                 11
#define CMD_ADD_DAEMON_STR             "add_daemon"
#define CMD_DAEMONS                    12
#define CMD_DAEMONS_STR                "daemons"
#define CMD_FLUSH                      13
#define CMD_FLUSH_STR                  "flush"

extern vanessa_logger_t *vl;

int key_tool_to_kernel(int cmd, const char *arg_1, const char *arg_2,
		const char *arg_3);

int key_tool_from_kernel(int cmd, const char *arg_1, const char *arg_2,
		const char *arg_3);

int key_tool_parse_server(const char *str, struct sockaddr_in *addr);

int key_tool_write_head(kssl_ctl_t *ctl, const char *vserver);


#endif /* KSSL_KEY_TOOL_H */
