/**********************************************************************
 * aep.h                                                    August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef KSSLD_AEP_H
#define KSSLD_AEP_H

#include <linux/kernel.h>

#define KSSL_AEP_REVERSE 0x1

int kssl_aep_msg_make_req_crt(u64 id, u64 handle, const u8 *a, size_t a_len,
		const u8 *p, size_t p_len, const u8 *q, size_t q_len,
		const u8 *dmpi, size_t dmpi_len,
		const u8 *dmqi, size_t dmqi_len,
		const u8 *iqmp, size_t iqmp_len,
		u8 *buf, size_t *buf_len, u32 flag);

int kssl_aep_msg_make_req(u64 id, u64 handle, const u8 *b, size_t b_len,
		const u8 *e, size_t e_len, const u8 *n, size_t n_len,
		u8 *buf, size_t *buf_len, u32 flag);

ssize_t kssl_aep_write(void *buf, size_t len);

ssize_t kssl_aep_read(void *buf, size_t len);

void kssl_aep_reverse_8(u8 *dst, const u8 *src, size_t len);


static inline int
kssl_aep_init(void)
{
	        return 0;
}

void kssl_aep_cleanup(void);

#endif /* KSSLD_AEP_H */
