/**********************************************************************
 * change_cipher_spec_t.h                                   August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based in part on code from LVS www.linuxvirtualserver.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _CHANGE_CIPHER_SPEC_T_H
#define _CHANGE_CIPHER_SPEC_T_H


/**********************************************************************
 * Change Cipher Spec
 **********************************************************************/

typedef enum {
	ccst_change_cipher_spec=1,
	ccst_last=255
} change_cipher_spec_type_t;

typedef struct {
	change_cipher_spec_type_t type;
} change_cipher_spec_t;

/* buf must be at least 1 byte long */
static inline void change_cipher_spec_to_buf(const change_cipher_spec_t *ccs, 
		u8 *buf)
{
	*buf = ccs->type;
}

/* buf must be at least 1 byte long */
static inline void change_cipher_spec_from_buf(change_cipher_spec_t *ccs, 
		const u8 *buf)
{
	ccs->type = *buf;
}

#define CHANGE_CIPHER_SPEC_NLEN 1

#endif /* _CHANGE_CIPHER_SPEC_T_H */

