/**********************************************************************
 * ssl3mac_vectors.h                                        August 2005
 *
 * KSSLD: An implementation of SSL/TLS in the Linux Kernel
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This file based on tcrypt.h from Linux 2.4.73
 * Copyright (c) 2002 James Morris <jmorris@intercode.com.au>
 * Copyright (c) 2002 Jean-Francois Dive <jef@linuxbe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 **********************************************************************/

#ifndef _SSL3MAC_VECTORS_H
#define _SSL3MAC_VECTORS_H

#ifndef MD5_DIGEST_SIZE
#define MD5_DIGEST_SIZE		16
#endif /* MD5_DIGEST_SIZE */
#ifndef SHA1_DIGEST_SIZE
#define SHA1_DIGEST_SIZE	20
#endif /* SHA1_DIGEST_SIZE */

/*
 * SSL3MAC-MD5 test vectors
 */
#define SSL3MAC_MD5_TEST_VECTORS1	7
#define SSL3MAC_MD5_TEST_VECTORS2	3
#define SSL3MAC_MD5_TEST_VECTORS3	5

struct ssl3mac_md5_testvec {
	unsigned char key[128];
	unsigned int key_len;
	unsigned char plaintext[276];
	unsigned int plaintext_len;
	unsigned char digest[MD5_DIGEST_SIZE];
}; 

#define SSL3MAC_MD5_TEST_COMMENT1                                           \
	"SSL3MAC-MD5 Test Vectors: ssl3mac_md5_tv_template1\n"              \
	"Derived from HMAC-MD5 test vectors from RFC2202\n"                 \
	"with digests emperically derived using ssl3mac_test\n"  

struct ssl3mac_md5_testvec ssl3mac_md5_tv_template1[] =
{
	{
		{ 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
		  0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },

		0x0010,
		  
		"Hi There",

		0x0008,
		
		{ 0x43, 0x1c, 0x09, 0x21, 0x03, 0x7c, 0x83, 0xdb, 
		  0x0c, 0x22, 0xb1, 0x7f, 0xb6, 0x97, 0x4f, 0x9c }
	},
	{
		{ 'J', 'e', 'f', 'e' },

		0x0004,
		
		"what do ya want for nothing?",

		0x001c,
		
		{ 0xee, 0xdf, 0x61, 0x61, 0x96, 0x73, 0xb6, 0x93, 
		  0x92, 0xba, 0x6c, 0x76, 0x5f, 0x07, 0x90, 0x27 }
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x10,
		  
		{ 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd },

		0x32,
		  
		{  0xf5, 0x75, 0x81, 0x28, 0xd7, 0x6f, 0xe9, 0x1f,
		   0x95, 0x28, 0xa1, 0x0c, 0xf7, 0x5d, 0xa0, 0x82 },
	},
	
	{
		{ 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		  0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 
		  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19 },

		0x19,

		  
		{ 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd },

		0x32,
		  
		{ 0x78, 0x4f, 0x44, 0x4e, 0xda, 0xa1, 0x1d, 0x5c, 
		  0x51, 0xb1, 0x36, 0xb1, 0xed, 0x9b, 0x8c, 0xea },
	},
	
	{
		{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
		  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },

		0x10,
		  
		"Test With Truncation",

		0x14,
		
		{ 0xda, 0x48, 0xdf, 0xd1, 0x5a, 0xf8, 0x65, 0xbd, 
		  0x61, 0xae, 0x7c, 0xb2, 0x93, 0x60, 0x1a, 0x0c },
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x50,
		  
		"Test Using Larger Than Block-Size Key - Hash Key First",

		0x54,
		
		{ 0x28, 0x70, 0xc1, 0xaf, 0x5c, 0x7e, 0x62, 0x6a, 
		  0x1b, 0x21, 0x43, 0x69, 0xf2, 0x12, 0xc5, 0x79 }
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x50,
		
		"Test Using Larger Than Block-Size Key and Larger Than One "
		"Block-Size Data",

		0x49,
		
		{ 0x0c, 0x48, 0xbf, 0x66, 0xbd, 0x5d, 0xa7, 0x37, 
		  0x34, 0xc0, 0x6d, 0xe1, 0x6b, 0x42, 0x92, 0x14 }
	},
	
	/* cross page test, need to retain key */
	{
		{ 'J', 'e', 'f', 'e' },

		0x0004,
		
		"what do ya want for nothing?",

		0x001c,
		
		{ 0xee, 0xdf, 0x61, 0x61, 0x96, 0x73, 0xb6, 0x93, 
		  0x92, 0xba, 0x6c, 0x76, 0x5f, 0x07, 0x90, 0x27 }
	},
};


#define SSL3MAC_MD5_TEST_COMMENT2                                           \
	"SSL3MAC-MD5 Test Vectors: ssl3mac_md5_tv_template2\n"              \
	"From post to sci.crypt by  Thomas Pornin (pornin@nerim.net)\n"     \
	"on 2003-06-11. He derived these vectors using OpenSSL's\n"         \
	"SSLv3 implementation."

struct ssl3mac_md5_testvec ssl3mac_md5_tv_template2[] =
{
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef },

		0x0010,
		  
		{ 0x00 },

		0x0001,
		
		{ 0xa8, 0x56, 0x43, 0x0a, 0xf0, 0x77, 0xae, 0x2c, 
		  0x32, 0x8d, 0x9f, 0xfe, 0x4e, 0x56, 0x81, 0x3a }
	},
	    
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef },

		0x0010,
		
		{ 0x01 },

		0x0001,
		
		{ 0x96, 0x27, 0x9d, 0x16, 0xe7, 0x81, 0x2e, 0xdd, 
		  0xa2, 0xec, 0x64, 0xda, 0xc9, 0x96, 0x34, 0x8f }
	},
	
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef },

		0x0010,

		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef },

		0x50,
		  
		{ 0x47, 0x50, 0x06, 0xc7, 0xdc, 0x7a, 0x3f, 0x37, 
		  0x13, 0x52, 0xd9, 0x48, 0xb4, 0xbe, 0x95, 0x0e }
	}
};


#define SSL3MAC_MD5_TEST_COMMENT3                                            \
"SSL3MAC-MD5 Test Vectors: ssl3mac_md5_tv_template3\n"                       \
"Derived from http://wp.netscape.com/eng/ssl3/traces/trc-clnt-ex.html\n"     \
"with digests emperically derived using ssl3mac_test\n"

/* Plaintext is comprised of the following concatenated together:
 * uint8_t type
 * uint64_t sequence_number
 * uint16_t length (of content)
 * uint8_t[] content
 *
 * Byte order is from most significant to least significant.
 *
 * In the examples given on
 * http://wp.netscape.com/eng/ssl3/traces/trc-clnt-ex.html
 * the type, sequence_number and length are concatenated
 * into a single value, temp.
 */

struct ssl3mac_md5_testvec ssl3mac_md5_tv_template3[] =
{
	
	/* From http://wp.netscape.com/eng/ssl3/traces/
	 *      trc-clnt-ex.html#ClientChangeCipherSpec1 */
	{
		{ 0x18, 0x2a, 0x75, 0x51, 0xf8, 0x9f, 0x5c, 0xf9,
		  0x5c, 0x90, 0x0d, 0x0d, 0x76, 0x2f, 0x1e, 0x9e },

		  0x0010,
		  
		{ 0x00,                                           /* type */
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, /* seq_num */
		  0x00, 0x28,                                     /* length */
		  0x14, 0x00, 0x00, 0x24, 0xf2, 0x40, 0x10, 0x3f, /* content */
		  0x74, 0x63, 0xea, 0xe8, 0x7a, 0x27, 0x23, 0x56,
		  0x5f, 0x59, 0x07, 0xd2, 0xa3, 0x79, 0x5d, 0xb7, 
		  0x8b, 0x94, 0xdb, 0xcf, 0xfa, 0xf5, 0x18, 0x22,
		  0x15, 0x7b, 0xf2, 0x4a, 0x96, 0x52, 0x9a, 0x0e },

		  0x0033,
		
		{ 0xd3, 0x09, 0xde, 0x28, 0x84, 0xa7, 0x07, 0x5c, 
		  0x7c, 0x0c, 0x08, 0x85, 0x6b, 0x4f, 0x63, 0x04 }
	},

	/* From http://wp.netscape.com/eng/ssl3/traces/
	 *      trc-clnt-ex.html#ServerFinished1 */
	{
		{ 0x33, 0x70, 0x58, 0x28, 0xf9, 0x05, 0x03, 0x85, 
		  0x5b, 0x9d, 0xac, 0x39, 0x63, 0xc9, 0xe6, 0x9c },
		
		0x0010,

		{ 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 
		  0x00, 0x28, 
		  0x14, 0x00, 0x00, 0x24, 0xb7, 0xcc, 0xd6, 0x05, 
		  0x6b, 0xfc, 0xfa, 0x6d, 0xfa, 0xdd, 0x76, 0x81, 
		  0x45, 0x36, 0xe4, 0xf4, 0x26, 0x35, 0x72, 0x2c, 
		  0xec, 0x87, 0x62, 0x1f, 0x55, 0x08, 0x05, 0x4f, 
		  0xc8, 0xf5, 0x7c, 0x49, 0xe2, 0xee, 0xc5, 0xba },

		0x0033,

		{ 0xbd, 0x69, 0x27, 0x3b, 0xd0, 0x13, 0x23, 0x52, 
		  0xed, 0xec, 0x11, 0x55, 0xd8, 0xb9, 0x90, 0x8c }
	},

	/* From http://wp.netscape.com/eng/ssl3/traces/
	 *      trc-clnt-ex.html#HttpRequest1 */
	{
		{ 0x18, 0x2a, 0x75, 0x51, 0xf8, 0x9f, 0x5c, 0xf9, 
		  0x5c, 0x90, 0x0d, 0x0d, 0x76, 0x2f, 0x1e, 0x9e },

		0x0010,

		{ 0x00, 
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x17, 
		  0x00, 0xf9, 
		  0x47, 0x45, 0x54, 0x20, 0x2f, 0x62, 0x61, 0x72,
		  0x20, 0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e,
		  0x30, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
		  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x4b, 
		  0x65, 0x65, 0x70, 0x2d, 0x41, 0x6c, 0x69, 0x76, 
		  0x65, 0x0d, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x2d, 
		  0x41, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x20, 0x4d, 
		  0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61, 0x2f, 0x34, 
		  0x2e, 0x30, 0x32, 0x20, 0x5b, 0x65, 0x6e, 0x5d, 
		  0x20, 0x28, 0x57, 0x69, 0x6e, 0x4e, 0x54, 0x3b, 
		  0x20, 0x49, 0x29, 0x0d, 0x0a, 0x48, 0x6f, 0x73, 
		  0x74, 0x3a, 0x20, 0x62, 0x69, 0x6a, 0x6f, 0x75, 
		  0x2e, 0x6d, 0x63, 0x6f, 0x6d, 0x2e, 0x63, 0x6f, 
		  0x6d, 0x3a, 0x31, 0x39, 0x39, 0x39, 0x0d, 0x0a, 
		  0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x3a, 0x20, 
		  0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x67, 0x69, 
		  0x66, 0x2c, 0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 
		  0x2f, 0x78, 0x2d, 0x78, 0x62, 0x69, 0x74, 0x6d, 
		  0x61, 0x70, 0x2c, 0x20, 0x69, 0x6d, 0x61, 0x67, 
		  0x65, 0x2f, 0x6a, 0x70, 0x65, 0x67, 0x2c, 0x20, 
		  0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x70, 0x6a, 
		  0x70, 0x65, 0x67, 0x2c, 0x20, 0x2a, 0x2f, 0x2a, 
		  0x0d, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 
		  0x2d, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 
		  0x65, 0x3a, 0x20, 0x65, 0x6e, 0x2d, 0x55, 0x53, 
		  0x2c, 0x65, 0x6e, 0x2d, 0x47, 0x42, 0x2c, 0x65, 
		  0x6e, 0x0d, 0x0a, 0x41, 0x63, 0x63, 0x65, 0x70, 
		  0x74, 0x2d, 0x43, 0x68, 0x61, 0x72, 0x73, 0x65, 
		  0x74, 0x3a, 0x20, 0x69, 0x73, 0x6f, 0x2d, 0x38, 
		  0x38, 0x35, 0x39, 0x2d, 0x31, 0x2c, 0x2a, 0x2c, 
		  0x75, 0x74, 0x66, 0x2d, 0x38, 0x0d, 0x0a, 0x0d, 
		  0x0a },

		0x0104,

		{ 0x4b, 0x2d, 0x6c, 0x5e, 0x5c, 0x1b, 0xbd, 0xd7, 
	 	  0x26, 0x56, 0x57, 0x27, 0x43, 0xb8, 0xc8, 0x7c }
	},

	/* From http://wp.netscape.com/eng/ssl3/traces/
	 *      trc-clnt-ex.html#HttpResponse1 */
	{
		{ 0x33, 0x70, 0x58, 0x28, 0xf9, 0x05, 0x03, 0x85, 
		  0x5b, 0x9d, 0xac, 0x39, 0x63, 0xc9, 0xe6, 0x9c },

		0x10,

		{ 0x00, 
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x17, 
		  0x00, 0x05, 
		  0x66, 0x6f, 0x6f, 0x0a, 0x00 },

		0x10,

		{ 0x29, 0xfb, 0xd4, 0x6a, 0x8e, 0x13, 0x11, 0xa8, 
		  0x6e, 0x46, 0xe0, 0xf5, 0x8b, 0xc3, 0x25, 0x3d }
	},

	/* From http://wp.netscape.com/eng/ssl3/traces/
	 *      trc-clnt-ex.html#ClientCloseAlert2 */
	{
		{ 0xf9, 0xd7, 0x07, 0x66, 0x12, 0xe8, 0x2b, 0x00, 
		  0x5d, 0x20, 0x8a, 0x0b, 0xcb, 0xff, 0xde, 0x9e },

		  0x0010,

		{ 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x15,
		  0x00, 0x02,
		  0x01, 0x00 },

		  0x000d,

		{ 0x49, 0xfa, 0xa9, 0x29, 0x54, 0x70, 0xb6, 0xc2, 
		  0x4e, 0xcd, 0x09, 0x27, 0x96, 0xc6, 0x67, 0x77 }
	}
};


#define SSL3MAC_SHA1_TEST_VECTORS1	7
#define SSL3MAC_SHA1_TEST_VECTORS2	3

struct ssl3mac_sha1_testvec {
	unsigned char key[128];
	unsigned int key_len;
	unsigned char plaintext[128];
	unsigned int plaintext_len;
	unsigned char digest[SHA1_DIGEST_SIZE];
};

#define SSL3MAC_SHA1_TEST_COMMENT1                                           \
	"SSL3MAC-SHA1 test vectors: ssl3mac_sha1_tv_template1\n"             \
	"Derived from HMAC-SHA1 test vectors from RFC2202\n"                 \
	"with digests emperically derived using ssl3mac_test\n"

struct ssl3mac_sha1_testvec ssl3mac_sha1_tv_template1[] = {
	
	{
		{ 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
		  0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b },

		0x0014,
		  
		"Hi There",

		0x0008,

		{ 0x6d, 0x3f, 0xc6, 0xea, 0x32, 0x19, 0x75, 0x5a, 
		  0x20, 0x2d, 0xcb, 0x9b, 0xe8, 0x62, 0xce, 0x0c, 
		  0xd6, 0x97, 0x75, 0xbc }
	},
	    
	{
		{ 'J', 'e', 'f', 'e' },

		0x0004,
		
		"what do ya want for nothing?",

		0x001c,

		{ 0x9e, 0x78, 0x4a, 0xb1, 0xe2, 0xa9, 0x7e, 0x08, 
		  0xd3, 0x26, 0x26, 0x6c, 0x02, 0x6b, 0x9a, 0xc4, 
		  0x3a, 0x2f, 0x0b, 0x41 }
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x0014,

		  
		{ 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
		  0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd },

		0x32,
		  
		{ 0xf0, 0x7a, 0xbf, 0x74, 0x24, 0x19, 0xfd, 0x48, 
		  0x5f, 0xd2, 0x53, 0xbe, 0xf5, 0x93, 0x57, 0x58, 
		  0x9d, 0x6a, 0xc4, 0x1d }
	},
	
	{
		{ 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
		  0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 
		  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19 },

		0x19,
		  
		{ 
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
		  0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd },

		0x32,
		  
		{ 0x0e, 0x80, 0x47, 0x3f, 0x11, 0x95, 0x36, 0xd2, 
		  0x1e, 0x68, 0x73, 0x15, 0x51, 0xed, 0x9f, 0xc8, 
		  0xe0, 0xb9, 0x5e, 0x09 }
	},
	
	{
		{ 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
		  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c },

		0x14,
		  
		"Test With Truncation",

		0x14,
		
		{ 0x2e, 0x9d, 0x43, 0x32, 0xa6, 0x7d, 0x3e, 0xb3, 
		  0x0f, 0xe1, 0x78, 0xe2, 0x87, 0x0a, 0x8a, 0xa2, 
		  0xb0, 0xf7, 0xbc, 0x13 }
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x0050,
		  
		"Test Using Larger Than Block-Size Key - Hash Key First",

		0x0036,
		
		{ 0xb3, 0x80, 0xa6, 0xb4, 0xd0, 0x85, 0xbf, 0xa1, 
		  0x14, 0xb3, 0xd0, 0x1f, 0x19, 0xfa, 0x0b, 0x1b, 
		  0x4f, 0x77, 0x14, 0xd4 }
	},
	
	{
		{ 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
		  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa },

		0x0050,
		
		"Test Using Larger Than Block-Size Key and Larger Than One "
		"Block-Size Data",

		0x0049,
		
		{ 0xd6, 0x7e, 0xde, 0xf1, 0xcf, 0xc9, 0x6c, 0x57, 
		  0xf7, 0x21, 0xc4, 0xf4, 0x47, 0xe6, 0xed, 0x0b, 
		  0xd2, 0xae, 0xbb, 0xcc }
	},
	
	/* cross page test */
	{
		{ 'J', 'e', 'f', 'e' },

		0x0004,
		
		"what do ya want for nothing?",

		0x001c,

		{ 0x9e, 0x78, 0x4a, 0xb1, 0xe2, 0xa9, 0x7e, 0x08, 
		  0xd3, 0x26, 0x26, 0x6c, 0x02, 0x6b, 0x9a, 0xc4, 
		  0x3a, 0x2f, 0x0b, 0x41 }

	},

};


#define SSL3MAC_SHA1_TEST_COMMENT2                                           \
	"SSL3MAC-SHA1 Test Vectors: ssl3mac_md5_tv_template2\n"              \
	"From post to sci.crypt by  Thomas Pornin (pornin@nerim.net)\n"      \
	"on 2003-06-11. He derived these vectors using OpenSSL's\n"          \
	"SSLv3 implementation.\n"

struct ssl3mac_sha1_testvec ssl3mac_sha1_tv_template2[] =
{
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
		  0x01, 0x23, 0x45, 0x67 },

		0x0014,
		  
		{ 0x00 },

		0x0001,
		
		{ 0xdd, 0x2b, 0xa1, 0xf4, 0xa7, 0x21, 0xf2, 0x2c, 
		  0x8a, 0x9b, 0xa7, 0x35, 0x0b, 0x5c, 0xd6, 0x83, 
		  0x8b, 0x22, 0x58, 0x27 }
	},
	    
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
		  0x01, 0x23, 0x45, 0x67 },

		0x0014,
		
		{ 0x01 },

		0x0001,
		
		{ 0xcd, 0x62, 0x89, 0xa1, 0xfe, 0xc0, 0xbb, 0x10, 
		  0x4c, 0x27, 0x1b, 0xe4, 0x88, 0x34, 0x3b, 0xa9, 
		  0x23, 0x28, 0xb0, 0x73 }
	},
	
	{
		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
		  0x01, 0x23, 0x45, 0x67 },

		0x0014,

		{ 0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef, 
		  0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef },

		0x50,
		  
		{ 0x98, 0xe5, 0x23, 0xea, 0xde, 0x38, 0xb3, 0xbf, 
		  0x4e, 0xbf, 0x51, 0xd7, 0xee, 0x81, 0x43, 0x16, 
		  0xc9, 0xeb, 0x31, 0x59 }
	}
};



#endif	/* _SSL3MAC_VECTORS_H */
