/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of SSLeay.xs. Do not edit this file, edit SSLeay.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SSLeay.xs"
/*
 * $Id: SSLeay.xs,v 1.2 2000/05/10 16:37:25 ben Exp $
 * Copyright 1998 Gisle Aas.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the same terms as Perl itself.
 */

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* build problem under openssl 0.9.6 and some builds of perl 5.8.x */
#ifndef PERL5
#define PERL5 1
#endif

/* ssl.h or openssl/ssl.h is included from the crypt_ssleay_version
 * file which is written when building with perl Makefile.PL
 * #include "ssl.h"
 */
#include "crypt_ssleay_version.h"

#undef Free /* undo namespace pollution from crypto.h */
#ifdef __cplusplus
}
#endif


/* moved this out to Makefile.PL so user can 
 * see value being used printed during build
 * #if SSLEAY_VERSION_NUMBER >= 0x0900
 * #define CRYPT_SSL_CLIENT_METHOD SSLv3_client_method()
 * #else
 * #define CRYPT_SSL_CLIENT_METHOD SSLv2_client_method()
 * #endif
 */


static void InfoCallback(SSL *s,int where,int ret)
    {
    char *str;
    int w;

    w = where & ~SSL_ST_MASK;

    if(w & SSL_ST_CONNECT)
       str="SSL_connect";
    else if(w & SSL_ST_ACCEPT)
       str="SSL_accept";
    else
       str="undefined";

    if(where & SSL_CB_LOOP)
       fprintf(stderr,"%s:%s\n",str,SSL_state_string_long(s));
    else if(where & SSL_CB_ALERT)
       {
       str=(where & SSL_CB_READ)?"read":"write";
       fprintf(stderr,"SSL3 alert %s:%s:%s\n",str,
               SSL_alert_type_string_long(ret),
               SSL_alert_desc_string_long(ret));
       }
    else if(where & SSL_CB_EXIT)
       {
       if(ret == 0)
         fprintf(stderr,"%s:failed in %s\n",str,SSL_state_string_long(s));
       else if (ret < 0)
         fprintf(stderr,"%s:error in %s\n",str,SSL_state_string_long(s));
       }
    }

#line 85 "SSLeay.c"
XS(XS_Crypt__SSLeay__Err_get_error_string); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Err_get_error_string)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Err::get_error_string()");
    {
	char *	RETVAL;
	dXSTARG;
#line 84 "SSLeay.xs"
    unsigned long l;
    char buf[1024];

    if(!(l=ERR_get_error()))
       RETVAL=NULL;
    else
       {
       ERR_error_string(l,buf);
       RETVAL=buf;
       }
#line 106 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_new)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::new(packname, ssl_version)");
    {
	SV*	packname = ST(0);
	int	ssl_version = (int)SvIV(ST(1));
	SSL_CTX *	RETVAL;
#line 104 "SSLeay.xs"
	SSL_CTX* ctx;
	static int bNotFirstTime;
	char buf[1024];
        int rand_bytes_read;

	if(!bNotFirstTime) {
               SSLeay_add_all_algorithms();
               SSL_load_error_strings();
               ERR_load_crypto_strings();
	       bNotFirstTime = 1;
        }

        /**** Code from Devin Heitmueller, 10/3/2002 ****/
        /**** Use /dev/urandom to seed if available  ****/
        rand_bytes_read = RAND_load_file("/dev/urandom", 1024);
        if (rand_bytes_read <= 0) {
		/* Couldn't read /dev/urandom, just seed off
		   of the stack variable (the old way) */
	        RAND_seed(buf,sizeof buf);
	}

	if(ssl_version == 23) {
		ctx = SSL_CTX_new(SSLv23_client_method());
	} else if(ssl_version == 3) {
		ctx = SSL_CTX_new(SSLv3_client_method());
	} else {
		/* v2 is the default */
		ctx = SSL_CTX_new(SSLv2_client_method());
	}		
	SSL_CTX_set_options(ctx,SSL_OP_ALL|0);

	SSL_CTX_set_default_verify_paths(ctx);
	SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);

	RETVAL = ctx;

#line 159 "SSLeay.c"
	ST(0) = sv_newmortal();
        sv_setref_pv(ST(0), "Crypt::SSLeay::CTX", (void*)RETVAL);

    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_free); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_free)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::free(ctx)");
    {
	SSL_CTX*	ctx;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");

	SSL_CTX_free(ctx);
    }
    XSRETURN_EMPTY;
}

XS(XS_Crypt__SSLeay__CTX_set_cipher_list); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_set_cipher_list)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::set_cipher_list(ctx, ciphers)");
    {
	SSL_CTX*	ctx;
	char*	ciphers = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");

	RETVAL = SSL_CTX_set_cipher_list(ctx, ciphers);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_use_certificate_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_use_certificate_file)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::use_certificate_file(ctx, filename, mode)");
    {
	SSL_CTX*	ctx;
	char*	filename = (char *)SvPV_nolen(ST(1));
	int	mode = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");

	RETVAL = SSL_CTX_use_certificate_file(ctx, filename, mode);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_use_PrivateKey_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_use_PrivateKey_file)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::use_PrivateKey_file(ctx, filename, mode)");
    {
	SSL_CTX*	ctx;
	char*	filename = (char *)SvPV_nolen(ST(1));
	int	mode = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");

	RETVAL = SSL_CTX_use_PrivateKey_file(ctx, filename, mode);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_use_pkcs12_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_use_pkcs12_file)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::use_pkcs12_file(ctx, filename, password)");
    {
	SSL_CTX*	ctx;
	char*	filename = (char *)SvPV_nolen(ST(1));
	char*	password = (char *)SvPV_nolen(ST(2));
#line 171 "SSLeay.xs"
	FILE *fp;
        EVP_PKEY *pkey;
        X509 *cert;
	STACK_OF(X509) *ca = NULL;
	PKCS12 *p12;
#line 281 "SSLeay.c"
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");
#line 177 "SSLeay.xs"
	if (fp = fopen(filename, "rb")) {
	  p12 = d2i_PKCS12_fp(fp, NULL);
	  fclose (fp);

	  if (p12) { 
	    if(PKCS12_parse(p12, password, &pkey, &cert, &ca)) {
	      if (pkey) {
		RETVAL = SSL_CTX_use_PrivateKey(ctx, pkey);
		EVP_PKEY_free(pkey);
	      }
	      if (cert) {
		RETVAL = SSL_CTX_use_certificate(ctx, cert);
		X509_free(cert);
	      }
	    }
	    PKCS12_free(p12);
	  }

	}


#line 313 "SSLeay.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_check_private_key); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_check_private_key)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::check_private_key(ctx)");
    {
	SSL_CTX*	ctx;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");

	RETVAL = SSL_CTX_check_private_key(ctx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__CTX_set_verify); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__CTX_set_verify)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::CTX::set_verify(ctx)");
    {
	SSL_CTX*	ctx;
#line 210 "SSLeay.xs"
        char* CAfile;
        char* CAdir;
#line 354 "SSLeay.c"
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");
#line 213 "SSLeay.xs"
        CAfile=getenv("HTTPS_CA_FILE");
        CAdir =getenv("HTTPS_CA_DIR");

        if(!CAfile && !CAdir) {
                SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, NULL);
	        RETVAL = newSViv(0);
        } else {
                SSL_CTX_load_verify_locations(ctx,CAfile,CAdir);
                SSL_CTX_set_verify(ctx, SSL_VERIFY_PEER, NULL);
	        RETVAL = newSViv(1);
        }
#line 375 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_new)
{
    dXSARGS;
    if (items < 3)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::new(packname, ctx, debug, ...)");
    {
	SV*	packname = ST(0);
	SSL_CTX*	ctx;
	SV*	debug = ST(2);
#line 235 "SSLeay.xs"
	SSL* ssl;
#line 394 "SSLeay.c"
	SSL *	RETVAL;

        if (sv_derived_from(ST(1), "Crypt::SSLeay::CTX")) {
            IV tmp = SvIV((SV*)SvRV(ST(1)));
            ctx = (SSL_CTX *) tmp;
        }
        else
            croak("ctx is not an Crypt::SSLeay::CTX");
#line 237 "SSLeay.xs"
	   ssl = SSL_new(ctx);
	   SSL_set_connect_state(ssl);
	   /* The set mode is necessary so the SSL connection can
  	    * survive a renegotiated cipher that results from 
	    * modssl VerifyClient config changing between 
	    * VirtualHost & some other config block.  At modssl
	    * this would be a [trace] ssl message:
	    *  "Changed client verification type will force renegotiation"
	    * -- jc 6/28/2001
	    */	      	
#ifdef SSL_MODE_AUTO_RETRY
	   SSL_set_mode(ssl, SSL_MODE_AUTO_RETRY);
#endif
	   RETVAL = ssl;
	   if(SvTRUE(debug)) {
             SSL_set_info_callback(RETVAL,InfoCallback);
	   }
	   if (items > 2) {
	       PerlIO* io = IoIFP(sv_2io(ST(3)));
#ifdef _WIN32
	       SSL_set_fd(RETVAL, _get_osfhandle(PerlIO_fileno(io)));
#else
	       SSL_set_fd(RETVAL, PerlIO_fileno(io));
#endif
           }
#line 429 "SSLeay.c"
	ST(0) = sv_newmortal();
        sv_setref_pv(ST(0), "Crypt::SSLeay::Conn", (void*)RETVAL);

    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_free); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_free)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::free(ssl)");
    {
	SSL*	ssl;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");

	SSL_free(ssl);
    }
    XSRETURN_EMPTY;
}

XS(XS_Crypt__SSLeay__Conn_set_fd); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_set_fd)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::set_fd(ssl, fd)");
    {
	SSL*	ssl;
	int	fd = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");

	RETVAL = SSL_set_fd(ssl, fd);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_connect); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_connect)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::connect(ssl)");
    {
	SSL*	ssl;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");

	RETVAL = SSL_connect(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_accept); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_accept)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::accept(ssl)");
    {
	SSL*	ssl;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");

	RETVAL = SSL_accept(ssl);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_write); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_write)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::write(ssl, buf, ...)");
    {
	SSL*	ssl;
#line 287 "SSLeay.xs"
	   STRLEN blen;
	   int len;
	   int offset = 0;
	   int n;
#line 544 "SSLeay.c"
	char*	buf = SvPV(ST(1), blen);
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");
#line 294 "SSLeay.xs"
	   if (items > 2) {
	       len = SvOK(ST(2)) ? SvIV(ST(2)) : blen;
	       if (items > 3) {
	           offset = SvIV(ST(3));
	           if (offset < 0) {
		       if (-offset > blen)
			   croak("Offset outside string");
		       offset += blen;
		   } else if (offset >= blen && blen > 0)
		       croak("Offset outside string");
               }
	       if (len > blen - offset)
		   len = blen - offset;
	   } else {
	       len = blen;
           }
	   n = SSL_write(ssl, buf+offset, len);
	   if (n >= 0) {
	       RETVAL = newSViv(n);
	   } else {
	       RETVAL = &PL_sv_undef;
           }
#line 577 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_read); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_read)
{
    dXSARGS;
    if (items < 3)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::read(ssl, buf, len, ...)");
    {
	SSL*	ssl;
	int	len = (int)SvIV(ST(2));
#line 325 "SSLeay.xs"
	   char *buf;
	   STRLEN blen;
	   int offset = 0;
	   int n;
#line 598 "SSLeay.c"
	SV*	sv = ST(1);
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");
#line 332 "SSLeay.xs"
	   buf = SvPV_force(sv, blen);
	   if (items > 3) {
	       offset = SvIV(ST(3));
	       if (offset < 0) {
		   if (-offset > blen)
		       croak("Offset outside string");
		   offset += blen;
	       }
	       /* this is not a very efficient method of appending
                * (offset - blen) NUL bytes, but it will probably
                * seldom happen.
                */
	       while (offset > blen) {
		   sv_catpvn(sv, "\0", 1);
	           blen++;
               }
	   }
           if (len < 0)
	       croak("Negative length");

	   SvGROW(sv, offset + len + 1);
	   buf = SvPVX(sv);  /* it might have been relocated */

	   n = SSL_read(ssl, buf+offset, len);

	   if (n >= 0) {
               SvCUR_set(sv, offset + n);
               buf[offset + n] = '\0';
	       RETVAL = newSViv(n);
	   } else {
	       RETVAL = &PL_sv_undef;
           }

#line 642 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_get_peer_certificate); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_get_peer_certificate)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::get_peer_certificate(ssl)");
    {
	SSL*	ssl;
	X509 *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");

	RETVAL = SSL_get_peer_certificate(ssl);
	ST(0) = sv_newmortal();
        sv_setref_pv(ST(0), "Crypt::SSLeay::X509", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_get_verify_result); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_get_verify_result)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::get_verify_result(ssl)");
    {
	SSL*	ssl;
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");
#line 377 "SSLeay.xs"
	   RETVAL = newSViv((SSL_get_verify_result(ssl) == X509_V_OK) ? 1 : 0);
#line 691 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_get_shared_ciphers); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_get_shared_ciphers)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::get_shared_ciphers(ssl)");
    {
	SSL*	ssl;
#line 386 "SSLeay.xs"
	   char buf[512];
#line 708 "SSLeay.c"
	char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");
#line 388 "SSLeay.xs"
	   RETVAL = SSL_get_shared_ciphers(ssl, buf, sizeof(buf));
#line 720 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__Conn_get_cipher); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__Conn_get_cipher)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::Conn::get_cipher(ssl)");
    {
	SSL*	ssl;
	char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::Conn")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            ssl = (SSL *) tmp;
        }
        else
            croak("ssl is not an Crypt::SSLeay::Conn");
#line 396 "SSLeay.xs"
	   RETVAL = (char*) SSL_get_cipher(ssl);
#line 745 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__X509_free); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__X509_free)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::X509::free(cert)");
    {
	X509*	cert;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::X509")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            cert = (X509 *) tmp;
        }
        else
            croak("cert is not an Crypt::SSLeay::X509");

	X509_free(cert);
    }
    XSRETURN_EMPTY;
}

XS(XS_Crypt__SSLeay__X509_subject_name); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__X509_subject_name)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::X509::subject_name(cert)");
    {
	X509*	cert;
#line 410 "SSLeay.xs"
	   char* str;
#line 782 "SSLeay.c"
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::X509")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            cert = (X509 *) tmp;
        }
        else
            croak("cert is not an Crypt::SSLeay::X509");
#line 412 "SSLeay.xs"
	   str = X509_NAME_oneline(X509_get_subject_name(cert), NULL, 0);
	   RETVAL = newSVpv(str, 0);
	   CRYPT_SSLEAY_free(str);
#line 795 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__X509_issuer_name); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__X509_issuer_name)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::X509::issuer_name(cert)");
    {
	X509*	cert;
#line 422 "SSLeay.xs"
	   char* str;
#line 812 "SSLeay.c"
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::X509")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            cert = (X509 *) tmp;
        }
        else
            croak("cert is not an Crypt::SSLeay::X509");
#line 424 "SSLeay.xs"
	   str = X509_NAME_oneline(X509_get_issuer_name(cert), NULL, 0);
	   RETVAL = newSVpv(str, 0);
	   CRYPT_SSLEAY_free(str);
#line 825 "SSLeay.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__X509_get_notBeforeString); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__X509_get_notBeforeString)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::X509::get_notBeforeString(cert)");
    {
	X509*	cert;
	char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::X509")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            cert = (X509 *) tmp;
        }
        else
            croak("cert is not an Crypt::SSLeay::X509");
#line 434 "SSLeay.xs"
            RETVAL = (char*) X509_get_notBefore(cert)->data;
#line 851 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_Crypt__SSLeay__X509_get_notAfterString); /* prototype to pass -Wmissing-prototypes */
XS(XS_Crypt__SSLeay__X509_get_notAfterString)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Crypt::SSLeay::X509::get_notAfterString(cert)");
    {
	X509*	cert;
	char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Crypt::SSLeay::X509")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            cert = (X509 *) tmp;
        }
        else
            croak("cert is not an Crypt::SSLeay::X509");
#line 442 "SSLeay.xs"
            RETVAL = (char*) X509_get_notAfter(cert)->data;
#line 876 "SSLeay.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Crypt__SSLeay); /* prototype to pass -Wmissing-prototypes */
XS(boot_Crypt__SSLeay)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("Crypt::SSLeay::Err::get_error_string", XS_Crypt__SSLeay__Err_get_error_string, file);
        newXS("Crypt::SSLeay::CTX::new", XS_Crypt__SSLeay__CTX_new, file);
        newXS("Crypt::SSLeay::CTX::free", XS_Crypt__SSLeay__CTX_free, file);
        newXS("Crypt::SSLeay::CTX::set_cipher_list", XS_Crypt__SSLeay__CTX_set_cipher_list, file);
        newXS("Crypt::SSLeay::CTX::use_certificate_file", XS_Crypt__SSLeay__CTX_use_certificate_file, file);
        newXS("Crypt::SSLeay::CTX::use_PrivateKey_file", XS_Crypt__SSLeay__CTX_use_PrivateKey_file, file);
        newXS("Crypt::SSLeay::CTX::use_pkcs12_file", XS_Crypt__SSLeay__CTX_use_pkcs12_file, file);
        newXS("Crypt::SSLeay::CTX::check_private_key", XS_Crypt__SSLeay__CTX_check_private_key, file);
        newXS("Crypt::SSLeay::CTX::set_verify", XS_Crypt__SSLeay__CTX_set_verify, file);
        newXS("Crypt::SSLeay::Conn::new", XS_Crypt__SSLeay__Conn_new, file);
        newXS("Crypt::SSLeay::Conn::free", XS_Crypt__SSLeay__Conn_free, file);
        newXS("Crypt::SSLeay::Conn::set_fd", XS_Crypt__SSLeay__Conn_set_fd, file);
        newXS("Crypt::SSLeay::Conn::connect", XS_Crypt__SSLeay__Conn_connect, file);
        newXS("Crypt::SSLeay::Conn::accept", XS_Crypt__SSLeay__Conn_accept, file);
        newXS("Crypt::SSLeay::Conn::write", XS_Crypt__SSLeay__Conn_write, file);
        newXS("Crypt::SSLeay::Conn::read", XS_Crypt__SSLeay__Conn_read, file);
        newXS("Crypt::SSLeay::Conn::get_peer_certificate", XS_Crypt__SSLeay__Conn_get_peer_certificate, file);
        newXS("Crypt::SSLeay::Conn::get_verify_result", XS_Crypt__SSLeay__Conn_get_verify_result, file);
        newXS("Crypt::SSLeay::Conn::get_shared_ciphers", XS_Crypt__SSLeay__Conn_get_shared_ciphers, file);
        newXS("Crypt::SSLeay::Conn::get_cipher", XS_Crypt__SSLeay__Conn_get_cipher, file);
        newXS("Crypt::SSLeay::X509::free", XS_Crypt__SSLeay__X509_free, file);
        newXS("Crypt::SSLeay::X509::subject_name", XS_Crypt__SSLeay__X509_subject_name, file);
        newXS("Crypt::SSLeay::X509::issuer_name", XS_Crypt__SSLeay__X509_issuer_name, file);
        newXS("Crypt::SSLeay::X509::get_notBeforeString", XS_Crypt__SSLeay__X509_get_notBeforeString, file);
        newXS("Crypt::SSLeay::X509::get_notAfterString", XS_Crypt__SSLeay__X509_get_notAfterString, file);
    XSRETURN_YES;
}

