/**********************************************************************
 * protomod.c                                               August 2005
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include "vanessa_logger.h"
#include "l7vs.h"
#include "sync_session.h"

static struct l7vs_protomod *l7vs_protomod_load(char *modname);
static void l7vs_protomod_unload(struct l7vs_protomod *pmod);
static gint l7vs_protomod_cmp(struct l7vs_protomod *pmod, char *name);

static int protomod_initialize(struct l7vs_service *srv, struct l7vs_conn *conn ,char *buf ,size_t len , struct l7vs_dest **dest);
static int protomod_finalize(struct l7vs_service *srv, struct l7vs_conn *conn ,char *buf , size_t len , struct l7vs_dest **dest, int resched);
struct evasion_parms eva;
 
static GList *l7vs_protomod_list = NULL;

struct l7vs_protomod *
l7vs_protomod_get(char *name)
{
        struct l7vs_protomod *pmod;

        pmod = l7vs_protomod_lookup(name);
        if (pmod == NULL) {
                pmod = l7vs_protomod_load(name);
                if (pmod == NULL) {
                        VANESSA_LOGGER_ERR("Protocol module not found"
                                           " (maybe module problem)");
                        return pmod;
                }
                pmod->refcnt = 0;
        }

        pmod->refcnt++;
        return pmod;
}

void
l7vs_protomod_put(struct l7vs_protomod *pmod)
{
        if (--pmod->refcnt <= 0) {
                l7vs_module_remove(&l7vs_protomod_list, pmod);
                l7vs_protomod_unload(pmod);
        }
}

static struct l7vs_protomod *
l7vs_protomod_load(char *modname)
{
        struct l7vs_protomod *pmod;

        pmod = (struct l7vs_protomod *)l7vs_module_load(modname, "protomod");

	/*[ added (2005/05/31) */
	pmod->initialize = protomod_initialize;
	pmod->finalize = protomod_finalize;
	/*]*/

        if (pmod != NULL) {
                l7vs_module_register(&l7vs_protomod_list, pmod);
        }

        return pmod;
}

static void 
l7vs_protomod_unload(struct l7vs_protomod *pmod)
{
        void *h;

        h = pmod->handle;
        pmod->fini();
        l7vs_module_unload(h);
}

struct l7vs_protomod *
l7vs_protomod_lookup(char *modname)
{
        return (struct l7vs_protomod *)
                l7vs_module_lookup(l7vs_protomod_list, modname,
                                   (GCompareFunc)l7vs_protomod_cmp);
}

static gint
l7vs_protomod_cmp(struct l7vs_protomod *pmod, char *name)
{
        return strcmp(pmod->modname, name);
}

static int
protomod_initialize(struct l7vs_service *srv, struct l7vs_conn *conn, char *buf, size_t len, struct l7vs_dest **dest)
{
	 *dest =(void *)NULL;
	 return 0;
}

static int
protomod_finalize(struct l7vs_service *srv, struct l7vs_conn *conn, char *buf, size_t len, struct l7vs_dest **dest,int resched)
{
	GList *l;
	struct l7vs_dest *d;
	static char ipaddr[16];
	static char ipaddr_1[16];
	char *ip;
	static int flag ;
	static int flag_1 ;
	
	int evasion_status;
	/* if evasion_status is 1 then set the destination as sorry server otherwise usual procedure*/
        evasion_status = evasion(srv);

	if((*dest) != NULL){
		if(flag==0) {
	        	ip = inet_ntoa((*dest)->addr.sin_addr);
			strcpy(ipaddr,ip);
			flag++;
		}

	        if(evasion_status==1){
       		   ( *dest )->addr.sin_addr.s_addr = inet_addr(eva.ssaddr);
		   (*dest)->addr.sin_port  = htons(80);
		//	VANESSA_LOGGER_ERR_UNSAFE("SS IP address :%s",eva.ssaddr);
		   return 0;
      		}
	        else {
			for(l = g_list_first(srv->dest_list); l!=NULL; l = g_list_next(l)) {
				d = (struct l7vs_dest *)l->data;
				if((d->addr.sin_addr.s_addr == (*dest)->addr.sin_addr.s_addr) &&
			   	(d->addr.sin_port == (*dest)->addr.sin_port)) {
			   			*dest = d;
				return 0;
				}
			}
			if(resched == 0){
				VANESSA_LOGGER_ERR("realserver nonexistence");
				return -1;
			}
			*dest=srv->scheduler->schedule(srv,conn); //if resched is not 0 then again schedule the job
			if(*dest == NULL) {
				VANESSA_LOGGER_ERR("realserver nonexistence");
				return -1;
			}
			return 0;
	    	}
	} 
	else {
			*dest=srv->scheduler->schedule(srv,conn);
			if(*dest == NULL) {
                                VANESSA_LOGGER_ERR("realserver nonexistence");
                                return -1;
                        }

		 	//VANESSA_LOGGER_ERR_UNSAFE("Else Part IP addr : %s",inet_ntoa((*dest)->addr.sin_addr));
			if(flag_1==0) {
                        	ip = inet_ntoa((*dest)->addr.sin_addr);
                        	strcpy(ipaddr_1,ip);
			//	VANESSA_LOGGER_ERR_UNSAFE("SS IP address :--->1 %s",ipaddr_1);
                        	flag_1++;
                	}

			if(evasion_status==1)
			{
			(*dest)->addr.sin_addr.s_addr=inet_addr(eva.ssaddr);
			}
			return 0;
	}
}

/*Checks number of active connections of each real server with max session count of VIP if any of the
number of active connections exceeds max session count  this function will return 1 other wise return  */
int evasion(struct l7vs_service *srv)
{
        GList *l;
        FILE *fp;
        int cc;
        struct l7vs_dest *d;
        char *rsrv;
	void *shared_memory=(void *)0;
	int shmid;
	int semid;
	int flag = 0;
	int i;
	int retval=0;
	
	semid=initialize_sem(key_sem_evs);

	shmid = initialize_shm(key_shm_evs,sizeof(struct evasion));
	if(shmid == -1)
	 {
		 VANESSA_LOGGER_ERR("problem initializing shared memory");
		 return 0;
	 }
	 struct evasion *evs;
	 shared_memory=shmat(shmid,0,0);

	 if (shared_memory == (void *)-1)
        {
                VANESSA_LOGGER_ERR("evasion shmat failed");
        }

	 evs = (struct evasion *)shared_memory;

	//VIP check
	char *V_ADDR,V_addr[16];
        V_ADDR = inet_ntoa(srv->lsock->addr.sin_addr);
	semaphore_lock(semid);
	for(i = 0;i < LE_VIP_SZ;i++)
	{
		if(strcmp(V_ADDR,evs->e[i].vaddr)==0)
		{
		 flag = 1;
		 eva = evs->e[i];
		 break;
		}
	}
	semaphore_unlock(semid);
	
	if(flag!=1)
		goto DETACH;

               for(l = g_list_first(srv->dest_list); l!=NULL; l = g_list_next(l)) {
				d = (struct l7vs_dest *)l->data;
                          if ((d->nactive+1) > eva.cc ) {
                                VANESSA_LOGGER_ERR("Sending client request to Sorry Server");
				retval=1;
				goto DETACH;
                        }
                }
DETACH:
        if (shmdt(shared_memory) == -1)
        {
                VANESSA_LOGGER_ERR("evasion shmdt failed");
        }
	return retval;
}
