/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.iterate.conf,v 5.9 2003/06/04 00:14:41 hardaker Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "l7vsagent.h"
#include "l7vsRealTable.h"

/** Initialize the l7vsRealTable table by defining its contents and how it's structured */
void
initialize_table_l7vsRealTable(void)
{
    static oid      l7vsRealTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9999, 1, 18 };
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /** create the table registration information structures */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /** if your table is read only, it's easiest to change the
        HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("l7vsRealTable",
                                                     l7vsRealTable_handler,
                                                     l7vsRealTable_oid,
                                                     OID_LENGTH
                                                     (l7vsRealTable_oid),
                                                     HANDLER_CAN_RWRITE);

    if (!my_handler || !table_info || !iinfo) {
        snmp_log(LOG_ERR,
                 "malloc failed in initialize_table_l7vsRealTable");
        return;                 /* Serious error. */
    }

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: l7vsRealServiceNumber */
                                     ASN_INTEGER,       /* index: l7vsRealServerNumber */
                                     0);

    /** Define the minimum and maximum accessible columns.  This
        optimizes retrival. */
    table_info->min_column = 1;
    table_info->max_column = 8;

    /*
     * iterator access routines 
     */
    iinfo->get_first_data_point = l7vsRealTable_get_first_data_point;
    iinfo->get_next_data_point = l7vsRealTable_get_next_data_point;

    /** you may wish to set these as well */
#ifdef MAYBE_USE_THESE
    iinfo->make_data_context = l7vsRealTable_context_convert_function;
    iinfo->free_data_context = l7vsRealTable_data_free;

    /** pick *only* one of these if you use them */
    iinfo->free_loop_context = l7vsRealTable_loop_free;
    iinfo->free_loop_context_at_end = l7vsRealTable_loop_free;
#endif

    /** tie the two structures together */
    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_l7vsRealTable",
                "Registering table l7vsRealTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);

    /*
     * Initialise the contents of the table here
     */
	netsnmp_inject_handler(my_handler,
		netsnmp_get_cache_handler(CACHE_TIME_OUT,
						l7vsRealTable_load,
						l7vsRealTable_free,
						l7vsRealTable_oid,
						OID_LENGTH(l7vsRealTable_oid)
					  )
				);

}

/** Initializes the l7vsRealTable module */
void
init_l7vsRealTable(void)
{

  /** here we initialize all the tables we're planning on supporting */
    initialize_table_l7vsRealTable();
}

/*
 * create a new row in the (unsorted) table
 * This is called by l7vsagent.c when creating the linked list.
 */
struct l7vsRealTable_entry *
l7vsRealTable_createEntry(long l7vsRealServiceNumber,
                          long l7vsRealServerNumber)
{
    struct l7vsRealTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct l7vsRealTable_entry);
    if (!entry)
        return NULL;

    entry->l7vsRealServiceNumber = l7vsRealServiceNumber;
    entry->l7vsRealServerNumber = l7vsRealServerNumber;
    entry->next = l7vsRealTable_head;
    l7vsRealTable_head = entry;
    return entry;
}

/** returns the first data point within the l7vsRealTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later (in your main l7vsRealTable_handler routine) that will provide
    you with the data to return in a given row.  This could be the
    same pointer as what my_loop_context is set to, or something
    different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
l7vsRealTable_get_first_data_point(void **my_loop_context,
                                   void **my_data_context,
                                   netsnmp_variable_list * put_index_data,
                                   netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;

	if(l7vsRealTable_head == NULL)
		return NULL;

    *my_loop_context = l7vsRealTable_head;
    *my_data_context = l7vsRealTable_head;

    vptr = put_index_data;

    snmp_set_var_value(vptr,
				(u_char*) & l7vsRealTable_head->l7vsRealServiceNumber,
				sizeof(l7vsRealTable_head->l7vsRealServiceNumber));
    vptr = vptr->next_variable;

    snmp_set_var_value(vptr,
                       (u_char *) & l7vsRealTable_head->l7vsRealServerNumber,
				sizeof(l7vsRealTable_head->l7vsRealServerNumber));
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as l7vsRealTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it to your local data type and
   then return my_loop_context->next.  The my_data_context pointer
   should be set to something you need later (in your main
   l7vsRealTable_handler routine) and the indexes in put_index_data updated
   again. */
netsnmp_variable_list *
l7vsRealTable_get_next_data_point(void **my_loop_context,
                                  void **my_data_context,
                                  netsnmp_variable_list * put_index_data,
                                  netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;

    struct l7vsRealTable_entry *entry =
        (struct l7vsRealTable_entry *) *my_loop_context;

	if (!entry->next)
        return NULL;

    entry = entry->next;

    *my_loop_context = (void *) entry;
    *my_data_context = (void *) entry;

    vptr = put_index_data;

    snmp_set_var_value(vptr,
				(u_char*) & entry->l7vsRealServiceNumber,
				sizeof(entry->l7vsRealServiceNumber));
    vptr = vptr->next_variable;

    snmp_set_var_value(vptr,
				(u_char*) & entry->l7vsRealServerNumber,
				sizeof(entry->l7vsRealServerNumber));
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the l7vsRealTable table, if anything else needs to be done */
int
l7vsRealTable_handler(netsnmp_mib_handler *handler,
                      netsnmp_handler_registration *reginfo,
                      netsnmp_agent_request_info *reqinfo,
                      netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
	struct l7vsRealTable_entry *table_entry;


    for (request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /** perform anything here that you need to do before each
           request is processed. */

        /** the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the l7vsRealTable table in question */
        table_entry =
            ( struct l7vsRealTable_entry *)netsnmp_extract_iterator_context(request);
        if ( table_entry == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHINSTANCE);
                continue;
            }
            /** XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /** extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /** table_info->colnum contains the column number requested */
        /** table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info == NULL) {
            continue;
        }

        switch (reqinfo->mode) {
            /** the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
        case MODE_GET:
            switch (table_info->colnum) {
            case COLUMN_L7VSREALSERVICENUMBER:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServiceNumber,
                                         sizeof(table_entry->l7vsRealServiceNumber)
						     );
                break;

            case COLUMN_L7VSREALSERVERNUMBER:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerNumber, 
                                         sizeof(table_entry->l7vsRealServerNumber)
                                         );
                break;

            case COLUMN_L7VSREALSERVERADDR:
                snmp_set_var_typed_value(var, ASN_OCTET_STR,
                                         (u_char *) table_entry->l7vsRealServerAddr,
                                         strlen(table_entry->l7vsRealServerAddr)+1
                                         );
                break;

            case COLUMN_L7VSREALSERVERPORT:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerPort,
                                         sizeof(table_entry->l7vsRealServerPort)
                                         );
                break;

            case COLUMN_L7VSREALSERVERFLAG:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerFlag,
                                         sizeof(table_entry->l7vsRealServerFlag)
                                         );
                break;

            case COLUMN_L7VSREALSERVERWEIGHT:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerWeight,
                                         sizeof(table_entry->l7vsRealServerWeight)
                                         );
                break;

            case COLUMN_L7VSREALSERVERACTIVECONN:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerActiveConn,
                                         sizeof(table_entry->l7vsRealServerActiveConn)
                                         );
                break;

            case COLUMN_L7VSREALSERVERINACTIVECONN:
                snmp_set_var_typed_value(var, ASN_INTEGER,
                                         (u_char *) &table_entry->l7vsRealServerInactiveConn,
                                         sizeof(table_entry->l7vsRealServerInactiveConn)
                                         );
                break;

            default:
                        /** We shouldn't get here */
                snmp_log(LOG_ERR,
                         "problem encountered in l7vsRealTable_handler: unknown column\n");
            }
            break;

        case MODE_SET_RESERVE1:
                /** set handling... */

        default:
            snmp_log(LOG_ERR,
                     "problem encountered in l7vsRealTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}

/* Populates the Virtual service and real server linked list */
int l7vsRealTable_load(netsnmp_cache* cache, void* vmagic)
{
	populateServiceTable();
	return 0;
}


/* Frees off the linked lists of Virtual service and real server */
void l7vsRealTable_free(netsnmp_cache* cache, void* vmagic)
{
	freeVirtualServiceTableMemory();
	freeRealServerTableMemory();
	return;
}
