/*
 * Note: this file originally auto-generated by mib2c using
 *  : mib2c.iterate.conf,v 5.14.2.2 2005/05/09 08:13:01 dts12 Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "l7vsagent.h"
#include "l7vsServiceTable.h"


/** Initializes the l7vsServiceTable module */
void
init_l7vsServiceTable(void)
{
    /*
     * here we initialize all the tables we're planning on supporting
     */
	l7vsServiceTable_head = NULL;
    initialize_table_l7vsServiceTable();
}


/** Initialize the l7vsServiceTable table by defining its contents and how it's structured */
void
initialize_table_l7vsServiceTable(void)
{
    static oid      l7vsServiceTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9999, 1, 17 };
    size_t          l7vsServiceTable_oid_len =
        OID_LENGTH(l7vsServiceTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_iterator_info *iinfo;
    netsnmp_table_registration_info *table_info;

    reg =
        netsnmp_create_handler_registration("l7vsServiceTable",
                                            l7vsServiceTable_handler,
                                            l7vsServiceTable_oid,
                                            l7vsServiceTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: l7vsServiceNumber */
                                     0);
    table_info->min_column = 1;
    table_info->max_column = 12;

    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);
    iinfo->get_first_data_point = l7vsServiceTable_get_first_data_point;


    iinfo->get_next_data_point = l7vsServiceTable_get_next_data_point;
    iinfo->table_reginfo = table_info;

    netsnmp_register_table_iterator(reg, iinfo);

    /*
     * Initialise the contents of the table here
     */
	netsnmp_inject_handler(reg,
		netsnmp_get_cache_handler(CACHE_TIME_OUT,
						l7vsServiceTable_load,
						l7vsServiceTable_free,
						l7vsServiceTable_oid,
						OID_LENGTH(l7vsServiceTable_oid)
					  )
				);
}


/*
 * create a new row in the (unsorted) table
 * This is called by l7vsagent.c when creating the linked list.
 */
struct l7vsServiceTable_entry *
l7vsServiceTable_createEntry(long l7vsServiceNumber)
{
    struct l7vsServiceTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct l7vsServiceTable_entry);
    if (!entry)
    {
	SNMP_FREE(entry);
        return NULL;
    }

    entry->l7vsServiceNumber = l7vsServiceNumber;
    entry->next = l7vsServiceTable_head;
    l7vsServiceTable_head = entry;
    return entry;
}


/*
 * Example iterator hook routines - using 'get_next' to do most of the work
 * This is invoked when SNMPGET/SNMPWALK/SNMPGETNEXT requests are called
 */
netsnmp_variable_list *
l7vsServiceTable_get_first_data_point(void **my_loop_context,
                                      void **my_data_context,
                                      netsnmp_variable_list *
                                      put_index_data,
                                      netsnmp_iterator_info *mydata)
{
	/* Creating the linked list */

   if(l7vsServiceTable_head == NULL)
        return NULL;

    *my_loop_context = (void*) l7vsServiceTable_head;
    return l7vsServiceTable_get_next_data_point(my_loop_context,
                                                my_data_context,
                                                put_index_data, mydata);
}


/*
 * Example iterator hook routine
 * This is invoked when SNMPGET/SNMPWALK/SNMPGETNEXT requests are called
 */
netsnmp_variable_list *
l7vsServiceTable_get_next_data_point(void **my_loop_context,
                                     void **my_data_context,
                                     netsnmp_variable_list *
                                     put_index_data,
                                     netsnmp_iterator_info *mydata)
{
    struct l7vsServiceTable_entry *entry =
        (struct l7vsServiceTable_entry *) *my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if (entry) {
        snmp_set_var_value(idx, (u_char*) &entry->l7vsServiceNumber,
                           sizeof(entry->l7vsServiceNumber));
        idx = idx->next_variable;
        *my_data_context = (void *) entry;
        *my_loop_context = (void *) entry->next;
	return put_index_data;
    } else {
        return NULL;
    }
}


/** This handles requests for the l7vsServiceTable table */
int
l7vsServiceTable_handler(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *reqinfo,
                         netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct l7vsServiceTable_entry *table_entry;

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct l7vsServiceTable_entry *)
                netsnmp_extract_iterator_context(request);
	    if(!table_entry)
		continue;

            table_info = netsnmp_extract_table_info(request);

            switch (table_info->colnum) {
            case COLUMN_L7VSSERVICENUMBER:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServiceNumber,
                                         sizeof(table_entry->
                                                l7vsServiceNumber));
                break;
            case COLUMN_L7VSSERVICESCHEDTYPE:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->l7vsServiceSchedType,
                                         strlen(table_entry->
                                              l7vsServiceSchedType)+1);
                break;
            case COLUMN_L7VSSERVICEPROTO:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServiceProto,
                                         sizeof(table_entry->
                                                l7vsServiceProto));
                break;
            case COLUMN_L7VSSERVICEADDR:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->l7vsServiceAddr,
                                         strlen(table_entry->
                                                l7vsServiceAddr)+1);
                break;
            case COLUMN_L7VSSERVICEPORT:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServicePort,
                                         sizeof(table_entry->
                                                l7vsServicePort));
                break;
            case COLUMN_L7VSSERVICENUMDESTS:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServiceNumDests,
                                         sizeof(table_entry->
                                                l7vsServiceNumDests));
                break;
            case COLUMN_L7VSSERVICEPERSIST:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServicePersist,
                                         sizeof(table_entry->
                                                l7vsServicePersist));
                break;
            case COLUMN_L7VSSERVICEBACKLOG:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsServiceBackLog,
                                         sizeof(table_entry->
                                                l7vsServiceBackLog));
                break;
            case COLUMN_L7VSPROTOCOLMODULENAME:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->
                                         l7vsProtocolModuleName,
                                         strlen(table_entry->
                                                l7vsProtocolModuleName)+1);
                break;
            case COLUMN_L7VSPROTOCOLMODULEKEY:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->
                                         l7vsProtocolModuleKey,
                                         strlen(table_entry->
                                                l7vsProtocolModuleKey)+1);
                break;
            case COLUMN_L7VSPROTOCOLMODULESTRING:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->
                                         l7vsProtocolModuleString,
                                         strlen(table_entry->
                                                l7vsProtocolModuleString)+1);
                break;
            case COLUMN_L7VSSERVICERESCHEDULE:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->
                                         l7vsServiceReschedule,
                                         sizeof(table_entry->
                                                l7vsServiceReschedule));
                break;

            }
        }
        break;

    }

    return SNMP_ERR_NOERROR;
}


/* Populates the Virtual service and real server linked list */
int l7vsServiceTable_load(netsnmp_cache* cache, void* vmagic)
{
	populateServiceTable();
	return 0;
}


/* Frees off the linked lists of Virtual service and real server */
void l7vsServiceTable_free(netsnmp_cache* cache, void* vmagic)
{
	freeVirtualServiceTableMemory();
	freeRealServerTableMemory();
	return;
}
