#ifndef L7VSAGENT_H
#define L7VSAGENT_H

#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <getopt.h>
#include <string.h>
#include <vanessa_logger.h>
#include <vanessa_adt.h>
#include "glib.h"
#include "l7vs.h"

/* Defines the time out for CACHED data */
#define CACHE_TIME_OUT 5
#define L7_OK 1

int get_str_version(char** chVersion);
int get_int_numServices(int32_t * value);

/*
* Typical data structure for a row entry for Virtual service
*/
typedef struct l7vsServiceTable_entry {

	/*
	* Column values
	*/
	long			l7vsServiceNumber;
	char			l7vsServiceSchedType[L7VS_MODNAME_LEN];
	long			l7vsServiceProto;
	char			l7vsServiceAddr[20];
	long			l7vsServicePort;
	long			l7vsServiceNumDests;
	long			l7vsServicePersist;
	long			l7vsServiceBackLog;
	char			l7vsProtocolModuleName[L7VS_MODNAME_LEN];
	char			l7vsProtocolModuleKey[256];
	char			l7vsProtocolModuleString[512];
	long			l7vsServiceReschedule;

	/*
	* Illustrate using a simple linked list
	*/
	int             valid;
	struct l7vsServiceTable_entry *next;
} l7vsServiceTable;

l7vsServiceTable *l7vsServiceTable_head;


/*
* Typical data structure for a row entry for Real server
*/
typedef struct l7vsRealTable_entry {
/*
* Column values
*/
long			l7vsRealServiceNumber;
long			l7vsRealServerNumber;
char			l7vsRealServerAddr[20];
long			l7vsRealServerPort;
long			l7vsRealServerFlag;
long			l7vsRealServerWeight;
long			l7vsRealServerActiveConn;
long			l7vsRealServerInactiveConn;

/*
* Illustrate using a simple linked list
*/
int             valid;
struct l7vsRealTable_entry *next;
} l7vsRealTable;

l7vsRealTable *l7vsRealTable_head;

/* Methods that populate and release the Linked list */
void populateServiceTable();
void freeVirtualServiceTableMemory();
void freeRealServerTableMemory();

#ifndef L7VS_CONFIG_SOCK_PATH
#define L7VS_CONFIG_SOCK_PATH           "/var/run/l7vs"
#endif

#define L7VSAGENT_LIST_VS_BUFSIZE 1024
#define L7VSAGENT_LIST_RS_RSNUM   16

#define L7VSAGENT_RECV_FAILED             (-1)
#define L7VSAGENT_RECV_TOO_LARGE          (-2)

static int create_socket(void);
static void destroy_socket(void);
static int send_request(int, void *, size_t);
static int sendv_request(int, struct iovec *, int);
static int recv_response(int, struct iovec *, size_t);
static const char *config_strerror(int);
static char *get_servicename(struct sockaddr_in *, int);

static char *local_sockname;
static int socket_num;
static const char l7vs_config_sockname[] = L7VS_CONFIG_SOCK_PATH "/l7vs";

#endif                          /* L7VSAGENT_H*/
