/*  This file (sync_session.c) is used for initializing the semaphore
 *  and the shared memory
 */

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/utsname.h>
#include "sync_session.h"


/* initializing the shared memory */
int initialize_shm(key_t key, int size)
{
	int shmid;
	shmid = shmget(key, size, 0666 | IPC_CREAT);
	return shmid;
}

/* initializing the semaphore */
int initialize_sem(key_t key)
{
	int semid;
	semid = semget(key, 1, 0666 | IPC_CREAT);

	union semun sem_union;
        sem_union.val=1;
        if(semctl(semid,0,SETVAL,sem_union)==-1)
                fprintf(stderr,"semaphore initializaton failed\n");

	return semid;
}

/*  semaphore releasing */
void semaphore_unlock(int semaphore_id)
{
	struct sembuf sem_b;
        sem_b.sem_num=0;
        sem_b.sem_op=1;
        sem_b.sem_flg=SEM_UNDO;
        semop(semaphore_id,&sem_b,1);
}

/*  semaphore locking  */
void semaphore_lock(int semaphore_id)
{
	struct sembuf sem_b;
        sem_b.sem_num=0;
        sem_b.sem_op=-1;
        sem_b.sem_flg=SEM_UNDO;
        semop(semaphore_id,&sem_b,1);
}

/* check whether l7syncd already running or not 
 * reference from snmp subagent 
 */
int check_process_state(char *pid_file,int protocol)
{
	FILE *fp, *fpTemp;
        char l7syncd_pid_folder[30];
        char l7syncd_string[100];
        char l7syncd_pid[10];
	char *process;
	int  retval=0;
	
	//file_path=strcat(file,pid_file);
       	/* Open the PID file to see whether l7syncd is running */
	if(protocol)
	{
        	fp = fopen(pid_file, "r");
	}
	else
	{
		process=strtok(pid_file,".");
        	fp = fopen(file_path, "r");
	}
	
        if (fp != NULL)
        {
                fscanf(fp, "%s", l7syncd_pid);
                fclose(fp);

                sprintf(l7syncd_pid_folder, "/proc/%s/cmdline", l7syncd_pid);

                /* Confirm whether the existing PID file is not stale */
                fpTemp = fopen(l7syncd_pid_folder, "r");
                if (fpTemp != NULL)
                {
                        fscanf(fpTemp, "%s", l7syncd_string);
                        fclose(fpTemp);

                        /* Using strstr, confirm that the PID file is not stale or does not
                        belong to some other process */
			if(protocol)
			{
                        	if (strstr(l7syncd_string, "l7syncd_master") != NULL)
	                        {
					retval=2;
					goto RETURN;	
                	        }
			}
			else
			{
	                        if (strstr(l7syncd_string, process) != NULL)
        	                {
                	               printf("%s is already running. Check the system file under /proc folder",process);
					retval=0;
					goto RETURN;	
                        	}
			}
		}
	}

	if(!protocol)
	{
		fp = fopen(file_path, "w");
        	if (fp == NULL) {
                	printf("Error in opening PID file for %s at /var/run folder",process);
			retval=0;
			goto RETURN;	
        	} else {
                	fprintf(fp, "%d", (int) getpid());
	                fclose(fp);
        	}
		retval=1;
		goto RETURN;	
	}

	RETURN:
		return retval;	
}

/* To check weather the system is standby or not */
unsigned isStandby(void)
{
	FILE *harfp;
	char hares_content[BUFSIZ];
	char *hares_master;
	struct utsname unst;

	uname(&unst);

	harfp=fopen("/etc/ha.d/haresources","r");
	if(harfp==NULL)
	{
		fprintf(stderr,"error in haresources file open\n");
	}
	else
	{
		while(!feof(harfp))
		{
			fgets(hares_content,BUFSIZ,harfp);
			if((hares_content[0]!='#'))
			{
				if(strcmp(hares_content,"\n")!=0)
				{
					hares_master = strtok(hares_content," ");
					break;
				}
			}
		}
	}
	if(strcmp(unst.nodename,hares_master)!=0)
		return 1;
	else
		return 0;
}

