/*
 * @file  module_sslid_hash_map.cpp
 * @brief sslid hashmap container.
 * @brief this module provide session persistence by SSL session ID.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 * Copyright (C) 2009  Shinya TAKEBAYASHI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <iostream>
#include <sstream>
#include <list>
#include <string>
#include <tr1/unordered_map>
#include <string.h>
#include "l7vs_dest.h"
#include "protomod_sslid.h"
#include "module_sslid_hash_map.h"


CSSLIDMap::CSSLIDMap()
{
  listsize = 0;
}


CSSLIDMap::~CSSLIDMap()
{
}


void CSSLIDMap::allocate(unsigned int size)
{
  m = new IDMAP;
  l = new IDLIST;
  listsize = size;
}


void CSSLIDMap::destroy(void)
{
  if (m) {
    delete m;
    m = NULL;
  }

  if (l) {
    delete l;
    l = NULL;
  }
}


void CSSLIDMap::add(const std::string key, struct l7vs_dest data)
{
  IDMAP::iterator it;

  if (m->size() >= listsize) {
    m->erase(*(l->begin()));
    l->pop_front();

  }

  m->insert(IDMAP::value_type(key, data));
  it = m->find(key);
  l->push_back(it);
}


bool CSSLIDMap::search(const std::string key, l7vs_dest **data)
{
  bool retval;

  IDMAP::const_iterator it = m->find(key);

  if (it == m->end()) {
    retval = false;

  } else {
    *data = (struct l7vs_dest*)&it->second;
    retval = true;
  }

  return retval;
}


void *CSSLIDMap::getIDMAP(void)
{
  return (void *)m;
}


void *CSSLIDMap::getIDLIST(void)
{
  return (void *)l;
}

int CSSLIDMap::getLISTSIZE(void)
{
  return listsize;
}


void CSSLIDMap::setPointer(const void *keymap, const void *keylist, unsigned int size)
{
  m = static_cast<IDMAP *> (const_cast<void*> (keymap));
  l = static_cast<IDLIST *> (const_cast<void*> (keylist));
  listsize = size;
}


void CSSLIDMap::construct_sessionlist(struct l7vs_sslid_service* sslid_service)
{
  int pick = 0;
  IDMAP::const_iterator it;
  
  for (it = m->begin(); it != m->end(); it++, pick++) {
    memcpy((sslid_service->session + pick)->id, &(it->first), 32);
    memcpy(&(sslid_service->session + pick)->dest, &(it->second), sizeof(struct l7vs_dest));

  }
}


void CSSLIDMap::rebuild_sessionlist(struct l7vs_sslid_service* sslid_service)
{
  int pick;
  struct ssl_session tmp_session;
  
  m->clear();
  l->clear();

  for (pick = 0; pick < sslid_service->maxlist; pick++) {
    memset(&tmp_session, 0, sizeof (struct ssl_session));
    memcpy(&(tmp_session.id), &(sslid_service->session + pick)->id, 32);
    memcpy(&(tmp_session.dest), &(sslid_service->session + pick)->dest, sizeof(struct l7vs_dest));
    add(tmp_session.id, tmp_session.dest);

  }
}
