/*
 * @file  protomod_sslid.h
 * @brief protocol module of HTTPS(SSL/TLS).
 * @brief this module provide session persistence by SSL session ID.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 * Copyright (C) 2009  Shinya TAKEBAYASHI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __PROTOMOD_SSLID_H_7E0F0EB6_200B_4839_8C5D_60E4473F9E40__
#define __PROTOMOD_SSLID_H_7E0F0EB6_200B_4839_8C5D_60E4473F9E40__

#include "l7vs_service.h"

#define SERVICE_ARG_MAXSIZE  (512)
#define SSLID_SERVICE_NUMBER (128)
#define SSLID_LENGTH         (32)

struct l7vs_sslid_service {
	handle_t service_handle;
	int timeout;
	int maxlist;
	struct ssl_session* session;
	void* hash_map;
	void* hash_list;
	void* replication_addr;
	int reschedule;
};

struct l7vs_sslid_service_arg {
	int timeout;
	int maxlist;
	int reschedule;
};

struct ssl_session {
	char id[SSLID_LENGTH];
	struct l7vs_dest dest;
	time_t last_time;
	char valid;
};

struct replication_header {
	struct in_addr sin_addr;
	unsigned short sin_port;
	unsigned int size;
	unsigned int offset;
};

#endif // __PROTOMOD_SSLID_H_7E0F0EB6_200B_4839_8C5D_60E4473F9E40__

