/*(c)akira noda daemon@rogiken.org*/

#include "freebsd_abi.h"

#include <machine/reg.h>
#include <machine/psl.h>
#include <unistd.h>
#include <sys/syscall.h>
#include <stdbool.h>

int getRetValue(TargetInfo *target,int *error,unsigned long *retVal,unsigned long *retVal2){
	struct reg regs;
	lseek(target->regFd, 0L, SEEK_SET);
  if (read(target->regFd, &regs, sizeof(regs)) != sizeof(regs)){
    return 0;
  }
	*retVal=  regs.r_eax;
	*retVal2= regs.r_edx;/*pipe(2) returns 2 set of retvalue*/
	*error=   regs.r_eflags & PSL_C;
	return 1;
}


int getArg(TargetInfo* target,int *systemcallNum,unsigned long *data ,int nofArg){
	struct reg regs;
	lseek(target->regFd, 0L, SEEK_SET);
  if (read(target->regFd, &regs, sizeof(regs)) != sizeof(regs)){
    return 0;
  }
	unsigned int parm_offset = regs.r_esp + sizeof(unsigned long);
	switch(regs.r_eax){
	case SYS_syscall:
	case SYS___syscall:
		lseek(target->memFd, parm_offset, SEEK_SET);
		read(target->memFd, &systemcallNum, sizeof(unsigned long));
		parm_offset+=sizeof(unsigned long);
		if(regs.r_eax== SYS___syscall)parm_offset+=sizeof(unsigned long);
		break;
	default:
		*systemcallNum=regs.r_eax;
		break;

	}

	lseek(target->memFd, parm_offset, SEEK_SET);
	if (read(target->memFd, data, nofArg * sizeof(unsigned long)) != (int)(nofArg * sizeof(unsigned long)) )return 0;
	return 1;
}

