/*(c)akira noda daemon@rogiken.org*/

#include "freebsd_com.h"
#include "freebsd_abi.h"

#include <sys/pioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <stdarg.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <err.h>
#include <stdio.h>
#include <string.h>

extern FILE * opt_outFp;

void initializeTargetInfo(TargetInfo *target){
	target->pid=-1;
	target->regFd=-1;
	target->memFd=-1;
	target->isStarted=false;
}
static void dummy(int dummy){
}
void checkLoop(TargetInfo *target){
	struct procfs_status pfs;
	signal(SIGALRM, dummy);

	while(1){
		if(ESRCH == kill(target->pid,0)){
			fprintf(opt_outFp,"info:pid is gone\n");
			detachTarget(target);
			exit(0);
		}
		errno=0;
		alarm(1);/*to avoid stack in ioctl*/
		if (ioctl(target->memFd, PIOCWAIT, &pfs) == -1){		
			/*
				 on FreeBSD this always errno != EINTR.
				 but ioctl checks the process is still alive or not.
				 on alam singal.
			*/
			if(errno==EINTR){ 
				continue;
			}
			fprintf(opt_outFp,"info:procfs is gone\n");
			detachTarget(target);
			exit(1);
		}else {
		
			if(pfs.why==S_EXIT)break; /*target programl end*/
			switch(pfs.why) {
			case S_SCE:
				/*pfs.val is narg.*/
				if(target->isStarted){
					onSystemCallEnter(target,pfs.val);
				}
				break;
			case S_SCX:
				
				/*pfs.val is system call No.*/
				if(target->isStarted){
					onSystemCallExit(target,pfs.val);
				}
				break;
			case S_EXEC:
				target->isStarted=true;
				checkEtype(target);
				break;
			case S_EXIT:
				{
					int stat;
					stat= ~0;
					ioctl(target->memFd, PIOCBIC,stat);
					stat=0;
					ioctl(target->memFd, PIOCCONT,stat);
					waitpid(target->pid,&stat,0);
					break;
				}
				break;
			default:;
			}
			if(target->memFd<0)break;/*already detached*/
			{/*continue */
				int val=0;
				if (ioctl(target->memFd, PIOCCONT, val) == -1 ) {
					if (kill(target->pid, 0) == -1 && errno == ESRCH){
						printf("nosuch pid\n");
						break;
					}
					else
						warn("PIOCCONT");
				}
			}
		}
	}
}




void checkEtype(TargetInfo *target){
	int fd;
	char buf[PROCLEN];
	snprintf(buf,PROCLEN, PROCFS"%d/etype", target->pid);
	if ((fd = open(buf, O_RDONLY)) == -1) {
		strcpy(buf, "FreeBSD a.out");
	} else {
		int len = read(fd, buf, sizeof(buf));
		buf[len-1] = '\0';
		close(fd);
	}
	if(
		 0!=strcmp("FreeBSD a.out",buf) &&
			 0!=strcmp("FreeBSD ELF",buf) &&
		 0!=strcmp("FreeBSD ELF32",buf)){
			abortTarget(target,12,"info:not suitable target %s\n",buf);
			err(1,"Not Suitable execute file");
	}
}

void detachTarget(TargetInfo *target){
	int val;
	int flags = S_EXEC | S_EXIT | S_SCE | S_SCX ; /*intercept when exec ,exit,systemcall entry,system call exit*/
	if (ioctl(target->memFd, PIOCBIC, flags) == -1){
		warn("can not unset Trace");
	}
	flags = PF_LINGER|PF_FORK;
	if (ioctl(target->memFd, PIOCSFL, flags) == -1){
		warn("can not unset LINGER FLAG");
	}
	val=0;
	ioctl(target->memFd, PIOCCONT, val);
	target->pid=-1;
	if(target->regFd != -1){
		close(target->regFd);
		target->regFd= -1;
	}
	if(target->memFd != -1){
		close(target->memFd);
		target->memFd= -1;
	}	
}

void attachPid(TargetInfo *target,int pid){
	int i;
	target->pid=pid;
	if(target->regFd != -1){
		close(target->regFd);
		target->regFd= -1;
	}
	if(target->memFd != -1){
		close(target->memFd);
		target->memFd= -1;
	}



	char buf[PROCLEN];
	
	snprintf(buf,PROCLEN, PROCFS"%d/mem", pid);	
	for(i=0;;i++){
		if ((target->memFd = open(buf, O_RDWR)) == -1) {
			if (kill(pid,0) !=  0 ){
				err(1,"forked process is already dead");
			}
			if (2<i){
				abortTarget(target,13,"info:cannot open %s. So,abort all.", buf);
			}
			usleep(500000);
			continue;/*retry*/
		}else{
			break;/*success to open*/
		}		
	}
	checkEtype(target);

	/*open RegisterFile*/
	{
		snprintf(buf,PROCLEN, PROCFS"%d/regs", target->pid);
		if ((target->regFd = open(buf, O_RDWR)) == -1) {
			abortTarget(target,1,"info:cannt open reg file:%s",buf);
		}
	}

	{/*set Process state*/
		int flags = S_EXEC | S_EXIT| S_SCE | S_SCX ; /*intercept when exec ,exit,systemcall entry,system call exit*/
		if (ioctl(target->memFd, PIOCBIS, flags) == -1){
			abortTarget(target,3, "info:cannt set process trace flag");
		}
		flags = PF_LINGER |PF_FORK;
		if (ioctl(target->memFd, PIOCSFL, flags) == -1){
			abortTarget(target,3,"info:cannot set PF_LINGER");
		}	
	}
}

void  runTarget(TargetInfo *target,char *command[]){
	int pid;
	pid=fork();
	if(pid<0)err(1,"cannt execute");
	
	if (pid == 0) {	/* Child */
		int mask = S_EXEC | S_EXIT ;
		int fd;
		fd = open(PROCFS"curproc/mem", O_WRONLY);
		if (fd == -1)
			err(2, "cannot open "PROCFS"curproc/mem");
		fcntl(fd, F_SETFD, FD_CLOEXEC);
		if (ioctl(fd, PIOCBIS, mask) == -1)err(3, "PIOCBIS");
		mask = PF_LINGER |PF_FORK;
		if (ioctl(fd, PIOCSFL, mask) == -1)warn("cannot set PF_LINGER");
		close(fd);
		execvp(command[0], command);
		fd = open(PROCFS"curproc/mem", O_WRONLY);
		if (fd == -1)
			err(2, "cannot open "PROCFS"curproc/mem on failexec");
		mask = ~0;
		if(-1==ioctl(fd, PIOCBIC, ~0)){
			warn("PIOBIC on fail exec");
		}
		err(4, "Faild to run execvp %s", command[0]);



	}else{
		attachPid(target,pid);
	}
}


void abortTarget(TargetInfo *target,int errorcode,char *fmt,...){
	int stat;
	va_list ap;

	va_start(ap, fmt);
	vfprintf(opt_outFp,fmt,ap);
	va_end(ap);
	fprintf(opt_outFp,"\n");

	stat= ~0;

	ioctl(target->memFd, PIOCBIC,stat);
	kill(target->pid,9);
	stat=0;
	ioctl(target->memFd, PIOCCONT,stat);
	waitpid(target->pid,&stat,0);
	exit(errorcode);
}

