/*(c)akira noda daemon@rogiken.org*/

#ifndef FREEBSD_COM_H
#define FREEBSD_COM_H

#define PROCFS "/proc/"
#define LINPROCFS "/usr/compat/linux/proc/"
#define PROCMAXSTR "/01234567890123456789/regs"
#define PROCLEN (sizeof(LINPROCFS)+sizeof(PROCMAXSTR))


#include <stdbool.h>


typedef struct {
	int pid;
	int regFd;
	int memFd;
	bool isStarted;
}TargetInfo;

void initializeTargetInfo(TargetInfo *target);
void checkLoop(TargetInfo *target);
void checkEtype(TargetInfo *target);
void detachTarget(TargetInfo *target);
void attachPid(TargetInfo *target,int pid);
void  runTarget(TargetInfo *target,char *command[]);
void abortTarget(TargetInfo *target,int errorcode,char *fmt,...);










/*****************/
/* event Hanblder in main.c */
void onSystemCallEnter(TargetInfo *target,unsigned int nargs);
void onSystemCallExit(TargetInfo *target,int systemcallNum);



#endif
