/*(c)akira noda daemon@rogiken.org*/
#include "freebsd_com.h"
#include "freebsd_abi.h"
#include <stdio.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <err.h>


bool opt_coldRun=false;
char * opt_whitelistFile="whitelist";
FILE * opt_outFp=0;


/*white lists*/
enum PathCheckListType {CHECK_FILE,CHECK_DIR,CHECK_DIR_REC};
typedef struct{
	char* path;
	int length;
	int type;
}PathCheckList;

PathCheckList *readList;
PathCheckList *writeList;
PathCheckList *execList;
PathCheckList *suExecList;

bool loadLine(char *buf,int *size,PathCheckList **list){
	if(buf[1] != 'f' &&buf[1] != 'd' &&buf[1] != 'D')return false;
	if(buf[3] != '/'){
		fprintf(opt_outFp,"info:path must be absolute path\ninfo: %s\n",buf);
		return false;
	}
	(*size) ++;
	
	*list = (PathCheckList *) realloc(*list,((*size)+1) * sizeof(PathCheckList));
	if(! *list){
		fprintf(opt_outFp,"info:malloc error units(%d),size(%d)\n",*size,((*size)+1) * sizeof(PathCheckList));
		return false;
	}

	/*delete \n char */
	int i;
	for(i=3;buf[i];i++){
		if(buf[i]=='\n'){
			buf[i]=0;
			break;
		}
	}
	(*list)[(*size) -1].path=malloc(1+strlen(&buf[3]));
	if(! (*list)[(*size) -1].path){
		fprintf(opt_outFp,"info:malloc error\n");
		return false;
	}
	strcpy((*list)[(*size) -1].path,&buf[3]);
	(*list)[(*size) -1].length=strlen(&buf[3]);
	(*list)[(*size) -1].type= (buf[1] =='D')?CHECK_DIR_REC:((buf[1]=='d')?CHECK_DIR:CHECK_FILE);	
	(*list)[(*size)].path=0;
	return true;
}

bool loadWhitelist(char *fileName){
	FILE *fp;
	/*FLAG 2chars separetar 1 char  path MAXPATHLEN + toolong detector 1char = MAXPATHLEN+4 length*/
	char buf[MAXPATHLEN+5];
	int readSize,writeSize,execSize,suExecSize;
	readSize=writeSize=execSize=suExecSize=0;
	readList=(PathCheckList*)malloc(sizeof(PathCheckList));
	readList[0].path=0;
	writeList=(PathCheckList*)malloc(sizeof(PathCheckList));
	writeList[0].path=0;
	execList=(PathCheckList*)malloc(sizeof(PathCheckList));
	execList[0].path=0;	
	suExecList=(PathCheckList*)malloc(sizeof(PathCheckList));
	writeList[0].path=0;	
	

	fp=fopen(fileName,"r");
	if(!fp)return false;
	while(fgets(buf,MAXPATHLEN+4,fp)){
		int len;
		len=strlen(buf);
		if(MAXPATHLEN+4 <= len){
			fprintf(opt_outFp,"info:too long line\n");
			fclose(fp);
			return false;
		}
		if(len <=3){
			fprintf(opt_outFp,"info:too short line\n");
			fclose(fp);
			return false;
		}
		switch(buf[0]){
		case 'R':
			if(! loadLine(buf,&readSize,&readList))return false;
			break;
		case 'W':
			if(! loadLine(buf,&writeSize,&writeList))return false;
			break;
		case 'E':
			if(! loadLine(buf,&execSize,&execList))return false;
			break;
		case 'S':
			if(! loadLine(buf,&suExecSize,&suExecList))return false;
			break;
		}
	}
	return true;
	
}




void usage(void){
	printf("usage:\n");
	printf("umal -c -l whiltelistfile[whiltelist] -o outputfile[out.log] \n");
	exit(1);

}

int main(int argc,char *argv[]){
	TargetInfo target;
	opt_outFp=stdout;
	{/*set optins*/
		int ch;
		while ((ch = getopt(argc, argv, "cl:o:")) != -1){
			switch (ch) {
			case 'c':
				opt_coldRun= true;
				break;
			case 'l':
				opt_whitelistFile=optarg;
				break;
			case 'o':
				opt_outFp=fopen(optarg,"w");
				if(!opt_outFp){
						err(1,"cannt open %s",optarg);
				}
				break;
			case '?':
			default:
				usage();
			}
		}
		argc -= optind;
		argv += optind;
	}
	if(argc <1){
		usage();
		return 1;
	}
	
	if(! opt_coldRun){
		if(!loadWhitelist(opt_whitelistFile)){
			err(1,"cannt open whitelist file:%s",opt_whitelistFile);
		}
	}

	initializeTargetInfo(&target);
	runTarget(&target,argv);
	/*
	signal(SIGINT, SIG_IGN);

	signal(SIGTERM, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	*/
	checkLoop(&target);
	return 0;
}








bool checkPathList(const char *target,const PathCheckList list[]){
	int i;	
	for(i=0;list[i].path != 0 ;i++){
		if(list[i].type == CHECK_FILE){
			if(0!=strcmp(target,list[i].path))continue;
		}else{

			if(0!=strncmp(target,list[i].path,list[i].length))continue;
			if(list[i].type == CHECK_DIR){
				int j;
				bool haveSlash;
				haveSlash=false;
				for(j=list[i].length;target[j];j++){
					if(target[j]=='/')haveSlash=true;
				}
				if(haveSlash)continue;
			}
		}
		
		/* pass the Check list */
		return true;		
	}
	return false;
}


enum PERM{PERM_READ=1,PERM_WRITE=2,PERM_EXEC=4,PERM_SU_EXEC=8};

void checkFile(TargetInfo *target,unsigned long fileNamePos,int perm){
	char buf[MAXPATHLEN+1];
	char buf2[MAXPATHLEN*2+1];
	lseek(target->memFd,fileNamePos,SEEK_SET);
	read(target->memFd,buf,MAXPATHLEN);
	buf[MAXPATHLEN]=0;
 
	
	if(MAXPATHLEN <= strlen(buf)){
		abortTarget(target,10,"too long path %s\n",buf);
	}
		 
	if(buf[0] != '/'){/*relative path sor resolve it*/
		int len;
		len=strlen(buf);
		snprintf(buf2,PROCLEN,LINPROCFS"%d/cwd/%s",target->pid,buf);
		if(0==realpath(buf2,buf)){
			abortTarget(target,10,"cannt get realpath  %s\n",buf2);
		}
	}
	/*buf is real path */	
	
	if(perm & PERM_READ){
		if(opt_coldRun)fprintf(opt_outFp,"READ:%d:%s\n",target->pid,buf);
		else if(!checkPathList(buf,readList))abortTarget(target,21,"read not permited:%s",buf);
	}
	if(perm & PERM_WRITE){
		if(opt_coldRun)fprintf(opt_outFp,"WRITE:%d:%s\n",target->pid,buf);
		else if(!checkPathList(buf,writeList))abortTarget(target,22,"write not permited:%s",buf);
	}
	if(perm & PERM_EXEC){
		if(opt_coldRun)fprintf(opt_outFp,"EXEC:%d:%s\n",target->pid,buf);
		else if(!checkPathList(buf,execList))abortTarget(target,23,"exec not permited:%s",buf);
		
		{
			struct stat sb;
			if(0==stat(buf,&sb)){/*TODO: yet not check the error code */
				if( 
					 (sb.st_mode & (S_ISUID) ) && 
					 (sb.st_uid != getuid()) 
					 )perm |=  PERM_SU_EXEC;
			}	
		}
	}
	if(perm & PERM_SU_EXEC){
		if(opt_coldRun)fprintf(opt_outFp,"SUEXEC:%d:%s\n",target->pid,buf);
		else if(!checkPathList(buf,suExecList))abortTarget(target,24,"suExec not permited:%s",buf);
	}
	
}


void onSystemCallEnter(TargetInfo *target,unsigned int nargs){
	/*$B$3$3$G$N$*;E;v(B:$B$d$P$$%7%9%F%`%3!<%k$h$s$G$?$i!"(BSIG_KILL$B$r8F$S=P$7$F;&$9(B(abortTarget$B4X?t$r8F$V(B)*/
				
	int systemcallNum;
	unsigned long data[10];
	
	if(10<nargs || 0==getArg(target,&systemcallNum,data,nargs)){
		abortTarget(target,11,"cannt get arg");
		err(5,"cannt get arg:%d",nargs);
	}
	/*printf("syscallEnter %d   %d\n",systemcallNum,target->pid);*/
	switch(systemcallNum){
	case SYS_open:
		{	
			int perm= PERM_READ|PERM_WRITE;
			if((data[1]&O_ACCMODE) == O_RDONLY)perm&= ~PERM_WRITE;
			if((data[1]&O_ACCMODE) == O_WRONLY)perm&= ~PERM_READ;
			checkFile(target,data[0],perm);
		}
		break;
	case SYS___mac_execve:
	case SYS_execve:
		printf("exec\n");
		checkFile(target,data[0],PERM_EXEC);
		break;
	case SYS_exit:
		detachTarget(target);
		break;
	default:;
	}
}


void onSystemCallExit(TargetInfo *target,int systemcallNum){
	/* eax edx Carry Flag is overwritten by systemcall */
	/*$B$3$3$G$N$*;E;v(Bfork$B8e$N(Bretval$B$,(B0$B$@$C$?$i%7%9%F%`$r%U%)!<%/$9$k!J(Bfork$B$5$l$?%W%m%;%9$KBP$7$F<+J,<+?H$b(Bfork$B$7$F$*$C$+$1$k(B)*/
	unsigned long retVal;
	unsigned long retVal2;
	int error;
	getRetValue(target,&error,&retVal,&retVal2);

	/*printf("syscallExit %d\n",systemcallNum);*/
	switch(systemcallNum){
	case SYS_fork:
	case SYS_vfork:	
	case SYS_rfork:
		if(retVal!=0 && (!error) && 0==fork()){
			attachPid(target,(int)retVal);
		}else{
			/*child*/
		}
		break;
		
	default: ;
	}

}

