/*(c)akira noda daemon@rogiken.org*/

#define PROCFS "/proc/"
#define LINPROCFS "/usr/compat/linux/proc/"
#define PROCMAXSTR "/01234567890123456789/regs"
#define PROCLEN (sizeof(LINPROCFS)+sizeof(PROCMAXSTR))

#include <sys/types.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/pioctl.h>
#include <sys/syscall.h>
#include <machine/reg.h>
#include <machine/psl.h>
#include <signal.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <err.h>
#include <sys/types.h>
#include <sys/stat.h>




/*white lists*/
enum PathCheckListType {CHECK_FILE,CHECK_DIR,CHECK_DIR_REC};
typedef struct{
	char* path;
	int length;
	int type;
}PathCheckList;

PathCheckList readList[]={
	{PROCFS"curproc/mem",sizeof(PROCFS"curporc/mem")-1,CHECK_FILE},
	{"/etc/libmap.conf",sizeof("/etc/libmap.conf")-1,CHECK_FILE},
	{"/var/run/ld-elf.so.hints",sizeof("/var/run/ld-elf.so.hints")-1,CHECK_FILE},
	{"/usr/lib/",sizeof("/usr/lib")-1,CHECK_DIR_REC},
	{"/usr/share/locale/",sizeof("/usr/share/locale/")-1,CHECK_DIR_REC},
	{"/usr/share/locale/",sizeof("/usr/share/locale/")-1,CHECK_DIR_REC},
	{"/lib/",sizeof("/lib")-1,CHECK_DIR_REC},
	{"/usr/local/lib/",sizeof("/usr/local/lib")-1,CHECK_DIR_REC},
	{"/usr/home/akira/",sizeof("/usr/home/akira/")-1,CHECK_DIR_REC},
	{0,0,0}
};
PathCheckList writeList[]={
	{PROCFS"curproc/mem",sizeof(PROCFS"curporc/mem"),CHECK_FILE},
	{"/usr/home/akira/write/",sizeof("/usr/home/akira/write/"),CHECK_DIR_REC},
	{0,0,0}
};
PathCheckList execList[]={
	{"/abin/cat",sizeof("/bin/cat"),CHECK_FILE},
	{0,0,0}
};
PathCheckList suExecList[]={
	{0,0,0}
};




bool checkPathList(const char *target,const PathCheckList list[]){
	int i;	
	for(i=0;list[i].path != 0 ;i++){
		if(list[i].type == CHECK_FILE){
			if(0!=strcmp(target,list[i].path))continue;
		}else{

			if(0!=strncmp(target,list[i].path,list[i].length))continue;
			if(list[i].type == CHECK_DIR){
				int j;
				bool haveSlash;
				haveSlash=false;
				for(j=list[i].length;target[j];j++){
					if(target[j]=='/')haveSlash=true;
				}
				if(haveSlash)continue;
			}
		}
		
		/* pass the Check list */
		return true;		
	}
	return false;
}


typedef struct {
	int pid;
	int regFd;
	int memFd;
	bool isStarted;
}TargetInfo;

void initializeTargetInfo(TargetInfo *target){
	target->pid=-1;
	target->regFd=-1;
	target->memFd=-1;
	target->isStarted=false;
}


void  runTarget(TargetInfo *target,char *command[]);
void attachPid(TargetInfo *target,int pid);
void detachTarget(TargetInfo *target);
void checkLoop(TargetInfo *target);
void onSystemCallEnter(TargetInfo *target,unsigned int nargs);
void onSystemCallExit(TargetInfo *target,int systemCallNum);
void checkEtype(TargetInfo *target);

void abortTarget(TargetInfo *target,int errorcode,char *fmt,...){
	int stat;
	va_list ap;

	va_start(ap, fmt);
	vprintf(fmt,ap);
	va_end(ap);
	printf("\n");

	stat= ~0;
	ioctl(target->memFd, PIOCBIC,stat);
	kill(target->pid,9);
	stat=0;
	ioctl(target->memFd, PIOCCONT,stat);
	waitpid(target->pid,&stat,0);
	exit(errorcode);
}


int setArg(TargetInfo* target,unsigned long *data ,int nofArg);
int getArg(TargetInfo* target,int *systemcallNum,unsigned long *data ,int nofArg);
int getRetValue(TargetInfo *target,int *error,unsigned long *retVal,unsigned long *retVal2);

int main(int argvc,char *argv[]){
	TargetInfo target;
	initializeTargetInfo(&target);
	runTarget(&target,argv+1);
	/*
	signal(SIGINT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	*/
	checkLoop(&target);
	return 0;
}

void checkLoop(TargetInfo *target){
	struct procfs_status pfs;
	while(1){

		alarm(1);/*to avoid stack in ictl*/
		if(ESRCH == kill(target->pid,0)){
			printf("pid is gone");
			detachTarget(target);
			exit(0);
		}
		errno=0;
		if (ioctl(target->memFd, PIOCWAIT, &pfs) == -1){
			if(errno==EINTR)continue;
			printf("procfs is gone");
			detachTarget(target);
			exit(1);
		}else {
			alarm(0);
			if(pfs.why==S_EXIT)break; /*target programl end*/
			switch(pfs.why) {
			case S_SCE:
				/*pfs.val is narg.*/
				if(target->isStarted){
					onSystemCallEnter(target,pfs.val);
				}
				break;
			case S_SCX:
				
				/*pfs.val is system call No.*/
				if(target->isStarted){
					onSystemCallExit(target,pfs.val);
				}
				break;
			case S_EXEC:
				target->isStarted=true;
				checkEtype(target);
				break;
			case S_EXIT:
				{
					int stat;
					stat= ~0;
					ioctl(target->memFd, PIOCBIC,stat);
					stat=0;
					ioctl(target->memFd, PIOCCONT,stat);
					waitpid(target->pid,&stat,0);
				}
				break;
			default: ;
			}
			{/*continue */
				int val=0;
				if (ioctl(target->memFd, PIOCCONT, val) == -1 ) {
					if (kill(target->pid, 0) == -1 && errno == ESRCH)
						break;
					else
						warn("PIOCCONT");
				}
			}
		}
	}
}
enum PERM{PERM_READ=1,PERM_WRITE=2,PERM_EXEC=4,PERM_SU_EXEC=8};

void checkFile(TargetInfo *target,unsigned long fileNamePos,int perm){
	char buf[MAXPATHLEN+1];
	char buf2[MAXPATHLEN*2+1];
	lseek(target->memFd,fileNamePos,SEEK_SET);
	read(target->memFd,buf,MAXPATHLEN);
	buf[MAXPATHLEN]=0;
 
	
	if(MAXPATHLEN <= strlen(buf)){
		abortTarget(target,10,"too long path %s\n",buf);
	}
		 
	if(buf[0] != '/'){/*relative path sor resolve it*/
		int len;
		len=strlen(buf);
		snprintf(buf2,PROCLEN,LINPROCFS"%d/cwd/%s",target->pid,buf);
		if(0==realpath(buf2,buf)){
			abortTarget(target,10,"cannt get realpath  %s\n",buf2);
		}
	}
	/*buf is real path */	
	printf("open: %s\n",buf);
	if(perm & PERM_READ){
		if(!checkPathList(buf,readList))abortTarget(target,21,"read not permited:%s",buf);
	}
	if(perm & PERM_WRITE){
		if(!checkPathList(buf,writeList))abortTarget(target,22,"write not permited:%s",buf);
	}
	if(perm & PERM_EXEC){
		if(!checkPathList(buf,execList))abortTarget(target,23,"exec not permited:%s",buf);
		{
			struct stat sb;
			if(0==stat(buf,&sb)){/*TODO: yet not check the error code */
				if( 
					 (sb.st_mode & (S_ISUID) ) && 
					 (sb.st_uid != getuid()) 
					 )perm |=  PERM_SU_EXEC;
			} 
			
		}
	}
	if(perm & PERM_SU_EXEC){
		if(!checkPathList(buf,suExecList))abortTarget(target,24,"suExec not permited:%s",buf);
	}
	
}


void onSystemCallEnter(TargetInfo *target,unsigned int nargs){
	/*$B$3$3$G$N$*;E;v(B:$B$d$P$$%7%9%F%`%3!<%k$h$s$G$?$i!"(BSIG_KILL$B$r8F$S=P$7$F;&$9(B(abortTarget$B4X?t$r8F$V(B)*/
				
	int systemcallNum;
	unsigned long data[10];
	
	if(10<nargs || 0==getArg(target,&systemcallNum,data,nargs)){
		abortTarget(target,11,"cannt get arg");
		err(5,"cannt get arg:%d",nargs);
	}
	/*printf("syscallEnter %d   %d\n",systemcallNum,target->pid);*/
	switch(systemcallNum){
	case SYS_open:
		{	
			int perm= PERM_READ|PERM_WRITE;
			if((data[1]&O_ACCMODE) == O_RDONLY)perm&= ~PERM_WRITE;
			if((data[1]&O_ACCMODE) == O_WRONLY)perm&= ~PERM_READ;
			checkFile(target,data[0],perm);
		}
		break;
	case SYS_execve:
	case SYS___mac_execve:
			checkFile(target,data[0],PERM_EXEC);
		break;
	default:;
	}
}


void onSystemCallExit(TargetInfo *target,int systemcallNum){
	/* eax edx Carry Flag is overwritten by systemcall */
	/*$B$3$3$G$N$*;E;v(Bfork$B8e$N(Bretval$B$,(B0$B$@$C$?$i%7%9%F%`$r%U%)!<%/$9$k!J(Bfork$B$5$l$?%W%m%;%9$KBP$7$F<+J,<+?H$b(Bfork$B$7$F$*$C$+$1$k(B)*/
	unsigned long retVal;
	unsigned long retVal2;
	int error;
	getRetValue(target,&error,&retVal,&retVal2);

	/*printf("syscallExit %d\n",systemcallNum);*/
	switch(systemcallNum){
	case SYS_fork:
	case SYS_vfork:	
	case SYS_rfork:
		if(retVal!=0 && (!error) && 0==fork()){
			/*attach forked process*/			
			attachPid(target,(int)retVal);
		}
		break;
		
	default: ;
	}

}



/***********************************/
/*ABI depend codes*/
int getRetValue(TargetInfo *target,int *error,unsigned long *retVal,unsigned long *retVal2){
	struct reg regs;
	lseek(target->regFd, 0L, SEEK_SET);
  if (read(target->regFd, &regs, sizeof(regs)) != sizeof(regs)){
    return 0;
  }
	*retVal=  regs.r_eax;
	*retVal2= regs.r_edx;/*pipe(2) returns 2 set of retvalue*/
	*error=   regs.r_eflags & PSL_C;
	return 1;
}


int getArg(TargetInfo* target,int *systemcallNum,unsigned long *data ,int nofArg){
	struct reg regs;
	lseek(target->regFd, 0L, SEEK_SET);
  if (read(target->regFd, &regs, sizeof(regs)) != sizeof(regs)){
    return 0;
  }
	unsigned int parm_offset = regs.r_esp + sizeof(unsigned long);
	switch(regs.r_eax){
	case SYS_syscall:
	case SYS___syscall:
		lseek(target->memFd, parm_offset, SEEK_SET);
		read(target->memFd, &systemcallNum, sizeof(unsigned long));
		parm_offset+=sizeof(unsigned long);
		if(regs.r_eax== SYS___syscall)parm_offset+=sizeof(unsigned long);
		break;
	default:
		*systemcallNum=regs.r_eax;
		break;

	}

	lseek(target->memFd, parm_offset, SEEK_SET);
	if (read(target->memFd, data, nofArg * sizeof(unsigned long)) != (int)(nofArg * sizeof(unsigned long)) )return 0;
	return 1;
}

int setArg(TargetInfo* target,unsigned long *data ,int nofArg){
	struct reg regs;
	lseek(target->regFd, 0L, SEEK_SET);
  if (read(target->regFd, &regs, sizeof(regs)) != sizeof(regs)){
    return 0;
  }

	unsigned int parm_offset = regs.r_esp + sizeof(unsigned long);
	switch(regs.r_eax){
	case SYS_syscall:
		parm_offset+=sizeof(unsigned long);
		break;
	case SYS___syscall:
		parm_offset+=sizeof(unsigned long)*2;
		break;
	default:
		break;
	}

	lseek(target->memFd, parm_offset, SEEK_SET);
	if (write(target->memFd, data, nofArg * sizeof(unsigned long)) !=  (int)(nofArg * sizeof(unsigned long)) )return 0;
	return 1;
}

/************************************/










void checkEtype(TargetInfo *target){
	int fd;
	char buf[PROCLEN];
	snprintf(buf,PROCLEN, PROCFS"%d/etype", target->pid);
	if ((fd = open(buf, O_RDONLY)) == -1) {
		strcpy(buf, "FreeBSD a.out");
	} else {
		int len = read(fd, buf, sizeof(buf));
		buf[len-1] = '\0';
		close(fd);
	}
	if(
		 0!=strcmp("FreeBSD a.out",buf) &&
			 0!=strcmp("FreeBSD ELF",buf) &&
		 0!=strcmp("FreeBSD ELF32",buf)){
			abortTarget(target,12,"not suitable target %s\n",buf);
			err(1,"Not Suitable execute file");
	}
}
void detachTarget(TargetInfo *target){
	int flags = S_EXEC | S_EXIT| S_SCE | S_SCX ; /*intercept when exec ,exit,systemcall entry,system call exit*/
	if (ioctl(target->memFd, PIOCBIC, flags) == -1){
		warn("can not unset Trace");
	}
	flags = 0;
	if (ioctl(target->memFd, PIOCSFL, flags) == -1){
		warn("can not unset LINGER FLAG");
	}
	
	target->pid=-1;
	if(target->regFd != -1){
		close(target->regFd);
		target->regFd= -1;
	}
	if(target->memFd != -1){
		close(target->memFd);
		target->memFd= -1;
	}	
}
void attachPid(TargetInfo *target,int pid){
	int i;
	target->pid=pid;
	if(target->regFd != -1){
		close(target->regFd);
		target->regFd= -1;
	}
	if(target->memFd != -1){
		close(target->memFd);
		target->memFd= -1;
	}


	char buf[PROCLEN];
	
	snprintf(buf,PROCLEN, PROCFS"%d/mem", pid);	
	for(i=0;;i++){
		if ((target->memFd = open(buf, O_RDWR)) == -1) {
			if (waitpid(pid, NULL, WNOHANG) != 0){
				err(1,"forked process is already dead");
			}
			if (2<i){
				abortTarget(target,13,"cannot open1 %s. So,abort all.", buf);
			}
			usleep(500000);
			continue;/*retry*/
		}else{
			break;/*success to open*/
		}		
	}
	checkEtype(target);

	/*open RegisterFile*/
	{
		snprintf(buf,PROCLEN, PROCFS"%d/regs", target->pid);
		if ((target->regFd = open(buf, O_RDWR)) == -1) {
			abortTarget(target,1,"cannt open reg file:%s",buf);
		}
	}

	{/*set Process state*/
		int flags = S_EXEC | S_EXIT| S_SCE | S_SCX ; /*intercept when exec ,exit,systemcall entry,system call exit*/
		if (ioctl(target->memFd, PIOCBIS, flags) == -1){
			abortTarget(target,3, "PIOCBIS");
		}
		flags = PF_LINGER;
		if (ioctl(target->memFd, PIOCSFL, flags) == -1){
			abortTarget(target,3,"cannot set PF_LINGER");
		}	
	}
}

void  runTarget(TargetInfo *target,char *command[]){
	int pid;
	pid=fork();
	if(pid<0)err(1,"cannt execute");
	
	if (pid == 0) {	/* Child */
		int mask = S_EXEC | S_EXIT ;
		int fd;
		fd = open(PROCFS"curproc/mem", O_WRONLY);
		if (fd == -1)
			err(2, "cannot open "PROCFS"curproc/mem");
		fcntl(fd, F_SETFD, FD_CLOEXEC);
		if (ioctl(fd, PIOCBIS, mask) == -1)err(3, "PIOCBIS");
		mask = PF_LINGER;
		if (ioctl(fd, PIOCSFL, mask) == -1)warn("cannot set PF_LINGER");
		close(fd);
		execvp(command[0], command);
		fd = open(PROCFS"curproc/mem", O_WRONLY);
		if (fd == -1)
			err(2, "cannot open "PROCFS"curproc/mem on failexec");
		mask = ~0;
		if(-1==ioctl(fd, PIOCBIC, ~0)){
			warn("PIOBIC on fail exec");
		}
		err(4, "Faild to run execvp %s", command[0]);



	}else{
		attachPid(target,pid);
	}
}


