// {ԃNX

#include <iomanip>
#include <sstream>
#include <cstdlib>
#include <cmath>
#include "lilib.h"

using namespace std;
using namespace lilib;

// *this = |a| + |b|
void LongInterval::addAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 carry;

  radius.significand = 0;
  radius.exponent = 0;

  // n ́A a  b ̏dȂĂ錅B
  n = longSize - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    center = a;
    radius = Radius(b);
    return;
  }

  // ؂̂Ă鉼덷Ɏ荞ށB
  for(i = longSize - 1; i >= n; i--){
    radius += Radius(b.significand[i], LIMB_BITS * (b.exponent - i));
  }

  // Z
  carry = 0;
  j = n - 1;
  for(i = longSize - 1; i >= longSize - n; i--){
    work = a.significand[i];
    work += b.significand[j];
    work += carry;
    center.significand[i] = low32(work);
    carry = high32(work);
    j--;
  }

  for(i = longSize - n - 1; i >= 0; i--){
    work = a.significand[i];
    work += carry;
    center.significand[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){

    // ؂̂Ă鉼덷Ɏ荞ށB
    radius += Radius(center.significand[longSize - 1], LIMB_BITS * (a.exponent - longSize + 1));

    for(i = longSize - 1; i > 0; i--){
      center.significand[i] = center.significand[i - 1];
    }
    center.significand[0] = carry;

    center.exponent = a.exponent + 1;
  }
  else{
    center.exponent = a.exponent;
  }
}

// *this = |a| - |b|
void LongInterval::subAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 *y, carry;

  radius.significand = 0;
  radius.exponent = 0;

  // n ́A a  b ̏dȂĂ錅B
  n = longSize - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    center = a;
    radius = Radius(b);
    return;
  }

  // SɏdȂĂꍇB
  if(n == longSize){
    carry = 0;
    for(i = longSize - 1; i >= 0; i--){
      work = 0x100000000LL;
      work += a.significand[i];
      work -= b.significand[i];
      work -= carry;
      center.significand[i] = low32(work);
      carry = 1 - high32(work);
      j--;
    }

    center.exponent = a.exponent;

    // ̐K
    center.normalize();

    return;
  }

  // a  b ̌ĂꍇAꌅvZB
  y = new uint32[longSize + 1];

  // ؂̂Ă鉼덷Ɏ荞ށB
  for(i = longSize - 1; i > n; i--){
    radius += Radius(b.significand[i], LIMB_BITS * (b.exponent - i));
  }

  work = 0x100000000LL;
  work -= b.significand[n];
  y[longSize] = low32(work);
  carry = 1 - high32(work);

  // Z
  j = n - 1;
  for(i = longSize - 1; i >= longSize - n; i--){
    work = 0x100000000LL;
    work += a.significand[i];
    work -= b.significand[j];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
    j--;
  }

  // J艺
  for(i = longSize - n - 1; i >= 0; i--){
    work = 0x100000000LL;
    work += a.significand[i];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
  }

  // ̐K
  for(n = 0; n < longSize + 1; n++){
    if(y[n] != 0){
      break;
    }
  }

  center.exponent = a.exponent - n;

  // ؂̂Ă鉼덷Ɏ荞ށB
  if(n == 0){
    radius += Radius(y[longSize], LIMB_BITS * (center.exponent - longSize));
  }

  for(i = 0; i < longSize; i++){
    if(i + n < longSize + 1){
      center.significand[i] = y[i + n];
    }
    else{
      center.significand[i] = 0;
    }
  }

  delete []y;
}

////////////////////////////////////////////////////////////////////////////////

// *this = 1 / x
void LongInterval::inverse(const LongInterval &x){
  LongInterval z, tmp;
  LongFloat rr, radZ, epsilon, a, b;

  // z = mid(x) ^ 2 - rad(x) ^ 2
  rr.mul(x.radius, x.radius);
  z = LongInterval(x.center) * x.center - rr;
  radZ = z.rad();

  center.inverse(z.center);

  epsilon = 1;
  epsilon.exponent = -longSize + 1;

  // a = sup(sup(z) * epsilon + rad(z));
  tmp = z.sup();
  tmp *= epsilon;
  tmp += radZ;
  a = tmp.sup();

  // b = inf(mid(z) * inf(z))
  tmp = z.center;
  tmp *= z.inf();
  b = tmp.inf();

  // radius = a / b ւ̊ۂ߂ŌvZB
  radius.div(a, b);

  *this *= x;
}

////////////////////////////////////////////////////////////////////////////////

// *this = a * b
void LongInterval::mul(const LongFloat &a, int b){
  int i;
  uint64 work;
  uint32 carry;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b >= 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
    b = -b;
  }

  // Z
  carry = 0;
  for(i = longSize - 1; i >= 0; i--){
    work = a.significand[i];
    work *= b;
    work += carry;
    center.significand[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){

    // ؂̂Ă鉼덷Ɏ荞ށB
    radius = Radius(center.significand[longSize - 1], LIMB_BITS * (a.exponent - longSize + 1));

    for(i = longSize - 1; i > 0; i--){
      center.significand[i] = center.significand[i - 1];
    }
    center.significand[0] = carry;

    center.exponent = a.exponent + 1;
  }
  else{
    center.exponent = a.exponent;
  }
}

// *this = a / b
void LongInterval::div(const LongFloat &a, int b){
  int i;
  uint64 work;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b >= 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
    b = -b;
  }

  // Z
  work = 0;
  for(i = 0; i < longSize; i++){
    work <<= LIMB_BITS;
    work += a.significand[i];
    center.significand[i] = work / b;
    work -= center.significand[i] * b;
  }

  // J艺
  if(center.significand[0] == 0){
    for(i = 0; i < longSize - 1; i++){
      center.significand[i] = center.significand[i + 1];
    }
    work <<= LIMB_BITS;
    center.significand[longSize - 1] = work / b;

    center.exponent = a.exponent - 1;
  }
  else{
    center.exponent = a.exponent;
  }

  // ؂̂Ă鉼덷Ɏ荞ށB
  if(work){
    radius = Radius(1, LIMB_BITS * (center.exponent - longSize + 1));
  }
}

// *this = a + b
void LongInterval::add(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.significand[0] == 0){
    center = b;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }
  if(b.significand[0] == 0){
    center = a;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }

  if(a.sign == b.sign){
    center.sign = a.sign;
    if(a.exponent >= b.exponent){
      addAbs(a, b);
    }
    else{
      addAbs(b, a);
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      center.sign = a.sign;
      subAbs(a, b);
    }
    else{
      center.sign = b.sign;
      subAbs(b, a);
    }
  }
}

// *this = a - b
void LongInterval::sub(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.significand[0] == 0){
    center = b;
    center.sign *= -1;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }
  if(b.significand[0] == 0){
    center = a;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }

  if(a.sign != b.sign){
    center.sign = a.sign;
    if(a.exponent >= b.exponent){
      addAbs(a, b);
    }
    else{
      addAbs(b, a);
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      center.sign = a.sign;
      subAbs(a, b);
    }
    else{
      center.sign = -b.sign;
      subAbs(b, a);
    }
  }
}

// *this = a * b
void LongInterval::mul(const LongFloat &a, const LongFloat &b){
  int i, j;
  uint64 tmp;
  uint32 carry;
  uint32 *work;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b.sign > 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
  }

  // [NXy[X̊m
  work = new uint32[2 * longSize];

  // [NXy[X̏
  for(i = 0; i < 2 * longSize; i++){
    work[i] = 0;
  }

  // MZɂZ
  for(i = longSize - 1; i >= 0; i--){
    carry = 0;
    for(j = longSize - 1; j >= 0; j--){
      tmp = a.significand[i];
      tmp *= b.significand[j];
      tmp += carry;
      tmp += work[i + j + 1];

      work[i + j + 1] = low32(tmp);
      carry = high32(tmp);
    }
    work[i] += carry;
  }

  // Zʂ̏ʔoB
  if(work[0]){
    for(i = 0; i < longSize; i++){
      center.significand[i] = work[i];
    }
    center.exponent = a.exponent + b.exponent + 1;

    // ؂̂Ă鉼덷Ɏ荞ށB
    for(i = 2 * longSize - 1; i >= longSize; i--){
      radius += Radius(work[i], LIMB_BITS * (center.exponent - i));
    }
  }
  else{
    for(i = 0; i < longSize; i++){
      center.significand[i] = work[i + 1];
    }
    center.exponent = a.exponent + b.exponent;

    // ؂̂Ă鉼덷Ɏ荞ށB
    for(i = 2 * longSize - 1; i >= longSize + 1; i--){
      radius += Radius(work[i], LIMB_BITS * (center.exponent - i + 1));
    }
  }

  // [NXy[X̔j
  delete []work;
}

////////////////////////////////////////////////////////////////////////////////

// [̎擾(0ۂ)
LongFloat LongInterval::infIn() const{
  LongInterval y;

  y = center;
  y -= rad();

  if(y.radius.significand){
    if(y.center.significand[0] == 0){
      y.center.increase();
      y.center.sign = 1;
    }
    else{
      if(y.center.sign > 0){
        y.center.increase();
      }
      else{
        y.center.decrease();
      }
    }
  }

  return y.center;
}

// [̎擾(0ۂ)
LongFloat LongInterval::supIn() const{
  LongInterval y;

  y = center;
  y += rad();

  if(y.radius.significand){
    if(y.center.significand[0] == 0){
      y.center.increase();
      y.center.sign = -1;
    }
    else{
      if(y.center.sign > 0){
        y.center.decrease();
      }
      else{
        y.center.increase();
      }
    }
  }

  return y.center;
}

////////////////////////////////////////////////////////////////////////////////

// RXgN^
LongInterval::LongInterval(){
}

// RXgN^
LongInterval::LongInterval(int x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;
}

// RXgN^
LongInterval::LongInterval(double x){
  center.setDouble(x);

  radius.significand = 0;
  radius.exponent = 0;
}

// RXgN^
LongInterval::LongInterval(const LongFloat &x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;
}

// Rs[RXgN^
LongInterval::LongInterval(const LongInterval &x){
  center = x.center;
  radius = x.radius;
}

// RXgN^
LongInterval::LongInterval(int mid, int rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(const LongFloat &mid, int rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(int mid, const LongFloat &rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(const LongFloat &mid, const LongFloat &rad){
  setMidRad(mid, rad);
}

// fXgN^
LongInterval::~LongInterval(){
}

////////////////////////////////////////////////////////////////////////////////

// double ̕ϊ
void LongInterval::setDouble(double x){
  center.setDouble(x);

  radius.significand = 0;
  radius.exponent = 0;
}

// SlƔa̐ݒ
void LongInterval::setMidRad(int mid, int rad){
  if(rad < 0){
    cerr << "[ERROR] LongInterval::setMidRad("
      << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad, 0);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(const LongFloat &mid, int rad){
  if(rad < 0){
    cerr << "[ERROR] LongInterval::setMidRad("
      << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad, 0);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(int mid, const LongFloat &rad){
  if(rad.sign < 0){
    cerr << "[ERROR] LongInterval::setMidRad("
      << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(const LongFloat &mid, const LongFloat &rad){
  if(rad.sign < 0){
    cerr << "[ERROR] LongInterval::setMidRad("
      << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad);
}

////////////////////////////////////////////////////////////////////////////////

// double ւ̕ϊ
double LongInterval::getDouble() const{
  return center.getDouble();
}

// SlƔa\̎擾
string LongInterval::getMidRad() const{
  ostringstream output;

  output << "<" << center << ", " << radius << ">";

  return output.str();
}

// [Ə[\̎擾
string LongInterval::getInfSup() const{
  ostringstream output;

  output << "[" << inf() << ", " << sup() << "]";

  return output.str();
}

// f[^\̎擾
string LongInterval::getInternalData() const{
  ostringstream output;

  output << center.getInternalData() << endl;
  output << "radius   : " << radius.getInternalData();

  return output.str();
}

////////////////////////////////////////////////////////////////////////////////

// Sl̎擾
LongFloat LongInterval::mid() const{
  return center;
}

// a̎擾
LongFloat LongInterval::rad() const{
  return LongFloat(radius);
}

// a̎擾
LongFloat LongInterval::diam() const{
  return LongFloat(Radius(radius.significand, radius.exponent + 1));
}

// [̎擾
LongFloat LongInterval::inf() const{
  LongInterval y;

  y = center;
  y -= rad();

  if(y.radius.significand){
    if(y.center.significand[0] == 0){
      y.center.increase();
      y.center.sign = -1;
    }
    else{
      if(y.center.sign > 0){
        y.center.decrease();
      }
      else{
        y.center.increase();
      }
    }
  }

  return y.center;
}

// [̎擾
LongFloat LongInterval::sup() const{
  LongInterval y;

  y = center;
  y += rad();

  if(y.radius.significand){
    if(y.center.significand[0] == 0){
      y.center.increase();
      y.center.sign = 1;
    }
    else{
      if(y.center.sign > 0){
        y.center.increase();
      }
      else{
        y.center.decrease();
      }
    }
  }

  return y.center;
}

// őΒl̎擾
LongFloat LongInterval::mag() const{
  if(center.sign > 0){
    return sup();
  }
  else{
    return -inf();
  }
}

// ŏΒl̎擾
LongFloat LongInterval::mig() const{

  // 0 ܂ޏꍇB
  if(center.compareAbs(rad()) <= 0){
    return 0;
  }

  if(center.sign > 0){
    return inf();
  }
  else{
    return -sup();
  }
}

// x ܂ނ
int LongInterval::contains(int x) const{
  if((x <= inf()) || (sup() <= x)){
    return 0;
  }

  if((infIn() < x) && (x < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(int x) const{
  if((x < inf()) || (sup() < x)){
    return 0;
  }

  if((infIn() <= x) && (x <= supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ
int LongInterval::contains(const LongFloat &x) const{
  if((x <= inf()) || (sup() <= x)){
    return 0;
  }

  if((infIn() < x) && (x < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(const LongFloat &x) const{
  if((x < inf()) || (sup() < x)){
    return 0;
  }

  if((infIn() <= x) && (x <= supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ
int LongInterval::contains(const LongInterval &x) const{
  if((x.infIn() <= inf()) || (sup() <= x.supIn())){
    return 0;
  }

  if((infIn() < x.inf()) && (x.sup() < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(const LongInterval &x) const{
  if((x.infIn() < inf()) || (sup() < x.supIn())){
    return 0;
  }

  if((infIn() <= x.inf()) && (x.sup() <= supIn())){
    return 1;
  }

  return -1;
}

// PZ
////////////////////////////////////////////////////////////////////////////////

// +LongInterval
LongInterval LongInterval::operator +() const{
  return *this;
}

// -LongInterval
LongInterval LongInterval::operator -() const{
  LongInterval result;

  result = *this;
  result.center.sign = -center.sign;

  return result;
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// LongInterval + int
LongInterval LongInterval::operator +(int x) const{
  return *this + LongFloat(x);
}

// LongInterval - int
LongInterval LongInterval::operator -(int x) const{
  return *this - LongFloat(x);
}

// LongInterval * int
LongInterval LongInterval::operator *(int x) const{
  LongInterval result;
  Radius r;

  r = radius * x;
  result.mul(center, x);
  result.radius += r;

  return result;
}

// LongInterval / int
LongInterval LongInterval::operator /(int x) const{
  LongInterval result;
  Radius r;

  if(x == 0){
    cerr << "[ERROR] LongInterval / int : Division by zero." << endl;
    exit(1);
  }

  r = radius / x;
  result.div(center, x);
  result.radius += r;

  return result;
}

// LongInterval + LongFloat
LongInterval LongInterval::operator +(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius;
  result.add(center, x);
  result.radius += r;

  return result;
}

// LongInterval - LongFloat
LongInterval LongInterval::operator -(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius;
  result.sub(center, x);
  result.radius += r;

  return result;
}

// LongInterval * LongFloat
LongInterval LongInterval::operator *(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius * Radius(x);
  result.mul(center, x);
  result.radius += r;

  return result;
}

// LongInterval / LongFloat
LongInterval LongInterval::operator /(const LongFloat &x) const{
  LongInterval result;

  if(x.significand[0] == 0){
    cerr << "[ERROR] LongInterval / LongFloat : Division by zero." << endl;
    exit(1);
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval a, b, invB, y;

  a = *this;
  b = x;
  invB.inverse(b);
  y = a * invB;

  // {Z̐xɖ߂B
  longSize -= 2;

  result = y;

  return result;
}

// LongInterval + LongInterval
LongInterval LongInterval::operator +(const LongInterval &x) const{
  LongInterval result;
  Radius r;

  r = radius + x.radius;
  result.add(center, x.center);
  result.radius += r;

  return result;
}

// LongInterval - LongInterval
LongInterval LongInterval::operator -(const LongInterval &x) const{
  LongInterval result;
  Radius r;

  r = radius + x.radius;
  result.sub(center, x.center);
  result.radius += r;

  return result;
}

// LongInterval * LongInterval
LongInterval LongInterval::operator *(const LongInterval &x) const{
  LongInterval result;
  LongFloat rr;

  // |this.center| >= this.radius  |x.center| >= x.radius ̂Ƃ
  if((center.compareAbs(LongFloat(radius)) >= 0)
    && (x.center.compareAbs(LongFloat(x.radius)) >= 0)){
    result.mul(center, x.center);
    result.center.sign = 1;

    rr.mul(radius, x.radius);
    result += rr;

    result.center.sign = center.sign * x.center.sign;

    result.radius += radius * Radius(x.center) + Radius(center) * x.radius;

    return result;
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval y;
  LongFloat c1, c2, r1, r2, c1r2, c2r1;

  c1 = center;
  c2 = x.center;

  c1.sign = 1;
  c2.sign = 1;

  r1 = LongFloat(radius);
  r2 = LongFloat(x.radius);

  c1r2.mul(c1, r2);
  c2r1.mul(c2, r1);

  y.mul(c1, c2);
  y.radius += radius * x.radius;

  // |c1r2| >= |c2r1| ̂Ƃ
  if(c1r2.compareAbs(c2r1) >= 0){
    y += c2r1;
    y.radius += Radius(c1r2);
  }

  // |c1r2| < |c2r1| ̂Ƃ
  else{
    y += c1r2;
    y.radius += Radius(c2r1);
  }

  // {Z̐xɖ߂B
  longSize -= 2;

  result = y;
  result.center.sign = center.sign * x.center.sign;

  return result;
}

// LongInterval / LongInterval
LongInterval LongInterval::operator /(const LongInterval &x) const{
  LongInterval result;

  if(x.center.compareAbs(x.rad()) <= 0){
    cerr << "[ERROR] LongInterval / LongInterval : Division by zero." << endl;
    exit(1);
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval a, b, invB, y;

  a = *this;
  b = x;
  invB.inverse(b);
  y = a * invB;

  // {Z̐xɖ߂B
  longSize -= 2;

  result = y;

  return result;
}

// LongInterval + LongMatrix
LongIntervalMatrix LongInterval::operator +(const LongMatrix &x) const{
  return x + *this;
}

// LongInterval - LongMatrix
LongIntervalMatrix LongInterval::operator -(const LongMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongInterval * LongMatrix
LongIntervalMatrix LongInterval::operator *(const LongMatrix &x) const{
  return x * *this;
}

// LongInterval / LongMatrix
LongIntervalMatrix LongInterval::operator /(const LongMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// LongInterval + LongIntervalMatrix
LongIntervalMatrix LongInterval::operator +(const LongIntervalMatrix &x) const{
  return x + *this;
}

// LongInterval - LongIntervalMatrix
LongIntervalMatrix LongInterval::operator -(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongInterval * LongIntervalMatrix
LongIntervalMatrix LongInterval::operator *(const LongIntervalMatrix &x) const{
  return x * *this;
}

// LongInterval / LongIntervalMatrix
LongIntervalMatrix LongInterval::operator /(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// rZ
////////////////////////////////////////////////////////////////////////////////

// LongInterval < int
int LongInterval::operator <(int x) const{
  return *this < LongFloat(x);
}

// LongInterval > int
int LongInterval::operator >(int x) const{
  return *this > LongFloat(x);
}

// LongInterval <= int
int LongInterval::operator <=(int x) const{
  return *this <= LongFloat(x);
}

// LongInterval >= int
int LongInterval::operator >=(int x) const{
  return *this >= LongFloat(x);
}

// LongInterval < LongFloat
int LongInterval::operator <(const LongFloat &x) const{
  if(sup() < x){
    return 1;
  }

  if(supIn() >= x){
    return 0;
  }

  return -1;
}

// LongInterval > LongFloat
int LongInterval::operator >(const LongFloat &x) const{
  if(inf() > x){
    return 1;
  }

  if(infIn() <= x){
    return 0;
  }

  return -1;
}

// LongInterval <= LongFloat
int LongInterval::operator <=(const LongFloat &x) const{
  if(sup() <= x){
    return 1;
  }

  if(supIn() > x){
    return 0;
  }

  return -1;
}

// LongInterval >= LongFloat
int LongInterval::operator >=(const LongFloat &x) const{
  if(inf() >= x){
    return 1;
  }

  if(infIn() < x){
    return 0;
  }

  return -1;
}

// LongInterval == LongInterval
bool LongInterval::operator ==(const LongInterval &x) const{
  if(radius != x.radius){
    return false;
  }

  if(center != x.center){
    return false;
  }

  return true;
}

// LongInterval != LongInterval
bool LongInterval::operator !=(const LongInterval &x) const{
  return !(*this == x);
}

// LongInterval < LongInterval
int LongInterval::operator <(const LongInterval &x) const{
  if(sup() < x.inf()){
    return 1;
  }

  if(supIn() >= x.infIn()){
    return 0;
  }

  return -1;
}

// LongInterval > LongInterval
int LongInterval::operator >(const LongInterval &x) const{
  if(inf() > x.sup()){
    return 1;
  }

  if(infIn() <= x.supIn()){
    return 0;
  }

  return -1;
}

// LongInterval <= LongInterval
int LongInterval::operator <=(const LongInterval &x) const{
  if(sup() <= x.inf()){
    return 1;
  }

  if(supIn() > x.infIn()){
    return 0;
  }

  return -1;
}

// LongInterval >= LongInterval
int LongInterval::operator >=(const LongInterval &x) const{
  if(inf() >= x.sup()){
    return 1;
  }

  if(infIn() < x.supIn()){
    return 0;
  }

  return -1;
}

// Z
////////////////////////////////////////////////////////////////////////////////

// LongInterval = int
LongInterval &LongInterval::operator =(int x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;

  return *this;
}

// LongInterval += int
LongInterval &LongInterval::operator +=(int x){
  Radius r;

  r = radius;
  add(center, LongFloat(x));
  radius += r;

  return *this;
}

// LongInterval -= int
LongInterval &LongInterval::operator -=(int x){
  Radius r;

  r = radius;
  sub(center, LongFloat(x));
  radius += r;

  return *this;
}

// LongInterval *= int
LongInterval &LongInterval::operator *=(int x){
  Radius r;

  r = radius * x;
  mul(center, x);
  radius += r;

  return *this;
}

// LongInterval /= int
LongInterval &LongInterval::operator /=(int x){
  Radius r;

  if(x == 0){
    cerr << "[ERROR] LongInterval /= int : Division by zero." << endl;
    exit(1);
  }

  r = radius / x;
  div(center, x);
  radius += r;

  return *this;
}

// LongInterval = LongFloat
LongInterval &LongInterval::operator =(const LongFloat &x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;

  return *this;
}

// LongInterval += LongFloat
LongInterval &LongInterval::operator +=(const LongFloat &x){
  Radius r;

  r = radius;
  add(center, x);
  radius += r;

  return *this;
}

// LongInterval -= LongFloat
LongInterval &LongInterval::operator -=(const LongFloat &x){
  Radius r;

  r = radius;
  sub(center, x);
  radius += r;

  return *this;
}

// LongInterval *= LongFloat
LongInterval &LongInterval::operator *=(const LongFloat &x){
  Radius r;

  r = radius * Radius(x);
  mul(center, x);
  radius += r;

  return *this;
}

// LongInterval /= LongFloat
LongInterval &LongInterval::operator /=(const LongFloat &x){
  if(x.significand[0] == 0){
    cerr << "[ERROR] LongInterval /= LongFloat : Division by zero." << endl;
    exit(1);
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval a, b, invB, y;

  a = *this;
  b = x;
  invB.inverse(b);
  y = a * invB;

  // {Z̐xɖ߂B
  longSize -= 2;

  *this = y;

  return *this;
}

// LongInterval = LongInterval
LongInterval &LongInterval::operator =(const LongInterval &x){
  int i;

  center.sign = x.center.sign;
  center.exponent = x.center.exponent;
  radius = x.radius;

  if(center.size >= x.center.size){
    for(i = 0; i < x.center.size; i++){
      center.significand[i] = x.center.significand[i];
    }
    for(i = x.center.size; i < center.size; i++){
      center.significand[i] = 0;
    }
  }
  else{
    for(i = 0; i < center.size; i++){
      center.significand[i] = x.center.significand[i];
    }

    // ؂̂Ă鉼덷Ɏ荞ށB
    for(i = x.center.size - 1; i >= center.size; i--){
      radius += Radius(x.center.significand[i], LIMB_BITS * (x.center.exponent - i));
    }
  }

  return *this;
}

// LongInterval += LongInterval
LongInterval &LongInterval::operator +=(const LongInterval &x){
  Radius r;

  r = radius + x.radius;
  add(center, x.center);
  radius += r;

  return *this;
}

// LongInterval -= LongInterval
LongInterval &LongInterval::operator -=(const LongInterval &x){
  Radius r;

  r = radius + x.radius;
  sub(center, x.center);
  radius += r;

  return *this;
}

// LongInterval *= LongInterval
LongInterval &LongInterval::operator *=(const LongInterval &x){
  LongFloat rr;
  Radius r;
  int s;

  // |this.center| >= this.radius  |x.center| >= x.radius ̂Ƃ
  if((center.compareAbs(LongFloat(radius)) >= 0)
    && (x.center.compareAbs(LongFloat(x.radius)) >= 0)){
    rr.mul(radius, x.radius);
    r = radius * Radius(x.center) + Radius(center) * x.radius;

    s = center.sign * x.center.sign;
    mul(center, x.center);
    center.sign = 1;

    *this += rr;

    center.sign = s;

    radius += r;

    return *this;
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval y;
  LongFloat c1, c2, r1, r2, c1r2, c2r1;

  c1 = center;
  c2 = x.center;

  c1.sign = 1;
  c2.sign = 1;

  r1 = LongFloat(radius);
  r2 = LongFloat(x.radius);

  c1r2.mul(c1, r2);
  c2r1.mul(c2, r1);

  y.mul(c1, c2);
  y.radius += radius * x.radius;

  // |c1r2| >= |c2r1| ̂Ƃ
  if(c1r2.compareAbs(c2r1) >= 0){
    y += c2r1;
    y.radius += Radius(c1r2);
  }

  // |c1r2| < |c2r1| ̂Ƃ
  else{
    y += c1r2;
    y.radius += Radius(c2r1);
  }

  // {Z̐xɖ߂B
  longSize -= 2;

  y.center.sign = center.sign * x.center.sign;
  *this = y;

  return *this;
}

// LongInterval /= LongInterval
LongInterval &LongInterval::operator /=(const LongInterval &x){
  if(x.center.compareAbs(x.rad()) <= 0){
    cerr << "[ERROR] LongInterval /= LongInterval : Division by zero." << endl;
    exit(1);
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval a, b, invB, y;

  a = *this;
  b = x;
  invB.inverse(b);
  y = a * invB;

  // {Z̐xɖ߂B
  longSize -= 2;

  *this = y;

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int + LongInterval
LongInterval operator +(int a, const LongInterval &b){
  return b + LongFloat(a);
}

// int - LongInterval
LongInterval operator -(int a, const LongInterval &b){
  return LongFloat(a) - b;
}

// int * LongInterval
LongInterval operator *(int a, const LongInterval &b){
  return b * a;
}

// int / LongInterval
LongInterval operator /(int a, const LongInterval &b){
  LongInterval result;

  if(b.center.compareAbs(b.rad()) <= 0){
    cerr << "[ERROR] int / LongInterval : Division by zero." << endl;
    exit(1);
  }

  // ꎞIɑ{Z̐xグB
  longSize += 2;
  LongInterval b2, invB2, y;

  b2 = b;
  invB2.inverse(b2);
  y = a * invB2;

  // {Z̐xɖ߂B
  longSize -= 2;

  result = y;

  return result;
}

// rZith֐j
////////////////////////////////////////////////////////////////////////////////

// int < LongInterval
int operator <(int a, const LongInterval &b){
  return LongFloat(a) < b;
}

// int > LongInterval
int operator >(int a, const LongInterval &b){
  return LongFloat(a) > b;
}

// int <= LongInterval
int operator <=(int a, const LongInterval &b){
  return LongFloat(a) <= b;
}

// int >= LongInterval
int operator >=(int a, const LongInterval &b){
  return LongFloat(a) >= b;
}

////////////////////////////////////////////////////////////////////////////////

// ׂ
LongInterval pow(const LongInterval &x, int n){
  LongInterval y, a;
  bool positive;

  if(n == 0){
    return 1;
  }

  if(n > 0){
    positive = true;
  }
  else{
    n = -n;
    positive = false;
  }

  n--;
  a = x;
  y = a;

  while(n > 0){
    if(n % 2){
      y *= a;
    }

    n /= 2;
    if(n){
      a *= a;
    }
  }

  if(positive){
    return y;
  }
  else{
    return 1 / y;
  }
}

// 
LongInterval sqrt(const LongInterval &x){
  LongInterval y;
  LongFloat a, b;

  if(x.center.compareAbs(x.rad()) < 0){
    cerr << "[ERROR] sqrt(LongInterval) : Complex number." << endl;
    exit(1);
  }

  // 0 ̏ꍇ
  if(x.center.significand[0] == 0){
    return 0;
  }

  y = sqrt(x.center);

  a = LongFloat(x.radius);
  b = x.center.sqrtFast() + x.inf().sqrtFast();

  // y.radius = a / b ւ̊ۂ߂ŌvZB
  y.radius.div(a, b);

  // Sľ덷B
  y.radius += Radius(1, LIMB_BITS * (y.center.exponent - longSize + 1));

  return y;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << Interval
ostream &operator <<(ostream &output, const LongInterval &x){
  output << x.getMidRad();

  return output;
}
