/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@GwtCompatible
public class MultimapValuesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testValues() {
        ArrayList expected = Lists.newArrayList();
        for (Map.Entry entry : this.getSampleElements()) {
            expected.add(entry.getValue());
        }
        Truth.assertThat((Collection)this.multimap().values()).has().exactlyAs((Collection)expected);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testValuesInOrder() {
        ArrayList expected = Lists.newArrayList();
        for (Map.Entry entry : this.getOrderedElements()) {
            expected.add(entry.getValue());
        }
        Truth.assertThat((Collection)this.multimap().values()).has().exactlyAs((Collection)expected).inOrder();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testValuesIteratorRemove() {
        Iterator valuesItr = this.multimap().values().iterator();
        valuesItr.next();
        valuesItr.remove();
        MultimapValuesTester.assertTrue((boolean)this.multimap().isEmpty());
    }
}

