/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MinimalSet;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.ArrayList;
import java.util.Collection;

@GwtCompatible
public class ListEqualsTester<E>
extends AbstractListTester<E> {
    public void testEquals_otherListWithSameElements() {
        ListEqualsTester.assertTrue((String)"A List should equal any other List containing the same elements.", (boolean)this.getList().equals(new ArrayList(this.getOrderedElements())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherListWithDifferentElements() {
        ArrayList other = new ArrayList(this.getSampleElements());
        other.set(other.size() / 2, ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).samples().e3);
        ListEqualsTester.assertFalse((String)"A List should not equal another List containing different elements.", (boolean)this.getList().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherListContainingNull() {
        ArrayList other = new ArrayList(this.getSampleElements());
        other.set(other.size() / 2, null);
        ListEqualsTester.assertFalse((String)"Two Lists should not be equal if exactly one of them has null at a given index.", (boolean)this.getList().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testEquals_containingNull() {
        ArrayList elements = new ArrayList(this.getSampleElements());
        elements.set(elements.size() / 2, null);
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements.toArray());
        ArrayList other = new ArrayList(this.getSampleElements());
        ListEqualsTester.assertFalse((String)"Two Lists should not be equal if exactly one of them has null at a given index.", (boolean)this.getList().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_shorterList() {
        Collection fewerElements = this.getSampleElements(this.getNumElements() - 1);
        ListEqualsTester.assertFalse((String)"Lists of different sizes should not be equal.", (boolean)this.getList().equals(new ArrayList(fewerElements)));
    }

    public void testEquals_longerList() {
        Collection moreElements = this.getSampleElements(this.getNumElements() + 1);
        ListEqualsTester.assertFalse((String)"Lists of different sizes should not be equal.", (boolean)this.getList().equals(new ArrayList(moreElements)));
    }

    public void testEquals_set() {
        ListEqualsTester.assertFalse((String)"A List should never equal a Set.", (boolean)this.getList().equals(MinimalSet.from(this.getList())));
    }
}

