/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#include "avifmt.h"
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* ե졼ؿ(ߤ)                                                        *
*                                                                             *
******************************************************************************/
/*	DIBŸ줿ե졼򳫤
	avi_edit,AVIԽϥɥ
	     RET,AVIե졼๽¤,NULL:顼									*/
AviFrame *avi_get_frame_open(AviEdit *avi_edit)
{
	AviFrame *avi_frame;

	if (avi_edit==NULL || avi_type(avi_edit)!=streamtypeVIDEO)
		return NULL;
	avi_frame=g_malloc(sizeof(AviFrame));
	avi_frame->handler=0;
	avi_frame->pos=-1;
	avi_frame->avi_edit=avi_edit;
	avi_frame->icm_object=NULL;
	return avi_frame;
}


/*	DIBŸ줿ե졼Ĥ
	avi_frame,AVIե졼๽¤
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_get_frame_close(AviFrame *avi_frame)
{
	if (avi_frame==NULL)
		return FALSE;
	if (avi_frame->icm_object!=NULL) {
		icm_decompress_end(avi_frame->icm_object);
		icm_close(avi_frame->icm_object);
	}
	g_free(avi_frame);
	return TRUE;
}


/*	DIBŸ줿ե졼
	 avi_edit,AVIԽϥɥ
	      pos,ե졼(ץֹ)
	      RET,ѥåDIBؤΥݥ,NULL:顼								*/
static BitmapInfoHeader *avi_get_frame_real(AviFrame *avi_frame,const gint pos)
{
	gpointer input=NULL,output;
	gint i,j,size;
	AviEdit *avi_edit;
	BitmapInfoHeader *bmih;

	avi_edit=avi_frame->avi_edit;
	if (pos<0 || avi_length(avi_edit)<=pos)
		return NULL;				/* ϰϳ */
	avi_get_file(avi_edit,pos);		/* AVIե */
	if (avi_edit->file->handler==comptypeDIB) {
		/* ̥ե졼Υå */
		for (i=pos-avi_edit->offset+avi_edit->file->start;i>0;i--)
			if (avi_edit->file->index[i].size>0)
				break;
		/* ᡼ΥǡΥȤ顼 */
		if (bm_image_bytes(avi_edit->file->bmih)>avi_edit->file->index[i].size)
			return NULL;
		size=bm_header_bytes(avi_edit->file->bmih);
		bmih=g_malloc(size+avi_edit->file->index[i].size);
		/* إå */
		g_memmove(bmih,avi_edit->file->bmih,size);
		if (bmih_get_compression(bmih)==comptypeDIB)
			bmih_set_compression(bmih,BI_RGB);
		if (bmih_get_size_image(bmih)<=0)
			bmih_set_size_image(bmih,bm_image_bytes(bmih));
		/* ᡼ */
		if (avi_edit->file->data==NULL) {
			/* ե */
			lseek(avi_edit->file->fd,avi_edit->file->index[i].offset,SEEK_SET);
			read(avi_edit->file->fd,(guint8 *)bmih+size,
												avi_edit->file->index[i].size);
		} else {
			/*  */
			g_memmove((guint8 *)bmih+size,
				(guint8 *)avi_edit->file->data+avi_edit->file->index[i].offset,
												avi_edit->file->index[i].size);
		}
	} else {
		if (avi_edit->file->handler!=avi_frame->handler) {
			/* ̤ۤʤȤ */
			if (avi_frame->icm_object!=NULL) {
				icm_decompress_end(avi_frame->icm_object);
				icm_close(avi_frame->icm_object);
			}
			avi_frame->handler=avi_edit->file->handler;
			avi_frame->pos=-1;
			if ((avi_frame->icm_object=icm_open(avi_frame->handler,
												ICM_MODE_DECOMPRESS))==NULL) {
				avi_frame->handler=0;
				return NULL;
			}
			if (!icm_decompress_begin(avi_frame->icm_object,
													avi_edit->file->bmih)) {
				icm_close(avi_frame->icm_object);
				avi_frame->handler=0;
				avi_frame->icm_object=NULL;
				return NULL;
			}
		}

		/* 󥭡ե졼Υå */
		i=j=pos-avi_edit->offset+avi_edit->file->start;
		if (avi_frame->pos!=pos-1 || pos<=avi_edit->offset)
			while (j>0) {	/* Ϣ³ƤʤȤ */
				if ((avi_edit->file->index[j].flags&AVIIF_KEYFRAME)!=0
											&& avi_edit->file->index[j].size>0)
					break;
				j--;
			}
		bmih=g_malloc(icm_decompress_get_format_size(avi_frame->icm_object,
														avi_edit->file->bmih));
		if (!icm_decompress_get_format(avi_frame->icm_object,
												avi_edit->file->bmih,bmih)) {
			g_free(bmih);
			return NULL;
		}
		bmih=g_realloc(bmih,bm_all_bytes(bmih));
		output=(guint8 *)bmih+bm_header_bytes(bmih);
		while (j<=i) {
			if (avi_edit->file->index[j].size>0) {
				/* ᡼ */
				input=g_realloc(input,avi_edit->file->index[j].size);
				if (avi_edit->file->data==NULL) {
					/* ե */
					lseek(avi_edit->file->fd,
									avi_edit->file->index[j].offset,SEEK_SET);
					read(avi_edit->file->fd,input,
												avi_edit->file->index[j].size);
				} else {
					/*  */
					g_memmove(input,(guint8 *)avi_edit->file->data
											+avi_edit->file->index[j].offset,
												avi_edit->file->index[j].size);
				}
				icm_decompress(avi_frame->icm_object,
							(avi_edit->file->index[j].flags&AVIIF_KEYFRAME)==0
												?ICM_DECOMPRESS_NOTKEYFRAME:0,
																input,output);
			}
			j++;
		}
		g_free(input);
	}
	return bmih;
}


/*	DIBŸ줿ե졼
	avi_frame,AVIե졼๽¤
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	bit_count,
	      RET,ѥåDIBؤΥݥ,NULL:顼								*/
BitmapInfoHeader *avi_get_frame(AviFrame *avi_frame,const gint pos,
					const gint width,const gint height,const gint bit_count)
{
	gint i,n;
	AviBuffer avi_buf;
	AviEdit *avi_edit;
	BitmapInfoHeader *bmih0,*bmih1;

	if (avi_frame==NULL)
		return NULL;
	avi_edit=avi_frame->avi_edit;
	/* ̥ե졼Υå */
	avi_get_file(avi_edit,pos);		/* AVIե */
	for (n=pos-avi_edit->offset+avi_edit->file->start;n>0;n--)
		if (avi_edit->file->index[n].size>0)
			break;
	n+=avi_edit->offset-avi_edit->file->start;
	/* Хåեå */
	for (i=0;i<AVI_EDIT_CACHE && avi_edit->buf[i].data!=NULL;i++)
		if ((avi_edit->buf[i].pos==n || avi_edit->buf[i].pos==pos)
					&& !avi_edit->buf[i].raw
					&& bmih_get_width(avi_edit->buf[i].data)==width
					&& bmih_get_height(avi_edit->buf[i].data)==height
					&& bmih_get_bit_count(avi_edit->buf[i].data)==bit_count) {
			/* åƱΤȤ */
			avi_buf=avi_edit->buf[i];
			g_memmove(avi_edit->buf+1,avi_edit->buf,i*sizeof(AviBuffer));
			avi_edit->buf[0]=avi_buf;
			return avi_buf.data;
		}

	/* Ÿ줿Υե졼 */
	if ((bmih0=avi_get_frame_real(avi_frame,pos))==NULL)
		return NULL;

	if (bmih_get_width(bmih0)!=width || bmih_get_height(bmih0)!=height
					|| bmih_get_bit_count(bmih0)!=bit_count || bit_count<16) {
		/* 32ӥåȤѴ */
		if (bmih_get_bit_count(bmih0)!=32) {
			bmih1=g_malloc(bx_all_bytes(bmih_get_width(bmih0),
										bmih_get_height(bmih0),32,BI_RGB,0));
			bitmap_convert_32(bmih0,bmih1);
			g_free(bmih0);
			bmih0=bmih1;
		}
		/* Ѵ */
		if (bmih_get_width(bmih0)!=width || bmih_get_height(bmih0)!=height) {
			bmih1=g_malloc(bx_all_bytes(width,height,32,BI_RGB,0));
			bmih_set_width(bmih1,width);
			bmih_set_height(bmih1,height);
			bitmap_zoom_32(bmih0,bmih1);
			g_free(bmih0);
			bmih0=bmih1;
		}
		/* Ѵ */
		if (bit_count!=32) {
			bmih1=g_malloc(bx_all_bytes(width,height,bit_count,BI_RGB,0));
			bmih_set_color_used(bmih1,0);
			bmih_set_color_important(bmih1,0);
			switch (bit_count) {
				case 1:
					g_memmove((guint8 *)bmih1+BMIH_SIZE,rgb2,RGBQUAD_SIZE*2);
					bitmap_diffuse_1(bmih0,bmih1);
					break;
				case 4:
					g_memmove((guint8 *)bmih1+BMIH_SIZE,rgb16,RGBQUAD_SIZE*16);
					bitmap_diffuse_4(bmih0,bmih1);
					break;
				case 8:
					g_memmove((guint8 *)bmih1+BMIH_SIZE,rgb256,
															RGBQUAD_SIZE*256);
					bitmap_diffuse_8(bmih0,bmih1);
					break;
				case 16:
					bitmap_convert_16(bmih0,bmih1);
					break;
				case 24:
					bitmap_convert_24(bmih0,bmih1);
			}
			g_free(bmih0);
			bmih0=bmih1;
		}
	}
	g_free(avi_edit->buf[AVI_EDIT_CACHE-1].data);
	g_memmove(avi_edit->buf+1,avi_edit->buf,
										(AVI_EDIT_CACHE-1)*sizeof(AviBuffer));
	avi_edit->buf[0].data=bmih0;
	avi_edit->buf[0].raw=FALSE;
	avi_edit->buf[0].pos=pos;
	return bmih0;
}


/*	RAWŸ줿ե졼
	avi_frame,AVIե졼๽¤
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	      RET,RAWؤΥݥ,NULL:顼								*/
guchar *avi_get_frame32(AviFrame *avi_frame,const gint pos,
											const gint width,const gint height)
{
	gint i,n,xx,yy,src,dst;
	guchar *p;
	guint8 *q;
	AviBuffer avi_buf;
	AviEdit *avi_edit;
	BitmapInfoHeader *bmih;

	if (avi_frame==NULL)
		return NULL;
	avi_edit=avi_frame->avi_edit;
	/* ̥ե졼Υå */
	avi_get_file(avi_edit,pos);		/* AVIե */
	for (n=pos-avi_edit->offset+avi_edit->file->start;n>0;n--)
		if (avi_edit->file->index[n].size>0)
			break;
	n+=avi_edit->offset-avi_edit->file->start;
	/* Хåեå */
	for (i=0;i<AVI_EDIT_CACHE && avi_edit->buf[i].data!=NULL;i++)
		if ((avi_edit->buf[i].pos==n || avi_edit->buf[i].pos==pos)
										&& avi_edit->buf[i].raw
										&& avi_edit->buf[i].width==width
										&& avi_edit->buf[i].height==height) {
			/* åƱΤȤ */
			avi_buf=avi_edit->buf[i];
			g_memmove(avi_edit->buf+1,avi_edit->buf,i*sizeof(AviBuffer));
			avi_edit->buf[0]=avi_buf;
			return avi_buf.data;
		}
	if ((bmih=avi_get_frame(avi_frame,pos,width,height,32))==NULL)
		return NULL;
	p=g_malloc(width*height*4*sizeof(guchar));
	q=(guchar *)bmih+bm_header_bytes(bmih);
	for (yy=0;yy<height;yy++)
		for (xx=0;xx<width;xx++) {
			src=xx*4+(height-yy-1)*width*4;
			dst=xx*4+yy*width*4;
			p[dst]  =q[src+2];
			p[dst+1]=q[src+1];
			p[dst+2]=q[src];
			p[dst+3]=q[src+3];
		}
	g_free(avi_edit->buf[0].data);
	avi_edit->buf[0].data=p;
	avi_edit->buf[0].raw=TRUE;
	avi_edit->buf[0].width=width;
	avi_edit->buf[0].height=height;
	return p;
}


/*	ե졼बե졼फȽꤹ
	avi_edit,AVIԽϥɥ
	     pos,ե졼(ץֹ)
	     RET,TRUE:ե졼,FALSE:󥭡ե졼							*/
gboolean avi_is_keyframe(AviEdit *avi_edit,const gint pos)
{
	if (avi_edit!=NULL && avi_type(avi_edit)==streamtypeVIDEO) {
		/* ӥǥ */
		avi_get_file(avi_edit,pos);/* AVIե */
		return (avi_edit->file->index
							[pos-avi_edit->offset+avi_edit->file->start].flags
														&AVIIF_KEYFRAME)!=0;
	}
	return TRUE;
}
