/*
   codec client 
    copyright (c) 2003 midori(midori@tan-moe.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* codec client code(nina)
*                                                                             *
******************************************************************************/

#include <gmodule.h>
#include <glib.h>
#include "common.h"

#include "icm.h"
#include "codec_c.h"

/* #define DEBUG */

static LONG WINAPI codecDriverProc(DWORD dwDriverId, HANDLE hdrvr,
    UINT msg, LONG lParam1, LONG lParam2);
static gboolean dummy_load(PE_image *pe, const gchar *file,
    const gboolean flags);
/* static gpointer dummy_resolve(PE_image *pe, const gchar *name); */
static gpointer codec_resolve(PE_image *pe, const gchar *name);
static void codec_destroy(PE_image *);



/*
 * codec ɤ߹ǡPE ¤Τꡣ
 */
PE_image *codec_load(gchar *file)
{
	GModule *module=NULL;
	PE_image *pe=NULL;

	if (g_module_supported() != TRUE)
		return NULL;

	/* if ((module = dlopen(file, DL_OPTION)) == NULL) */
	if ((module = g_module_open(file, 1)) == NULL)
		return NULL;

	pe = g_malloc0(sizeof(PE_image));
	pe->load = dummy_load;
	pe->resolve = codec_resolve;
	pe->destroy = codec_destroy;

	pe->module  = module;
	pe->file=g_strdup(file);

	return pe;
}


/*
 * codec ΤΥɥ쥹֤
 */
gpointer codec_get_driverproc(PE_image *pe)
{
	return (gpointer)codecDriverProc;
}


/*
 * codec ƤӽФΡ
 */
static LONG WINAPI codecDriverProc(DWORD dwDriverId,HANDLE hdrvr,
    UINT msg, LONG lParam1, LONG lParam2)
{
	gint (*codec_func)(UINT,LONG,LONG); 
	PE_image *pe=(PE_image *)hdrvr;

	if (pe == NULL)
		return ICERR_UNSUPPORTED;

	if ((codec_func = codec_resolve(pe, "codec_func")) == NULL)
		return ICERR_UNSUPPORTED;

	return codec_func(msg,lParam1,lParam2);
}


/*
 * PEȤΰ㤤碌뤿Υߡ
 */
static gboolean dummy_load(PE_image *pe, const gchar *file,
    const gboolean flags)
{
	/* dummy */
	return FALSE;
}


/*
 * ͭ饤֥δؿΥɥ쥹
 * ؿΥɥ쥹  ԡNULL
 */
static gpointer codec_resolve(PE_image *pe, const gchar *name)
{
	gboolean ret;
	gpointer symbol;

#if 0 /* UNDERSCORE is supported in glib */ /*defined(DLSYM_UNDERSCORE)*/
	gchar *namet;
	namet = g_strconcat("_", name, NULL);
	ret = dlsym(pe->module, namet, &symbol);
	g_free(namet);
	if(ret != TRUE)
		ret = dlsym(pe->module, name, &symbol);
#else
	ret = g_module_symbol(pe->module, name, &symbol);
#endif
	return (ret == TRUE) ? symbol : NULL;
}


/*
 * codecطι¤Τ˴
 */
static void codec_destroy(PE_image *pe)
{
	if (pe && pe->module){
		g_module_close(pe->module);
		g_free(pe->file);
        	g_free(pe->module);
	 	g_free(pe);
		pe = NULL;
	}
}
