/*
    avicore
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "icm.h"
#include "avifmt.h"
#include <gdk/gdkkeysyms.h>
#include "misc/misc.h"
#include "misc/profile.h"
#if defined(W32CODECDIR) || defined(USE_CODEC)
# include "codec_c.h"
#endif /* W32CODECDIR || USE_CODEC */
#ifdef HAVE_UNISTD_H
# include <unistd.h>  
#endif /* HAVE_UNISTD_H */


/******************************************************************************
*                                                                             *
* ICM                                                                 *
*                                                                             *
******************************************************************************/
/*	4ʸɢʸ
	handler,4ʸ
	    RET,ʸ															*/
/*static gchar *icm_handler_to_string(const guint handler)
{
	gchar c,*text=NULL,*temp0,*temp1;
	gint i;

	for (i=24;i>=0;i-=8) {
		c=(handler>>i)&0xff;
		temp0=g_strdup_printf(g_ascii_isalnum(c)?"%c":"%%%02x",(guint8)c);
		temp1=g_strconcat(temp0,text,NULL);
		g_free(temp0);
		g_free(text);
		text=temp1;
	}
	return text;
}*/


#if defined(W32CODECDIR) || defined(USE_CODEC)
/*	ʸ4ʸ
	text,ʸ
	 RET,4ʸ														*/
static guint32 icm_string_to_handler(const gchar *text)
{
	gint i,j=0,k;
	guint32 handler=0;

	for (i=0;i<4;i++) {
		handler>>=8;
		if (text[j]=='%') {
			j++;
			for (k=28;k>=24;k-=4) {
				if ('0'<=text[j] && text[j]<='9')
					handler|=(text[j]-'0')<<k;
				else if ('A'<=text[j] && text[j]<='A')
					handler|=(text[j]-'A')<<k;
				else if ('a'<=text[j] && text[j]<='f')
					handler|=(text[j]-'a')<<k;
				else
					break;
				j++;
			}
			if (k>=24)
				return 0;
		} else if (text[j]!='\0') {
			handler|=text[j++]<<24;
		} else {
			return 0;
		}
	}
	return handler;
}
#endif /* defined(W32CODECDIR) || defined(USE_CODEC) */


/******************************************************************************
*                                                                             *
* ICM                                                                   *
*                                                                             *
******************************************************************************/
static GHashTable *ghash_handler=NULL,*ghash_path=NULL;


#if defined(W32CODECDIR) || defined(USE_CODEC)
static void icm_init_callback(gpointer key,gpointer value,gpointer ghash)
{
	gchar *path;
	guint32 handler;
	IcmDriver *icm_driver;

	if (g_hash_table_lookup_extended((GHashTable*)ghash, key,
	    (gpointer *)&handler, (gpointer *)&path) == 0)
		return;
	if ((icm_driver = g_hash_table_lookup(ghash_path, path)) != NULL) {
		g_free(path);
		return;
	}
	/*  */
	if ((icm_driver = g_malloc0(sizeof(IcmDriver))) == NULL) {
		g_free(path);
		return;
	}
#if defined(W32CODECDIR)
	if (isPE(path)) {
		if (((icm_driver->pe = peimage_create()) != NULL)
		    && peimage_load(icm_driver->pe, path)
		    && (icm_driver->DriverProc = peimage_resolve(icm_driver->pe,
		    "DriverProc"))!=NULL) {
			icm_driver->DriverProc(0,icm_driver->pe, DRV_LOAD, 0, 0);
			icm_driver->DriverProc(0,icm_driver->pe, DRV_ENABLE, 0, 0);
			g_hash_table_insert(ghash_path, path, icm_driver);
			g_hash_table_insert(ghash_handler, (gpointer)handler, icm_driver);
			icm_driver->pe->codec_type = ICM_ATTR_WIN32;
			return;
		}
	} else
#endif /* defined(W32CODECDIR) */
#if defined(USE_CODEC)
	if ((icm_driver->pe = codec_load(path)) != NULL) {
		if ((icm_driver->DriverProc = codec_get_driverproc(icm_driver->pe)) == NULL){
      		g_message("icm.c : %s : load failed.codec_get_driverproc", __FUNCTION__);
			return;
		}
      		g_message("icm.c : %s : load success.", __FUNCTION__);
		icm_driver->DriverProc(0, icm_driver->pe, DRV_LOAD, 0, 0);
		icm_driver->DriverProc(0, icm_driver->pe, DRV_ENABLE, 0, 0);
		g_hash_table_insert(ghash_path, path, icm_driver);
		g_hash_table_insert(ghash_handler, (gpointer)handler, icm_driver);
		icm_driver->pe->codec_type = ICM_ATTR_NATIVE;
		return;
	} else
#endif /*defined(USE_CODEC) */
	{
      		g_message("icm.c : %s : load failed.", __FUNCTION__);
		/*dummy*/
	}
	/* falldown,if fail */
	if(icm_driver!=NULL){
		if(icm_driver->pe!=NULL)
			peimage_destroy(icm_driver->pe);
		g_free(icm_driver);
		icm_driver=NULL;
	}
	g_free(path);
}
#endif


/*	ICM
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_init(void)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	gchar *key,*value,*path,*fpath;
	gint i,length;
	guint32 handler;
	GList *glist;
	GHashTable *ghash;
	Profile *profile;

	if (ghash_handler!=NULL || ghash_path!=NULL)
		return FALSE;
	ghash=g_hash_table_new(NULL,g_direct_equal);
	/*  */
	if ((profile=profile_open(NULL))!=NULL) {
		if ((glist=profile_enum_key(profile,"vidc"))!=NULL) {
			length=g_list_length(glist);
			for (i=0;i<length;i++) {
				key=g_list_nth_data(glist,i);
				if ((handler=icm_string_to_handler(key))!=0
					&& (value=profile_get_string(profile,"vidc",key))!=NULL) {

					if (value[0]=='\0' || value[g_strlen(value)-1]=='/') {
						if ((path = g_hash_table_lookup(ghash, (gconstpointer)handler)))
							g_free(path);
						g_free(value);
					} else {
						if (g_path_is_absolute(value))
							path=value;
						else {
				//XXX: TODO:NATIVECODECDIRȤ褦ѹ
#if defined(USE_CODEC)
							path = g_strconcat("/home/codec", "/", value, NULL);
							if (access(path, F_OK) != 0) {
								g_free(path);
#endif /* defined(USE_CODEC) */
#if defined(W32CODECDIR)
								path = g_strconcat(W32CODECDIR, "/", value, NULL);
								if (access(path, F_OK) != 0) {
									g_free(path);
#endif /* defined(W32CODECDIR) */
									g_free(value);
									continue;
#if defined(W32CODECDIR)
								}
#endif /* defined(W32CODECDIR) */
#if defined(USE_CODEC)
							}
#endif /* defined(USE_CODEC) */
							g_free(value);
						}
						fpath = misc_get_full_path(path);
						g_free(path);
						if ((path = g_hash_table_lookup(ghash, (gconstpointer)handler)))
							g_free(path);
						g_hash_table_insert(ghash, (gpointer)handler, fpath);
					}
				}
			}
			g_list_free(glist);
		}
		profile_close(profile);
	}
	ghash_handler=g_hash_table_new(NULL,g_direct_equal);
	ghash_path=g_hash_table_new(g_str_hash,g_str_equal);
	g_hash_table_foreach(ghash,icm_init_callback,ghash);
	g_hash_table_destroy(ghash);
#endif
	return TRUE;
}


static void icm_exit_callback(gpointer key,gpointer value,gpointer ghash)
{
	gchar *path;
	IcmDriver *icm_driver;

	if (g_hash_table_lookup_extended((GHashTable*)ghash,key,
								(gpointer *)&path,(gpointer *)&icm_driver)) {
#if defined(W32CODECDIR) || defined(USE_CODEC)
		icm_driver->DriverProc(0,icm_driver->pe,DRV_FREE,0,0);
		peimage_destroy(icm_driver->pe);
#endif
		g_free(icm_driver);
		g_free(path);
	}
}


/*	ICMλ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_exit(void)
{
	if (ghash_handler!=NULL || ghash_path!=NULL) {
		g_hash_table_foreach(ghash_path,icm_exit_callback,ghash_path);
		g_hash_table_destroy(ghash_handler);
		g_hash_table_destroy(ghash_path);
		ghash_handler=NULL;
		ghash_path=NULL;
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ICM                                                                     *
*                                                                             *
******************************************************************************/
static void icm_get_handler_list_callback(gpointer key,gpointer value,
																GList **glist)
{
	*glist=g_list_append(*glist,key);
}


/*	ϿƤ4ʸɤ
	RET,4ʸɤΥꥹ,NULL:Ͽʤ									*/
GList *icm_get_handler_list(void)
{
	GList *glist=NULL;

	if (ghash_handler!=NULL)
		g_hash_table_foreach(ghash_handler,
								(GHFunc)icm_get_handler_list_callback,&glist);
	return glist;
}


/*	Codec򳫤
	handler,4ʸ
	   mode,⡼
	    RET,IcmObject,NULL:顼											*/
IcmObject *icm_open(const guint32 handler,const gint mode)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	IcmObject *icm_object;
	ICOPEN icopen;

	icm_object=g_malloc0(sizeof(IcmObject));
	icm_object->counter=1;
	icm_object->handler=handler;
	icm_object->mode=mode;
	if ((icm_object->icm_driver = g_hash_table_lookup (ghash_handler,
											(gconstpointer)handler)) != NULL)
	  {
		g_memset(&icopen,0,sizeof(ICOPEN));
		icopen.dwSize=sizeof(ICOPEN);
		icopen.fccType=ICTYPE_VIDEO;
		icopen.fccHandler=handler;
		switch (mode) {
			case ICM_MODE_COMPRESS:
				icopen.dwFlags=ICMODE_COMPRESS;
				break;
			case ICM_MODE_DECOMPRESS:
				icopen.dwFlags=ICMODE_DECOMPRESS;
				break;
			case ICM_MODE_FASTDECOMPRESS:
				icopen.dwFlags=ICMODE_FASTDECOMPRESS;
				break;
			case ICM_MODE_QUERY:
				icopen.dwFlags=ICMODE_QUERY;
				break;
			case ICM_MODE_FASTCOMPRESS:
				icopen.dwFlags=ICMODE_FASTCOMPRESS;
				break;
			case ICM_MODE_DRAW:
				icopen.dwFlags=ICMODE_DRAW;
		}
		icm_object->dwDriverId=icm_object->icm_driver->DriverProc(1,
						icm_object->icm_driver->pe,DRV_OPEN,0,(LONG)&icopen);
	  }
	if (icm_object->dwDriverId==0) {
		g_free(icm_object);
		icm_object=NULL;
	}
	return icm_object;
#else
	return NULL;
#endif
}


/*	CodecĤ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_close(IcmObject *icm_object)
{
	if (icm_object!=NULL && --(icm_object->counter)<=0) {
#if defined(W32CODECDIR) || defined(USE_CODEC)
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,DRV_CLOSE,0,0);
#endif
		g_free(icm_object->bmih_in);
		g_free(icm_object->bmih_out);
		g_free(icm_object->prev);
		g_free(icm_object);
	}
	return TRUE;
}


/*	Codecξ
	icm_object,IcmObject
	  icm_info,
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_get_info(IcmObject *icm_object,IcmInfo *icm_info)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	ICINFO icinfo;

	if (icm_object==NULL)
		return FALSE;
	g_memset(&icinfo,0,sizeof(ICINFO));
	icinfo.dwSize=sizeof(ICINFO);
	icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
		icm_object->icm_driver->pe,ICM_GETINFO,(LONG)&icinfo,sizeof(ICINFO));
#if defined(USE_CODEC)
	if (icm_object->icm_driver->pe->codec_type == ICM_ATTR_NATIVE)
		icm_info->name = g_strdup((gchar *)icinfo.szName);
	else
#endif /* defined(USE_CODEC) */
		icm_info->name=misc_widestring_to_multistring(icinfo.szName);
	icm_info->handler=icinfo.fccHandler;
	icm_info->flags=0;
	if ((icinfo.dwFlags&VIDCF_QUALITY)!=0)
		icm_info->flags=ICM_FLAG_QUALITY;
	if ((icinfo.dwFlags&VIDCF_CRUNCH)!=0)
		icm_info->flags|=ICM_FLAG_CRUNCH;
	if ((icinfo.dwFlags&VIDCF_TEMPORAL)!=0)
		icm_info->flags|=ICM_FLAG_TEMPORAL;
	if ((icinfo.dwFlags&VIDCF_COMPRESSFRAMES)!=0)
		icm_info->flags|=ICM_FLAG_COMPRESSFRAMES;
	if ((icinfo.dwFlags&VIDCF_DRAW)!=0)
		icm_info->flags|=ICM_FLAG_DRAW;
	if ((icinfo.dwFlags&VIDCF_FASTTEMPORALC)!=0)
		icm_info->flags|=ICM_FLAG_FASTTEMPORALC;
	if ((icinfo.dwFlags&VIDCF_FASTTEMPORALD)!=0)
		icm_info->flags|=ICM_FLAG_FASTTEMPORALD;
	if ((icinfo.dwFlags&VIDCF_QUALITYTIME)!=0)
		icm_info->flags|=ICM_FLAG_QUALITYTIME;
	icm_info->attribute = icm_object->icm_driver->pe->codec_type;
	return TRUE;
#else
	return FALSE;
#endif
}


/*	ѥ᡼Υ
	icm_object,IcmObject
	       RET,														*/
gsize icm_get_state_size(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL
				&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
								icm_object->icm_driver->pe,ICM_GETSTATE,0,0);
#else
	return 0;
#endif
}


/*	ѥ᡼
	icm_object,IcmObject
	     param,ѥ᡼
	param_size,ѥ᡼Υ
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_get_state(IcmObject *icm_object,gpointer param,gsize param_size)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && param!=NULL && param_size>0
				&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,ICM_GETSTATE,
										(LPARAM)param,param_size)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	ѥ᡼ꤹ
	icm_object,IcmObject
	     param,ѥ᡼
	param_size,ѥ᡼Υ
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_set_state(IcmObject *icm_object,gpointer param,gsize param_size)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object!=NULL && param!=NULL && param_size>0) {
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,ICM_SETSTATE,
													(LPARAM)param,param_size);
		return TRUE;
	}
#endif
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ICM                                                               *
*                                                                             *
******************************************************************************/
/*	AboutΥݡȤǧ
	icm_object,IcmObject
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_is_dialog_about(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && icm_object->icm_driver->DriverProc
							(icm_object->dwDriverId,icm_object->icm_driver->pe,
													ICM_ABOUT,-1,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Aboutɽ
	icm_object,IcmObject													*/
void icm_dialog_about(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object!=NULL)
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,ICM_ABOUT,0,0);
#endif
}


/*	ΥݡȤǧ
	icm_object,IcmObject
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_is_dialog_configure(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && icm_object->icm_driver->DriverProc
							(icm_object->dwDriverId,icm_object->icm_driver->pe,
												ICM_CONFIGURE,-1,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	ɽ
	icm_object,IcmObject													*/
void icm_dialog_configure(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object!=NULL)
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
								icm_object->icm_driver->pe,ICM_CONFIGURE,0,0);
#endif
}


/******************************************************************************
*                                                                             *
* ICM Compress                                                                *
*                                                                             *
******************************************************************************/
/*	̲ǽǧ
	icm_object,IcmObject
	      bmih,̤ӥåȥޥåפΥإå
	       RET,TRUE:ǽ,FALSE:Բǽ										*/
gboolean icm_compress_query(IcmObject *icm_object,const BitmapInfoHeader *bmih)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && bmih!=NULL
				&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,
									ICM_COMPRESS_QUERY,(LONG)bmih,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	̤ΥǥեȤμ
	icm_object,IcmObject
	       RET,ǥե(0:̤б)											*/
gint icm_compress_get_default_key_frame(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	DWORD dwKeyFrame;

	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
		icm_object->icm_driver->pe,
		ICM_GETDEFAULTKEYFRAMERATE,(LONG)&dwKeyFrame,0)==ICERR_OK?dwKeyFrame:0;
#else
	return 0;
#endif
}


/*	̤ΥǥեȤʼ
	icm_object,IcmObject
	       RET,ǥե(-1:̤б)										*/
gint icm_compress_get_default_quality(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	DWORD dwQuality;

	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_GETDEFAULTQUALITY,(LONG)&dwQuality,0)==ICERR_OK?dwQuality:-1;
#else
	return -1;
#endif
}


/*	̸ΥեޥåȤΥ
	icm_object,IcmObject
	      bmih,̤ӥåȥޥåפΥإå
	       RET,Хȿ,0:顼											*/
gsize icm_compress_get_format_size(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL || bmih==NULL)
		return 0;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
										icm_object->icm_driver->pe,
										ICM_COMPRESS_GET_FORMAT,(LONG)bmih,0);
#else
	return 0;
#endif
}


/*	̸ΥեޥåȤ
	icm_object,IcmObject
	   bmih_in,̤ӥåȥޥåפΥإå
	  bmih_out,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_get_format(IcmObject *icm_object,
					const BitmapInfoHeader *bmih_in,BitmapInfoHeader *bmih_out)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && bmih_in!=NULL && bmih_out!=NULL
		&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_COMPRESS_GET_FORMAT,(LONG)bmih_in,(LONG)bmih_out)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	̸Υǡκ祵
	icm_object,IcmObject
	       RET,Хȿ,0:顼											*/
gsize icm_compress_get_size(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL
					&& icm_object->bmih_in!=NULL && icm_object->bmih_out!=NULL
				?icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
					icm_object->icm_driver->pe,ICM_COMPRESS_GET_SIZE,
					(LONG)icm_object->bmih_in,(LONG)icm_object->bmih_out):0;
#else
	return 0;
#endif
}


/*	̤ꤹ
	icm_object,IcmObject
	   bmih_in,̤ӥåȥޥåפΥإå
	  bmih_out,̤줿ӥåȥޥåפΥإå
	 bmih_size,̤줿ӥåȥޥåפΥإåΥ
	 key_frame,(0:٤ƥե졼)
	   quality,ʼ010000,-1:ǥե
     data_rate,1ô֤Υ(0:̵)
	      rate,졼
	     scale,
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_frames_info(IcmObject *icm_object,
				const BitmapInfoHeader *bmih_in,
				const BitmapInfoHeader *bmih_out,const gsize bmih_size,
				const gint key_frame,const gint quality,const gsize data_rate,
										const guint32 rate,const guint32 scale)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	IcmInfo icm_info;
	ICCOMPRESSFRAMES iccompressframes;

	if (icm_object==NULL || !icm_get_info(icm_object,&icm_info))
		return FALSE;
	if (bmih_in!=NULL) {
		g_free(icm_object->bmih_in);
		icm_object->bmih_in=g_memdup(bmih_in,bm_header_bytes(bmih_in));
	}
	if (icm_object->bmih_in==NULL)
		return FALSE;
	if (bmih_out!=NULL && bmih_size>0) {
		g_free(icm_object->bmih_out);
		icm_object->bmih_out=g_memdup(bmih_out,bmih_size);
	} else if (icm_object->bmih_out==NULL) {
		icm_object->bmih_out
				=g_malloc(icm_compress_get_format_size(icm_object,bmih_in));
		if (!icm_compress_get_format(icm_object,
											bmih_in,icm_object->bmih_out)) {
			g_free(icm_object->bmih_out);
			icm_object->bmih_out=NULL;
			return FALSE;
		}
	}
	if (0<=quality && quality<=10000)
		icm_object->quality=quality;
	else if (quality==-1)
		icm_object->quality=icm_compress_get_default_quality(icm_object);
	if (icm_object->quality<0 && 10000<icm_object->quality)
		icm_object->quality=0;
	if ((icm_info.flags&ICM_FLAG_COMPRESSFRAMES)!=0) {
		g_memset(&iccompressframes,0,sizeof(ICCOMPRESSFRAMES));
		iccompressframes.lpbiOutput=icm_object->bmih_out;
		iccompressframes.lpbiInput=icm_object->bmih_in;
		iccompressframes.lFrameCount=icm_object->frame;
		iccompressframes.lQuality=icm_object->quality;
		iccompressframes.lDataRate=data_rate>0?data_rate:G_MAXINT;
		iccompressframes.lKeyRate=key_frame>=1?key_frame
						:MAX(icm_compress_get_default_key_frame(icm_object),1);
		iccompressframes.dwRate=MAX(rate,1);
		iccompressframes.dwScale=MAX(scale,1);
		icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
						icm_object->icm_driver->pe,ICM_COMPRESS_FRAMES_INFO,
							(LONG)&iccompressframes,sizeof(ICCOMPRESSFRAMES));
	}
	return TRUE;
#else
	return FALSE;
#endif
}


/*	̤򳫻Ϥ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_begin(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL || icm_object->bmih_in==NULL
													|| icm_object->prev!=NULL)
		return FALSE;
	if (icm_object->bmih_out==NULL) {
		icm_object->bmih_out=g_malloc(icm_compress_get_format_size(icm_object,
														icm_object->bmih_in));
		if (!icm_compress_get_format(icm_object,
								icm_object->bmih_in,icm_object->bmih_out)) {
			g_free(icm_object->bmih_out);
			icm_object->bmih_out=NULL;
			return FALSE;
		}
	}
	if (icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,ICM_COMPRESS_BEGIN,
			(LONG)icm_object->bmih_in,(LONG)icm_object->bmih_out)==ICERR_OK
				&& (icm_object->size=icm_compress_get_size(icm_object))>0) {
		icm_object->frame=0;
		icm_object->prev_size=bm_image_bytes(icm_object->bmih_in);
		icm_object->prev=g_malloc(icm_object->prev_size);
		return TRUE;
	}
#endif
	return FALSE;
}


/*	Ÿλ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_end(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL || icm_object->prev==NULL)
		return FALSE;
	g_free(icm_object->prev);
	icm_object->prev=NULL;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
					icm_object->icm_driver->pe,ICM_COMPRESS_END,0,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	̤
	icm_object,IcmObject
	 key_frame,TRUE:ե졼,FALSE:󥭡ե졼
	     input,̤ǡ
	    output,̤줿ǡ
	       RET,ե졼Υ,0:顼									*/
gsize icm_compress(IcmObject *icm_object,
							gboolean *key_frame,gpointer input,gpointer output)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	DWORD dwFlags,dwID;
	ICCOMPRESS iccompress;

	if (icm_object==NULL || input==NULL || output==NULL
					|| icm_object->bmih_in==NULL || icm_object->bmih_out==NULL
						|| icm_object->prev==NULL || icm_object->prev_size<=0)
		return 0;
	iccompress.dwFlags=ICCOMPRESS_KEYFRAME;
	iccompress.lpbiOutput=icm_object->bmih_out;
	iccompress.lpOutput=output;
	iccompress.lpbiInput=icm_object->bmih_in;
	iccompress.lpInput=input;
	iccompress.lpckid=&dwID;
	iccompress.lpdwFlags=&dwFlags;
	iccompress.lFrameNum=icm_object->frame;
	iccompress.dwFrameSize=icm_object->size;
	iccompress.dwQuality=icm_object->quality;
	if (icm_object->frame>0) {
		iccompress.lpbiPrev=icm_object->bmih_in;
		iccompress.lpPrev=icm_object->prev;
	} else {
		iccompress.lpbiPrev=NULL;
		iccompress.lpPrev=NULL;
	}
	if (icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
				icm_object->icm_driver->pe,
				ICM_COMPRESS,(LONG)&iccompress,sizeof(ICCOMPRESS))==ICERR_OK
			&& bmih_get_size_image(icm_object->bmih_out)<=icm_object->size) {
		icm_object->frame++;
		g_memmove(icm_object->prev,input,icm_object->prev_size);
		if (key_frame!=NULL)
			*key_frame=(dwFlags&AVIIF_KEYFRAME)!=0;
		return bmih_get_size_image(icm_object->bmih_out);
	}
#endif
	return 0;
}


/******************************************************************************
*                                                                             *
* ICM Decompress                                                              *
*                                                                             *
******************************************************************************/
/*	Ÿǽǧ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ǽ,FALSE:Բǽ										*/
gboolean icm_decompress_query(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && bmih!=NULL
				&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
								icm_object->icm_driver->pe,
								ICM_DECOMPRESS_QUERY,(LONG)bmih,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	ŸΥեޥåȤΥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,Хȿ,0:顼											*/
gsize icm_decompress_get_format_size(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL || bmih==NULL)
		return 0;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
									icm_object->icm_driver->pe,
									ICM_DECOMPRESS_GET_FORMAT,(LONG)bmih,0);
#else
	return 0;
#endif
}


/*	ŸΥեޥåȤ
	icm_object,IcmObject
	   bmih_in,̤줿ӥåȥޥåפΥإå
	  bmih_out,Ÿ줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_get_format(IcmObject *icm_object,
					const BitmapInfoHeader *bmih_in,BitmapInfoHeader *bmih_out)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	return icm_object!=NULL && bmih_in!=NULL && bmih_out!=NULL
		&& icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_DECOMPRESS_GET_FORMAT,(LONG)bmih_in,(LONG)bmih_out)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Ÿ򳫻Ϥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_begin(IcmObject *icm_object,
												const BitmapInfoHeader *bmih)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL || bmih==NULL
					|| icm_object->bmih_in!=NULL || icm_object->bmih_out!=NULL)
		return FALSE;
	icm_object->bmih_out
					=g_malloc(icm_decompress_get_format_size(icm_object,bmih));
	if (!icm_decompress_get_format(icm_object,bmih,icm_object->bmih_out)
				|| icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
							icm_object->icm_driver->pe,
							ICM_DECOMPRESS_BEGIN,
							(LONG)bmih,(LONG)icm_object->bmih_out)!=ICERR_OK) {
		g_free(icm_object->bmih_out);
		icm_object->bmih_out=NULL;
		return FALSE;
	}
	icm_object->bmih_in=g_memdup(bmih,bm_header_bytes(bmih));
	return TRUE;
#else
	return FALSE;
#endif
}


/*	Ÿλ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_end(IcmObject *icm_object)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	if (icm_object==NULL
				|| (icm_object->bmih_in==NULL && icm_object->bmih_out==NULL))
		return FALSE;
	g_free(icm_object->bmih_in);
	g_free(icm_object->bmih_out);
	icm_object->bmih_in=NULL;
	icm_object->bmih_out=NULL;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
				icm_object->icm_driver->pe,ICM_DECOMPRESS_END,0,0)==ICERR_OK;
#else
	return FALSE;
#endif
}


/*	Ÿ
	icm_object,IcmObject
	     flags,ե饰
	     input,̤줿ǡ
	    output,Ÿ줿ǡ
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress(IcmObject *icm_object,
							const guint flags,gpointer input,gpointer output)
{
#if defined(W32CODECDIR) || defined(USE_CODEC)
	ICDECOMPRESS icdecompress;

	if (icm_object==NULL || input==NULL || output==NULL
					|| icm_object->bmih_in==NULL || icm_object->bmih_out==NULL)
		return FALSE;
	icdecompress.dwFlags=0;
	if ((flags&ICM_DECOMPRESS_HURRYUP)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_HURRYUP;
	if ((flags&ICM_DECOMPRESS_UPDATE)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_UPDATE;
	if ((flags&ICM_DECOMPRESS_PREROLL)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_PREROLL;
	if ((flags&ICM_DECOMPRESS_NULLFRAME)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_NULLFRAME;
	if ((flags&ICM_DECOMPRESS_NOTKEYFRAME)!=0)
		icdecompress.dwFlags|=ICDECOMPRESS_NOTKEYFRAME;
	icdecompress.lpbiInput=icm_object->bmih_in;
	icdecompress.lpInput=input;
	icdecompress.lpbiOutput=icm_object->bmih_out;
	icdecompress.lpOutput=output;
	icdecompress.ckid=0;
	return icm_object->icm_driver->DriverProc(icm_object->dwDriverId,
			icm_object->icm_driver->pe,
			ICM_DECOMPRESS,(LONG)&icdecompress,sizeof(ICDECOMPRESS))==ICERR_OK;
#else
	return FALSE;
#endif
}

