/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "gdi32.h"


/******************************************************************************
*                                                                             *
* GDI                                                                         *
*                                                                             *
******************************************************************************/
typedef HANDLE HGDIOBJ;
typedef DWORD COLORREF,*PCOLORREF,*LPCOLORREF;
#include <pshpack1.h>
typedef struct tagPALETTEENTRY {
	BYTE peRed;
	BYTE peGreen;
	BYTE peBlue;
	BYTE peFlags;
} PALETTEENTRY,*PPALETTEENTRY,*LPPALETTEENTRY;
#include <poppack.h>


static BOOL WINAPI BitBlt(
					HDC hdcDest,INT nXDest,INT nYDest,INT nWidth,INT nHeight,
									HDC hdcSrc,INT nXSrc,INT nYSrc,DWORD dwRop)
{
	g_debug("BitBlt");
	return FALSE;
}


static HDC WINAPI CreateCompatibleDC(HDC hdc)
{
	g_debug("CreateCompatibleDC");
	return NULL;
}


static BOOL WINAPI DeleteDC(HDC hdc)
{
	g_debug("DeleteDC");
	return FALSE;
}


static BOOL WINAPI DeleteObject(HGDIOBJ hObject)
{
	g_debug("DeleteObject");
	return FALSE;
}


static INT WINAPI GetDeviceCaps(HDC hdc,INT nIndex)
{
	g_debug("GetDeviceCaps(%08x,%d)",(guint32)hdc,nIndex);
	return 0;
}


static COLORREF WINAPI GetNearestColor(HDC hdc,COLORREF crColor)
{
	g_debug("GetNearestColor");
	return crColor;
}


static INT WINAPI GetObjectA(HGDIOBJ hgdiobj,INT cbBuffer,LPVOID lpvObject)
{
	g_debug("GetObjectA");
	return 0;
}


static UINT WINAPI GetSystemPaletteEntries(HDC hdc,
							UINT iStartIndex,UINT nEntries,LPPALETTEENTRY lppe)
{
	g_debug("GetSystemPaletteEntries");
	return 0;
}


static HGDIOBJ WINAPI SelectObject(HDC hdc,HGDIOBJ hgdiobj)
{
	g_debug("SelectObject");
	return NULL;
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in gdi32 called");
}


static SymbolInfo symbol_infos[]={
	{"BitBlt",BitBlt},
	{"CreateCompatibleDC",CreateCompatibleDC},
	{"DeleteDC",DeleteDC},
	{"DeleteObject",DeleteObject},
	{"GetDeviceCaps",GetDeviceCaps},
	{"GetNearestColor",GetNearestColor},
	{"GetObjectA",GetObjectA},
	{"GetSystemPaletteEntries",GetSystemPaletteEntries},
	{"SelectObject",SelectObject},
	{NULL,UnknownSymbol}
};


SymbolInfo *gdi32_get_export_symbols(void)
{
	return symbol_infos;
}
