/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "file.h"
#include "sigfile.h"
#include "sigmain.h"
#include "size.h"
#include "thread.h"
#include "misc/misc.h"
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* եؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե˲ä
	file,ե̾															*/
void file_set_history(const gchar *file)
{
	gchar *label;
	gint i,count;
	GList *glist;
	GtkWidget *menu_shell, *menu_item;

	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
																"<main>/File");
	glist = gtk_container_children (GTK_CONTAINER (menu_shell));
	count=g_list_length(glist);
	for (i=0;i<count-MENUFILE-1;i++) {
		menu_item=g_list_nth_data(glist,i+MENUFILE-1);
		label=gtk_object_get_user_data(GTK_OBJECT(menu_item));
		if (g_strcmp(label,file)==0) {
			gtk_container_remove (GTK_CONTAINER (menu_shell), menu_item);
			break;
		}
	}
	g_list_free(glist);
	if (i>=history) {
		glist = gtk_container_children (GTK_CONTAINER (menu_shell));
		gtk_container_remove (GTK_CONTAINER (menu_shell),
						g_list_nth_data (glist, MENUFILE + history + 1 - 3));
		g_list_free(glist);
	}
	if (count<=MENUFILE) {
		menu_item=gtk_menu_item_new();
		gtk_menu_insert (GTK_MENU (menu_shell), menu_item, MENUFILE - 2);
		gtk_widget_show(menu_item);
	}
	label=g_strdup(file);
	menu_item=gtk_menu_item_new_with_label(label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_history),label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
						GTK_SIGNAL_FUNC(signal_destroy_menu_history),label);
	gtk_object_set_user_data(GTK_OBJECT(menu_item),label);
	gtk_menu_insert (GTK_MENU (menu_shell), menu_item, MENUFILE - 1);
	gtk_widget_show(menu_item);
}


/*	եä
	file,ä褦ȤեΥեѥ
	same,եѥ°
	 RET,ä褦ȤեΥ٥										*/
gchar *file_add_edit(const gchar *file,gint *same)
{
	gchar *label;
	const gchar *name0,*name1;
	gint i;
	GList *glist;
	GtkWidget *child;
	VmaidWindow *vmaid;

	*same=-1;
	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ƱѥĴ٤ */
	for (i=g_list_length(glist)-1;i>=0;i--) {
		child=g_list_nth_data(glist,i);
		vmaid=gtk_object_get_user_data(GTK_OBJECT(child));
		if (g_strcmp(file,vmaid->file)==0) {
			if (vmaid->same<0) {
				vmaid->same=0;
				label=g_strdup_printf("%s:%d",vmaid->file,vmaid->same);
				gtk_label_set_text(GTK_LABEL(vmaid->label),label);
				g_free(label);
			}
			if (*same<=vmaid->same)
				*same=vmaid->same+1;
		}
	}
	if (*same>=0) {
		/* Ʊ̾ƱѥȤ */
		label=g_strdup_printf("%s:%d",file,*same);
	} else {
		/* Ʊ̾ƱѥϤʤȤ */
		/* Ʊ̾ۥѥĴ٤ */
		name0=g_basename(file);
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			vmaid=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(vmaid->file);
			if (g_strcmp(name0,name1)==0) {
				if (vmaid->same<0)
					gtk_label_set_text(GTK_LABEL(vmaid->label),vmaid->file);
				break;
			}
		}
		label=g_strdup(i>=0?file:name0);
	}
	g_list_free(glist);
	return label;
}


/*	ե
	file,褦ȤեΥեѥ									*/
void file_delete_edit(const gchar *file)
{
	const gchar *name0,*name1;
	gint i,count=0;
	GList *glist;
	GtkWidget *child;
	VmaidWindow *vmaid;

	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ۥѥĴ٤ */
	name0=g_basename(file);
	for (i=g_list_length(glist)-1;i>=0;i--) {
		vmaid=gtk_object_get_user_data(g_list_nth_data(glist,i));
		name1=g_basename(vmaid->file);
		if (g_strcmp(name0,name1)==0)
			count++;
	}
	if (count<=2) {
		/* Ʊ̾ۥѥΥե̾ɽѹ */
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			vmaid=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(vmaid->file);
			if (g_strcmp(name0,name1)==0)
				gtk_label_set_text(GTK_LABEL(vmaid->label),name1);
		}
	} else {
		/* Ʊ̾ƱѥĴ٤ */
		count=0;
		for (i=g_list_length(glist)-1;i>=0;i--) {
			vmaid=gtk_object_get_user_data(g_list_nth_data(glist,i));
			if (g_strcmp(file,vmaid->file)==0)
				count++;
		}
		if (count<=2)/* Ʊ̾ƱѥΥեեѥɽѹ */
			for (i=g_list_length(glist)-1;i>=0;i--) {
				child=g_list_nth_data(glist,i);
				vmaid=gtk_object_get_user_data(GTK_OBJECT(child));
				if (g_strcmp(file,vmaid->file)==0) {
					vmaid->same=-1;
					gtk_label_set_text(GTK_LABEL(vmaid->label),vmaid->file);
				}
			}
	}
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	AVIե򳫤
	 avi,AVIԽ¤
	file,ե̾															*/
static void file_open_avi(AviEdit *avi_edit[],const gchar *file)
{
	gint i;
	guint32 streams;
	AviEdit *avi_edit_tmp;

	avi_edit[0]=avi_edit[1]=NULL;
	streams=MAX(avi_main_streams(file),1);
	for (i=0;i<streams && (avi_edit[0]==NULL || avi_edit[1]==NULL);i++)
		if ((avi_edit_tmp=avi_open(file,i))!=NULL)
			switch (avi_type(avi_edit_tmp)) {
				case streamtypeVIDEO:
					if (avi_edit[0]==NULL)
						avi_edit[0]=avi_edit_tmp;
					else
						avi_release(avi_edit_tmp);
					break;
				case streamtypeAUDIO:
					if (avi_edit[1]==NULL)
						avi_edit[1]=avi_edit_tmp;
					else
						avi_release(avi_edit_tmp);
					break;
				default:
					avi_release(avi_edit_tmp);
			}
}


/*	ե򳫤(Ωå)
	file_open,Open
	 RET,ɥ														*/
VmaidWindow *file_open_edit(FileOpen *file_open)
{
	int fd;
	gboolean result;
	gchar *text=NULL,*format=NULL,*file,*dir,*head,*scenario;
	const gchar *name,*foot;
	gint i,j,value,max=0;
	off_t offset;
#ifdef USE_GTK2
	GThread *id;
#else
	pthread_t id;
#endif
	AviEdit *avi_edit_old[2],*avi_edit_tmp[2],**avi_edit;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkWidget *xbox, *hbox, *vbox, *menu_shell, *button, *frame;
	VmaidWindow *vmaid;
	static gint fcount=0;	/* եο */
	static gchar *xpm[]={
"8 7 2 1",
" 	c None",
".	c #000000",
"..    ..",
" ..  .. ",
"  ....  ",
"   ..   ",
"  ....  ",
" ..  .. ",
"..    .."};

#ifdef USE_GTK2
	id=g_thread_self();
#else
	id=pthread_self();
#endif
	thread_insert(id,THREAD_MODE_OPEN,file_open!=NULL?file_open->file:NULL);

	vmaid=g_malloc(sizeof(VmaidWindow));
	vmaid->edit=FALSE;
	vmaid->same=-1;
	vmaid->undo=vmaid->redo=NULL;
	vmaid->rate=default_rate;
	vmaid->scale=1;
	vmaid->cursor.stream=0;
	vmaid->cursor.frame=0;
	vmaid->select.stream=-1;
	vmaid->select.frame=-1;
	vmaid->top=0;
	vmaid->avi_edit[0]=NULL;
	vmaid->avi_edit[1]=NULL;
	vmaid->timer_id=0;
	if (file_open==NULL) {
		/*  */
		vmaid->file=g_strdup_printf("new%04d",fcount++%1000);
	} else {
		vmaid->file=misc_get_full_path(file_open->file);
		g_free(file_open->file);
		file_open_avi(vmaid->avi_edit,vmaid->file);
		if ((vmaid->avi_edit[0]!=NULL || vmaid->avi_edit[1]!=NULL)
														&& file_open->merge) {
			/* Ϣ */
			name=g_basename(vmaid->file);
			for (i=g_strlen(name)-1;i>=0;i--)
				if ('0'<=name[i] && name[i]<='9')
					break;
			if (i>=0) {
				dir=g_dirname(vmaid->file);
				head=g_strdup(name);
				foot=name+i+1;
				for (j=i-1;j>=0;j--)
					if (head[j]<'0' || '9'<head[j])
						break;
				misc_str_to_val(&value,head+j+1,10,FALSE);
				head[j+1]='\0';
				format=g_strdup_printf("%s/%s%%0%dd%s",dir,head,i-j,foot);
				g_free(dir);
				g_free(head);
				max=1;
				while (j<i) {
					max*=10;
					j++;
				}
			}
		}
		if (format!=NULL) {
			/* Ϣ */
			for (i=value-1,result=TRUE;i>=0 && result;i--) {
				/* Ϣ */
				file=g_strdup_printf(format,i);
				file_open_avi(avi_edit_tmp,file);
				g_free(file);
				if (avi_edit_tmp[0]==NULL && avi_edit_tmp[1]==NULL)
					break;
				for (j=0;j<2;j++)
					if (vmaid->avi_edit[j]!=NULL) {
						avi_edit_old[j]=avi_clone(vmaid->avi_edit[j]);
						if (!avi_paste(vmaid->avi_edit[j],0,avi_edit_tmp[j]))
							result=FALSE;
					} else {
						avi_edit_old[j]=NULL;
						vmaid->avi_edit[j]=avi_edit_tmp[j];
					}
				if (result) {
					for (j=0;j<2;j++)
						if (avi_edit_old[j]!=NULL)
							avi_release(avi_edit_old[j]);
				} else {
					for (j=0;j<2;j++) {
						if (vmaid->avi_edit[j]!=NULL)
							avi_release(vmaid->avi_edit[j]);
						vmaid->avi_edit[j]=avi_edit_old[j];
					}
				}
			}
			for (i=value+1,result=TRUE;i<max && result;i++) {
				/* Ϣָ */
				file=g_strdup_printf(format,i);
				file_open_avi(avi_edit_tmp,file);
				g_free(file);
				if (avi_edit_tmp[0]==NULL && avi_edit_tmp[1]==NULL)
					break;
				for (j=0;j<2;j++)
					if (vmaid->avi_edit[j]!=NULL) {
						avi_edit_old[j]=avi_clone(vmaid->avi_edit[j]);
						if (!avi_paste(vmaid->avi_edit[j],
												avi_length(vmaid->avi_edit[j]),
															avi_edit_tmp[j]))
							result=FALSE;
					} else {
						avi_edit_old[j]=NULL;
						vmaid->avi_edit[j]=avi_edit_tmp[j];
					}
				if (result) {
					for (j=0;j<2;j++)
						if (avi_edit_old[j]!=NULL)
							avi_release(avi_edit_old[j]);
				} else {
					for (j=0;j<2;j++) {
						if (vmaid->avi_edit[j]!=NULL)
							avi_release(vmaid->avi_edit[j]);
						vmaid->avi_edit[j]=avi_edit_old[j];
					}
				}
			}
		}
		if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]==NULL
							&& avi_file_type(vmaid->file)==AVI_TYPE_SCENARIO) {
			/* ե򳫤 */
			if ((fd=open(vmaid->file,O_RDONLY))==-1) {
				g_free(file_open);
				g_free(vmaid->file);
				g_free(vmaid);
				return NULL;
			}
			/* ɤ߹ */
			if (
#ifdef HAVE_FLOCK
				flock (fd, LOCK_SH) != 0 ||
#endif
									(offset=lseek(fd,0,SEEK_END))==-1
									|| lseek(fd,0,SEEK_SET)==-1
									|| (scenario=g_malloc(offset+1))==NULL) {
				close(fd);
				g_free(file_open);
				g_free(vmaid->file);
				g_free(vmaid);
				return 0;
			}
			scenario[offset]='\0';
			if (read(fd,scenario,offset)!=offset) {
				close(fd);
				g_free(scenario);
				g_free(file_open);
				g_free(vmaid->file);
				g_free(vmaid);
				return 0;
			}
			if (close(fd)!=0) {
				g_free(scenario);
				g_free(file_open);
				g_free(vmaid->file);
				g_free(vmaid);
				return 0;
			}
			if ((avi_edit=avi_from_scenario(scenario))!=NULL)
				for (i=0;avi_edit[i]!=NULL;i++)
					switch (avi_type(avi_edit[i])) {
						case streamtypeVIDEO:
							if (vmaid->avi_edit[0]==NULL)
								vmaid->avi_edit[0]=avi_edit[i];
							else
								avi_release(avi_edit[i]);
							break;
						case streamtypeAUDIO:
							if (vmaid->avi_edit[1]==NULL)
								vmaid->avi_edit[1]=avi_edit[i];
							else
								avi_release(avi_edit[i]);
							break;
						default:
							avi_release(avi_edit[i]);
					}
		}
	}

	if (!thread_idling(id,100)) {
		g_free(file_open);
		g_free(vmaid->file);
		for (i=0;i<2;i++)
			if (vmaid->avi_edit[i]!=NULL)
				avi_release(vmaid->avi_edit[i]);
		g_free(vmaid);
		return NULL;
	}

	if (vmaid->avi_edit[0]!=NULL) {
		size_set_scale(default_view,&vmaid->width,&vmaid->height,
										avi_get_width(vmaid->avi_edit[0]),
										avi_get_height(vmaid->avi_edit[0]));
		vmaid->rate=avi_get_rate(vmaid->avi_edit[0]);
		vmaid->scale=avi_get_scale(vmaid->avi_edit[0]);
	} else {
		size_set_scale(default_view,&vmaid->width,&vmaid->height,-1,-1);
	}
	if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]!=NULL)
		vmaid->cursor.stream=1;

	gdk_threads_enter();

	/* ե̾Ĵ٤ */
	text=file_add_edit(vmaid->file,&vmaid->same);

	/* ɽꥢ */
	vmaid->drawing=gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"focus-in-event",
							GTK_SIGNAL_FUNC(signal_focus_in),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"focus-out-event",
							GTK_SIGNAL_FUNC(signal_focus_out),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"realize",
							GTK_SIGNAL_FUNC(signal_realize),NULL);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"configure-event",
							GTK_SIGNAL_FUNC(signal_config),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"expose-event",
							GTK_SIGNAL_FUNC(signal_expose),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"button-press-event",
							GTK_SIGNAL_FUNC(signal_button_press_draw),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"motion-notify-event",
							GTK_SIGNAL_FUNC(signal_motion_notify),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"button-release-event",
							GTK_SIGNAL_FUNC(signal_button_release),vmaid);
#ifdef USE_GTK2
	g_signal_connect (G_OBJECT (vmaid->drawing), "scroll-event",
							G_CALLBACK (signal_scroll), vmaid);
#endif /* USE_GTK2 */
	gtk_signal_connect_after(GTK_OBJECT(vmaid->drawing),"key-press-event",
							GTK_SIGNAL_FUNC(signal_key_press),vmaid);
	gtk_signal_connect(GTK_OBJECT(vmaid->drawing),"destroy",
							GTK_SIGNAL_FUNC(signal_destroy_draw),vmaid);
	gtk_widget_add_events (vmaid->drawing, GDK_POINTER_MOTION_MASK
							| GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK
							| GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK
							| GDK_FOCUS_CHANGE_MASK);
	gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,system_font_height*2
			+((vmaid->avi_edit[0]!=NULL?1:0)+(vmaid->avi_edit[1]!=NULL?1:0))
															*vmaid->height);
	GTK_WIDGET_SET_FLAGS(vmaid->drawing,GTK_CAN_FOCUS);
	/* С */
	vmaid->hscroll=gtk_hscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	/* ܥå */
	xbox=gtk_hbox_new(FALSE,0);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),vmaid->drawing,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),vmaid->hscroll,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(xbox),vbox,FALSE,FALSE,0);
	gtk_object_set_user_data(GTK_OBJECT(xbox),vmaid);
	/* ˥塼 */
	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
															"<main>/Window");
	vmaid->menu_item=gtk_menu_item_new_with_label(vmaid->file);
	gtk_signal_connect(GTK_OBJECT(vmaid->menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_window),xbox);
	gtk_menu_append (GTK_MENU (menu_shell), vmaid->menu_item);
	gtk_widget_show(vmaid->menu_item);
	/* ܥ */
	button=gtk_button_new();
	frame=gtk_frame_new(NULL);
	gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,xpm);
#ifdef USE_GTK2
	gtk_container_add (GTK_CONTAINER (frame),
									gtk_image_new_from_pixmap (pixmap, mask));
#else /* not USE_GTK2 */
	gtk_container_add (GTK_CONTAINER (frame), gtk_pixmap_new (pixmap, mask));
#endif /* not USE_GTK2 */
	gtk_container_add(GTK_CONTAINER(button),frame);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
										GTK_SIGNAL_FUNC(signal_clicked),xbox);
	/* ٥ */
	vmaid->label=gtk_label_new(text);
	g_free(text);
	/* ޡ */
	vmaid->mark = gtk_label_new ("*");
	/* ɽ */
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vmaid->label,TRUE,TRUE,0);
	gtk_box_pack_start (GTK_BOX (hbox), vmaid->mark, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),xbox,hbox);
	gtk_widget_show (hbox);
	gtk_widget_show (vmaid->label);
	gtk_widget_show_all (button);
	gtk_widget_show_all(xbox);
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),xbox));
	gtk_widget_grab_focus(vmaid->drawing);

	/* ǤϤʤե뤬¸ߤˤ˲ä */
	if (file_open!=NULL && history>0 && misc_isfile(vmaid->file))
		file_set_history(vmaid->file);

	gdk_threads_leave();

	g_free(file_open);
	thread_delete(id);
	return vmaid;
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
static gboolean file_save_edit_callback(gint percent,gpointer user_data)
{
#ifdef USE_GTK2
	return thread_idling(g_thread_self(),percent);
#else
	return thread_idling(pthread_self(),percent);
#endif
}


/*	AVIե¸(Ωå)
	file_save,Save
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean file_save_edit(FileSave *file_save)
{
	gboolean result;
	gint i;
#ifdef USE_GTK2
	GThread *id;
	id=g_thread_self();
#else
	pthread_t id;
	id=pthread_self();
#endif

	thread_insert(id,THREAD_MODE_SAVE,file_save->file);

	result=avi_save_with_options(file_save->avi_edit,file_save->file,
							file_save->avi_save,file_save_edit_callback,NULL);
	g_free(file_save->file);
	for (i=0;i<2;i++)
		if (file_save->avi_edit[i]!=NULL)
			avi_release(file_save->avi_edit[i]);
	avi_save_free(file_save->avi_save);
	g_free(file_save);

	if (!result)
		while (thread_idling(id,-1));

	thread_delete(id);
	return result;
}
