/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "prop.h"
#include <gdk/gdkkeysyms.h>
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ץѥƥؿ                                                  *
*                                                                             *
******************************************************************************/
#define MAKELANGID(p,s) ((((guint16)(s))<<10)|(guint16)(p))
#define LANG_NEUTRAL					0x00
#define LANG_AFRIKAANS					0x36
#define LANG_ALBANIAN					0x1c
#define LANG_ARABIC						0x01
#define LANG_ARMENIAN					0x2b
#define LANG_ASSAMESE					0x4d
#define LANG_AZERI						0x2c
#define LANG_BASQUE						0x2d
#define LANG_BENGALI					0x45
#define LANG_BULGARIAN					0x02
#define LANG_BYELORUSSIAN				0x23
#define LANG_CATALAN					0x03
#define LANG_CHINESE					0x04
#define LANG_SERBO_CROATIAN				0x1a
#define LANG_CROATIAN					LANG_SERBO_CROATIAN
#define LANG_SERBIAN	 				LANG_SERBO_CROATIAN
#define LANG_CZECH						0x05
#define LANG_DANISH						0x06
#define LANG_DUTCH						0x13
#define LANG_ENGLISH					0x09
#define LANG_ESTONIAN					0x25
#define LANG_FAEROESE					0x38
#define LANG_FARSI						0x29
#define LANG_FINNISH					0x0b
#define LANG_FRENCH						0x0c
#define LANG_GAELIC						0x3c
#define LANG_GEORGIAN					0x37
#define LANG_GERMAN						0x07
#define LANG_GREEK						0x08
#define LANG_GUJARATI					0x47
#define LANG_HEBREW						0x0D
#define LANG_HINDI						0x39
#define LANG_HUNGARIAN					0x0e
#define LANG_ICELANDIC					0x0f
#define LANG_INDONESIAN					0x21
#define LANG_ITALIAN					0x10
#define LANG_JAPANESE					0x11
#define LANG_KANNADA					0x4b
#define LANG_KAZAKH						0x3f
#define LANG_KONKANI					0x57
#define LANG_KOREAN						0x12
#define LANG_LATVIAN					0x26
#define LANG_LITHUANIAN					0x27
#define LANG_MACEDONIAN					0x2f
#define LANG_MALAY						0x3e
#define LANG_MALAYALAM					0x4c
#define LANG_MALTESE					0x3a
#define LANG_MAORI						0x28
#define LANG_MARATHI					0x4e
#define LANG_NORWEGIAN					0x14
#define LANG_ORIYA						0x48
#define LANG_POLISH						0x15
#define LANG_PORTUGUESE					0x16
#define LANG_PUNJABI					0x46
#define LANG_RHAETO_ROMANCE				0x17
#define LANG_ROMANIAN					0x18
#define LANG_RUSSIAN					0x19
#define LANG_SAAMI						0x3b
#define LANG_SANSKRIT					0x4f
#define LANG_SLOVAK						0x1b
#define LANG_SLOVENIAN					0x24
#define LANG_SORBIAN					0x2e
#define LANG_SPANISH					0x0a
#define LANG_SUTU						0x30
#define LANG_SWAHILI					0x41
#define LANG_SWEDISH					0x1d
#define LANG_TAMIL						0x49
#define LANG_TATAR						0x44
#define LANG_TELUGU						0x4a
#define LANG_THAI						0x1e
#define LANG_TSONGA						0x31
#define LANG_TSWANA						0x32
#define LANG_TURKISH					0x1f
#define LANG_UKRAINIAN					0x22
#define LANG_URDU						0x20
#define LANG_UZBEK						0x43
#define LANG_VENDA						0x33
#define LANG_VIETNAMESE					0x2a
#define LANG_XHOSA						0x34
#define LANG_ZULU						0x35
#define LANG_ESPERANTO					0x8f
#define LANG_WALON						0x90
#define LANG_CORNISH					0x91
#define LANG_WELSH						0x92
#define LANG_BRETON						0x93
/* Sublanguage definitions */
#define SUBLANG_NEUTRAL					0x00	/* language neutral */
#define SUBLANG_DEFAULT					0x01	/* user default */
#define SUBLANG_SYS_DEFAULT				0x02	/* system default */
#define SUBLANG_ARABIC					0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA		0x01
#define SUBLANG_ARABIC_IRAQ				0x02
#define SUBLANG_ARABIC_EGYPT			0x03
#define SUBLANG_ARABIC_LIBYA			0x04
#define SUBLANG_ARABIC_ALGERIA			0x05
#define SUBLANG_ARABIC_MOROCCO			0x06
#define SUBLANG_ARABIC_TUNISIA			0x07
#define SUBLANG_ARABIC_OMAN				0x08
#define SUBLANG_ARABIC_YEMEN			0x09
#define SUBLANG_ARABIC_SYRIA			0x0a
#define SUBLANG_ARABIC_JORDAN			0x0b
#define SUBLANG_ARABIC_LEBANON			0x0c
#define SUBLANG_ARABIC_KUWAIT			0x0d
#define SUBLANG_ARABIC_UAE				0x0e
#define SUBLANG_ARABIC_BAHRAIN			0x0f
#define SUBLANG_ARABIC_QATAR			0x10
#define SUBLANG_CHINESE_TRADITIONAL		0x01
#define SUBLANG_CHINESE_SIMPLIFIED		0x02
#define SUBLANG_CHINESE_HONGKONG		0x03
#define SUBLANG_CHINESE_SINGAPORE		0x04
#define SUBLANG_CHINESE_MACAU			0x05
#define SUBLANG_DUTCH					0x01
#define SUBLANG_DUTCH_BELGIAN			0x02
#define SUBLANG_DUTCH_SURINAM			0x03
#define SUBLANG_ENGLISH_US				0x01
#define SUBLANG_ENGLISH_UK				0x02
#define SUBLANG_ENGLISH_AUS				0x03
#define SUBLANG_ENGLISH_CAN				0x04
#define SUBLANG_ENGLISH_NZ				0x05
#define SUBLANG_ENGLISH_EIRE			0x06
#define SUBLANG_ENGLISH_SAFRICA			0x07
#define SUBLANG_ENGLISH_JAMAICA			0x08
#define SUBLANG_ENGLISH_CARRIBEAN		0x09
#define SUBLANG_ENGLISH_BELIZE			0x0a
#define SUBLANG_ENGLISH_TRINIDAD		0x0b
#define SUBLANG_ENGLISH_ZIMBABWE		0x0c
#define SUBLANG_ENGLISH_PHILIPPINES		0x0d
#define SUBLANG_FRENCH					0x01
#define SUBLANG_FRENCH_BELGIAN			0x02
#define SUBLANG_FRENCH_CANADIAN			0x03
#define SUBLANG_FRENCH_SWISS			0x04
#define SUBLANG_FRENCH_LUXEMBOURG		0x05
#define SUBLANG_FRENCH_MONACO			0x06
#define SUBLANG_GERMAN					0x01
#define SUBLANG_GERMAN_SWISS			0x02
#define SUBLANG_GERMAN_AUSTRIAN			0x03
#define SUBLANG_GERMAN_LUXEMBOURG		0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN	0x05
#define SUBLANG_ITALIAN					0x01
#define SUBLANG_ITALIAN_SWISS			0x02
#define SUBLANG_KOREAN					0x01
#define SUBLANG_KOREAN_JOHAB			0x02
#define SUBLANG_NORWEGIAN_BOKMAL		0x01
#define SUBLANG_NORWEGIAN_NYNORSK		0x02
#define SUBLANG_PORTUGUESE				0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN	0x01
#define SUBLANG_SPANISH					0x01
#define SUBLANG_SPANISH_MEXICAN			0x02
#define SUBLANG_SPANISH_MODERN			0x03
#define SUBLANG_SPANISH_GUATEMALA		0x04
#define SUBLANG_SPANISH_COSTARICA		0x05
#define SUBLANG_SPANISH_PANAMA			0x06
#define SUBLANG_SPANISH_DOMINICAN		0x07
#define SUBLANG_SPANISH_VENEZUELA		0x08
#define SUBLANG_SPANISH_COLOMBIA		0x09
#define SUBLANG_SPANISH_PERU			0x0a
#define SUBLANG_SPANISH_ARGENTINA		0x0b
#define SUBLANG_SPANISH_ECUADOR			0x0c
#define SUBLANG_SPANISH_CHILE			0x0d
#define SUBLANG_SPANISH_URUGUAY			0x0e
#define SUBLANG_SPANISH_PARAGUAY		0x0f
#define SUBLANG_SPANISH_BOLIVIA			0x10
#define SUBLANG_SPANISH_EL_SALVADOR		0x11
#define SUBLANG_SPANISH_HONDURAS		0x12
#define SUBLANG_SPANISH_NICARAGUA		0x13
#define SUBLANG_SPANISH_PUERTO_RICO		0x14
#define SUBLANG_ROMANIAN				0x01
#define SUBLANG_ROMANIAN_MOLDAVIA		0x02
#define SUBLANG_RUSSIAN					0x01
#define SUBLANG_RUSSIAN_MOLDAVIA		0x02
#define SUBLANG_CROATIAN				0x01
#define SUBLANG_SERBIAN					0x02
#define SUBLANG_SERBIAN_LATIN			0x03
#define SUBLANG_SWEDISH					0x01
#define SUBLANG_SWEDISH_FINLAND			0x02
#define SUBLANG_LITHUANIAN				0x01
#define SUBLANG_LITHUANIAN_CLASSIC		0x02
#define SUBLANG_AZERI					0x01
#define SUBLANG_AZERI_CYRILLIC			0x02
#define SUBLANG_GAELIC					0x01
#define SUBLANG_GAELIC_SCOTTISH			0x02
#define SUBLANG_GAELIC_MANX				0x03
#define SUBLANG_MALAY					0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM	0x02
#define SUBLANG_UZBEK					0x01
#define SUBLANG_UZBEK_CYRILLIC			0x02
#define SUBLANG_URDU_PAKISTAN			0x01


static gboolean prop_clicked_ok,prop_changed_entry;
static GtkWidget *dialog, *button0, *radio0, *radio2;
static GtkWidget *combo0, *combo1, *combo2, *entry0, *entry1, *entry2;
static GtkWidget *spin0, *spin1, *spin2, *spin3, *spin4, *spin5, *spin6;
static struct {
	const gchar *text;
	const gint bit;
} bit_count[]={{N_("Monochrome"),1},{N_("16 colors"),4},{N_("256 colors"),8},
		{N_("16 bits"),16},{N_("Full Color"),24},{N_("32 bits"),32},{NULL,0}};
static struct {
	const gchar *text;
	const guint16 id;
} lang[]={
{N_("Neutral"),						MAKELANGID (LANG_NEUTRAL,		SUBLANG_NEUTRAL)},
{N_("User Default"),				MAKELANGID (LANG_NEUTRAL,		SUBLANG_DEFAULT)},
{N_("System Default"),				MAKELANGID (LANG_NEUTRAL,		SUBLANG_SYS_DEFAULT)},
{N_("Afrikaans"),					MAKELANGID (LANG_AFRIKAANS,		SUBLANG_DEFAULT)},
{N_("Albanian"),					MAKELANGID (LANG_ALBANIAN,		SUBLANG_DEFAULT)},
{N_("Arabic"),						MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC)},
{N_("Arabic (Saudi Arabia)"),		MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_SAUDI_ARABIA)},
{N_("Arabic (Iraq)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_IRAQ)},
{N_("Arabic (Egypt)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_EGYPT)},
{N_("Arabic (Libya)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_LIBYA)},
{N_("Arabic (Algeria)"),			MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_ALGERIA)},
{N_("Arabic (Morocco)"),			MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_MOROCCO)},
{N_("Arabic (Tunisia)"),			MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_TUNISIA)},
{N_("Arabic (Oman)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_OMAN)},
{N_("Arabic (Yemen)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_YEMEN)},
{N_("Arabic (Syria)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_SYRIA)},
{N_("Arabic (Jordan)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_JORDAN)},
{N_("Arabic (Lebanon)"),			MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_LEBANON)},
{N_("Arabic (Kuwait)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_KUWAIT)},
{N_("Arabic (UAE)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_UAE)},
{N_("Arabic (Bahrain)"),			MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_BAHRAIN)},
{N_("Arabic (Qatar)"),				MAKELANGID (LANG_ARABIC,		SUBLANG_ARABIC_QATAR)},
{N_("Armenian"),					MAKELANGID (LANG_ARMENIAN,		SUBLANG_DEFAULT)},
{N_("Assamese"),					MAKELANGID (LANG_ASSAMESE,		SUBLANG_DEFAULT)},
{N_("Azeri"),						MAKELANGID (LANG_AZERI,			SUBLANG_AZERI)},
{N_("Azeri (Cyrillic)"),			MAKELANGID (LANG_AZERI,			SUBLANG_AZERI_CYRILLIC)},
{N_("Basque"),						MAKELANGID (LANG_BASQUE,		SUBLANG_DEFAULT)},
{N_("Bengali"),						MAKELANGID (LANG_BENGALI,		SUBLANG_DEFAULT)},
{N_("Bulgarian"),					MAKELANGID (LANG_BULGARIAN,		SUBLANG_DEFAULT)},
{N_("Byelorussian"),				MAKELANGID (LANG_BYELORUSSIAN,	SUBLANG_DEFAULT)},
{N_("Catalan"),						MAKELANGID (LANG_CATALAN,		SUBLANG_DEFAULT)},
{N_("Chinese (Traditional)"),		MAKELANGID (LANG_CHINESE,		SUBLANG_CHINESE_TRADITIONAL)},
{N_("Chinese (Simplified)"),		MAKELANGID (LANG_CHINESE,		SUBLANG_CHINESE_SIMPLIFIED)},
{N_("Chinese (HongKong)"),			MAKELANGID (LANG_CHINESE,		SUBLANG_CHINESE_HONGKONG)},
{N_("Chinese (Singapore)"),			MAKELANGID (LANG_CHINESE,		SUBLANG_CHINESE_SINGAPORE)},
{N_("Chinese (Macau)"),				MAKELANGID (LANG_CHINESE,		SUBLANG_CHINESE_MACAU)},
{N_("Croatian"),					MAKELANGID (LANG_SERBO_CROATIAN,SUBLANG_CROATIAN)},
{N_("Serbian"),						MAKELANGID (LANG_SERBO_CROATIAN,SUBLANG_SERBIAN)},
{N_("Serbian (Latin)"),				MAKELANGID (LANG_SERBO_CROATIAN,SUBLANG_SERBIAN_LATIN)},
{N_("Czech"),						MAKELANGID (LANG_CZECH,			SUBLANG_DEFAULT)},
{N_("Danish"),						MAKELANGID (LANG_DANISH,		SUBLANG_DEFAULT)},
{N_("Dutch"),						MAKELANGID (LANG_DUTCH,			SUBLANG_DUTCH)},
{N_("Dutch (Belgian)"),				MAKELANGID (LANG_DUTCH,			SUBLANG_DUTCH_BELGIAN)},
{N_("Dutch (Surinam)"),				MAKELANGID (LANG_DUTCH,			SUBLANG_DUTCH_SURINAM)},
{N_("English (US)"),				MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_US)},
{N_("English (UK)"),				MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_UK)},
{N_("English (Australia)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_AUS)},
{N_("English (Canada)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_CAN)},
{N_("English (New Zealand)"),		MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_NZ)},
{N_("English (Ireland)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_EIRE)},
{N_("English (South Africa)"),		MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_SAFRICA)},
{N_("English (Jamaica)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_JAMAICA)},
{N_("English (Carribean)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_CARRIBEAN)},
{N_("English (Belize)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_BELIZE)},
{N_("English (Trinidad)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_TRINIDAD)},
{N_("English (Zimbabwe)"),			MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_ZIMBABWE)},
{N_("English (Philippines)"),		MAKELANGID (LANG_ENGLISH,		SUBLANG_ENGLISH_PHILIPPINES)},
{N_("Estonian"),					MAKELANGID (LANG_ESTONIAN,		SUBLANG_DEFAULT)},
{N_("Faeroese"),					MAKELANGID (LANG_FAEROESE,		SUBLANG_DEFAULT)},
{N_("Farsi"),						MAKELANGID (LANG_FARSI,			SUBLANG_DEFAULT)},
{N_("Finnish"),						MAKELANGID (LANG_FINNISH,		SUBLANG_DEFAULT)},
{N_("French"),						MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH)},
{N_("French (Belgian)"),			MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH_BELGIAN)},
{N_("French (Canadian)"),			MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH_CANADIAN)},
{N_("French (Swiss)"),				MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH_SWISS)},
{N_("French (Luxembourg)"),			MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH_LUXEMBOURG)},
{N_("French (Monaco)"),				MAKELANGID (LANG_FRENCH,		SUBLANG_FRENCH_MONACO)},
{N_("Gaelic"),						MAKELANGID (LANG_GAELIC,		SUBLANG_GAELIC)},
{N_("Gaelic (Scottish)"),			MAKELANGID (LANG_GAELIC,		SUBLANG_GAELIC_SCOTTISH)},
{N_("Gaelic (Manx)"),				MAKELANGID (LANG_GAELIC,		SUBLANG_GAELIC_MANX)},
{N_("Georgian"),					MAKELANGID (LANG_GEORGIAN,		SUBLANG_DEFAULT)},
{N_("German"),						MAKELANGID (LANG_GERMAN,		SUBLANG_GERMAN)},
{N_("German (Swiss)"),				MAKELANGID (LANG_GERMAN,		SUBLANG_GERMAN_SWISS)},
{N_("German (Austrian)"),			MAKELANGID (LANG_GERMAN,		SUBLANG_GERMAN_AUSTRIAN)},
{N_("German (Luxembourg)"),			MAKELANGID (LANG_GERMAN,		SUBLANG_GERMAN_LUXEMBOURG)},
{N_("German (Liechtenstein)"),		MAKELANGID (LANG_GERMAN,		SUBLANG_GERMAN_LIECHTENSTEIN)},
{N_("Greek"),						MAKELANGID (LANG_GREEK,			SUBLANG_DEFAULT)},
{N_("Gujarati"),					MAKELANGID (LANG_GUJARATI,		SUBLANG_DEFAULT)},
{N_("Hebrew"),						MAKELANGID (LANG_HEBREW,		SUBLANG_DEFAULT)},
{N_("Hindi"),						MAKELANGID (LANG_HINDI,			SUBLANG_DEFAULT)},
{N_("Hungarian"),					MAKELANGID (LANG_HUNGARIAN,		SUBLANG_DEFAULT)},
{N_("Icelandic"),					MAKELANGID (LANG_ICELANDIC,		SUBLANG_DEFAULT)},
{N_("Indonesian"),					MAKELANGID (LANG_INDONESIAN,	SUBLANG_DEFAULT)},
{N_("Italian"),						MAKELANGID (LANG_ITALIAN,		SUBLANG_ITALIAN)},
{N_("Italian (Swiss)"),				MAKELANGID (LANG_ITALIAN,		SUBLANG_ITALIAN_SWISS)},
{N_("Japanese"),					MAKELANGID (LANG_JAPANESE,		SUBLANG_DEFAULT)},
{N_("Kannada"),						MAKELANGID (LANG_KANNADA,		SUBLANG_DEFAULT)},
{N_("Kazakh"),						MAKELANGID (LANG_KAZAKH,		SUBLANG_DEFAULT)},
{N_("Konkani"),						MAKELANGID (LANG_KONKANI,		SUBLANG_DEFAULT)},
{N_("Korean"),						MAKELANGID (LANG_KOREAN,		SUBLANG_KOREAN)},
{N_("Korean (Johab)"),				MAKELANGID (LANG_KOREAN,		SUBLANG_KOREAN_JOHAB)},
{N_("Latvian"),						MAKELANGID (LANG_LATVIAN,		SUBLANG_DEFAULT)},
{N_("Lithuanian"),					MAKELANGID (LANG_LITHUANIAN,	SUBLANG_LITHUANIAN)},
{N_("Lithuanian (Classic)"),		MAKELANGID (LANG_LITHUANIAN,	SUBLANG_LITHUANIAN_CLASSIC)},
{N_("Macedonian"),					MAKELANGID (LANG_MACEDONIAN,	SUBLANG_DEFAULT)},
{N_("Malay"),						MAKELANGID (LANG_MALAY,			SUBLANG_MALAY)},
{N_("Malay (Brunbei Darussalam)"),	MAKELANGID (LANG_MALAY,			SUBLANG_MALAY_BRUNEI_DARUSSALAM)},
{N_("Malayalam"),					MAKELANGID (LANG_MALAYALAM,		SUBLANG_DEFAULT)},
{N_("Maltese"),						MAKELANGID (LANG_MALTESE,		SUBLANG_DEFAULT)},
{N_("Maori"),						MAKELANGID (LANG_MAORI,			SUBLANG_DEFAULT)},
{N_("Marathi"),						MAKELANGID (LANG_MARATHI,		SUBLANG_DEFAULT)},
{N_("Norwegian"),					MAKELANGID (LANG_NORWEGIAN,		SUBLANG_NORWEGIAN_BOKMAL)},
{N_("Norwegian (Nynorsk)"),			MAKELANGID (LANG_NORWEGIAN,		SUBLANG_NORWEGIAN_NYNORSK)},
{N_("Oriya"),						MAKELANGID (LANG_ORIYA,			SUBLANG_DEFAULT)},
{N_("Polish"),						MAKELANGID (LANG_POLISH,		SUBLANG_DEFAULT)},
{N_("Portuguese"),					MAKELANGID (LANG_PORTUGUESE,	SUBLANG_PORTUGUESE)},
{N_("Portuguese (Brazilian)"),		MAKELANGID (LANG_PORTUGUESE,	SUBLANG_PORTUGUESE_BRAZILIAN)},
{N_("Punjabi"),						MAKELANGID (LANG_PUNJABI,		SUBLANG_DEFAULT)},
{N_("Rhaeto Romance"),				MAKELANGID (LANG_RHAETO_ROMANCE,SUBLANG_DEFAULT)},
{N_("Romanian"),					MAKELANGID (LANG_ROMANIAN,		SUBLANG_ROMANIAN)},
{N_("Romanian (Moldavia)"),			MAKELANGID (LANG_ROMANIAN,		SUBLANG_ROMANIAN_MOLDAVIA)},
{N_("Russian"),						MAKELANGID (LANG_RUSSIAN,		SUBLANG_RUSSIAN)},
{N_("Russian (Moldavia)"),			MAKELANGID (LANG_RUSSIAN,		SUBLANG_RUSSIAN_MOLDAVIA)},
{N_("Saami"),						MAKELANGID (LANG_SAAMI,			SUBLANG_DEFAULT)},
{N_("Sanskrit"),					MAKELANGID (LANG_SANSKRIT,		SUBLANG_DEFAULT)},
{N_("Slovak"),						MAKELANGID (LANG_SLOVAK,		SUBLANG_DEFAULT)},
{N_("Slovenian"),					MAKELANGID (LANG_SLOVENIAN,		SUBLANG_DEFAULT)},
{N_("Sorbian"),						MAKELANGID (LANG_SORBIAN,		SUBLANG_DEFAULT)},
{N_("Spanish"),						MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH)},
{N_("Spanish (Mexican)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_MEXICAN)},
{N_("Spanish (Modern)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_MODERN)},
{N_("Spanish (Guatemala)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_GUATEMALA)},
{N_("Spanish (Costarica)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_COSTARICA)},
{N_("Spanish (Panama)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_PANAMA)},
{N_("Spanish (Dominican)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_DOMINICAN)},
{N_("Spanish (Venezuela)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_VENEZUELA)},
{N_("Spanish (Colombia)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_COLOMBIA)},
{N_("Spanish (Peru)"),				MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_PERU)},
{N_("Spanish (Argentina)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_ARGENTINA)},
{N_("Spanish (Ecuador)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_ECUADOR)},
{N_("Spanish (Chile)"),				MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_CHILE)},
{N_("Spanish (Uruguay)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_URUGUAY)},
{N_("Spanish (Paraguay)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_PARAGUAY)},
{N_("Spanish (Bolivia)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_BOLIVIA)},
{N_("Spanish (El Salvador)"),		MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_EL_SALVADOR)},
{N_("Spanish (Honduras)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_HONDURAS)},
{N_("Spanish (Nicaragua)"),			MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_NICARAGUA)},
{N_("Spanish (Puerto Rico)"),		MAKELANGID (LANG_SPANISH,		SUBLANG_SPANISH_PUERTO_RICO)},
{N_("Sutu"),						MAKELANGID (LANG_SUTU,			SUBLANG_DEFAULT)},
{N_("Swahili"),						MAKELANGID (LANG_SWAHILI,		SUBLANG_DEFAULT)},
{N_("Swedish"),						MAKELANGID (LANG_SWEDISH,		SUBLANG_SWEDISH)},
{N_("Swedish (Finland)"),			MAKELANGID (LANG_SWEDISH,		SUBLANG_SWEDISH_FINLAND)},
{N_("Tamil"),						MAKELANGID (LANG_TAMIL,			SUBLANG_DEFAULT)},
{N_("Tatar"),						MAKELANGID (LANG_TATAR,			SUBLANG_DEFAULT)},
{N_("Telugu"),						MAKELANGID (LANG_TELUGU,		SUBLANG_DEFAULT)},
{N_("Thai"),						MAKELANGID (LANG_THAI,			SUBLANG_DEFAULT)},
{N_("Tsonga"),						MAKELANGID (LANG_TSONGA,		SUBLANG_DEFAULT)},
{N_("Tswana"),						MAKELANGID (LANG_TSWANA,		SUBLANG_DEFAULT)},
{N_("Turkish"),						MAKELANGID (LANG_TURKISH,		SUBLANG_DEFAULT)},
{N_("Ukrainian"),					MAKELANGID (LANG_UKRAINIAN,		SUBLANG_DEFAULT)},
{N_("Urdu"),						MAKELANGID (LANG_URDU,			SUBLANG_URDU_PAKISTAN)},
{N_("Uzbek"),						MAKELANGID (LANG_UZBEK,			SUBLANG_UZBEK)},
{N_("Uzbek (Cyrillic)"),			MAKELANGID (LANG_UZBEK,			SUBLANG_UZBEK_CYRILLIC)},
{N_("Venda"),						MAKELANGID (LANG_VENDA,			SUBLANG_DEFAULT)},
{N_("Vietnamese"),					MAKELANGID (LANG_VIETNAMESE,	SUBLANG_DEFAULT)},
{N_("Xhosa"),						MAKELANGID (LANG_XHOSA,			SUBLANG_DEFAULT)},
{N_("Zulu"),						MAKELANGID (LANG_ZULU,			SUBLANG_DEFAULT)},
{N_("Esperanto"),					MAKELANGID (LANG_ESPERANTO,		SUBLANG_DEFAULT)},
{N_("Walon"),						MAKELANGID (LANG_WALON,			SUBLANG_DEFAULT)},
{N_("Cornish"),						MAKELANGID (LANG_CORNISH,		SUBLANG_DEFAULT)},
{N_("Welsh"),						MAKELANGID (LANG_WELSH,			SUBLANG_DEFAULT)},
{N_("Breton"),						MAKELANGID (LANG_BRETON,		SUBLANG_DEFAULT)}};


/* OKܥ󤬲줿 */
static void
prop_dialog_clicked (GtkWidget *widget, PropertyDialog *prop)
{
	const gchar *text;
	gint i, rate, scale, value;

	if (prop_changed_entry)
	  {
		misc_str_to_float (&rate, &scale,
									gtk_entry_get_text (GTK_ENTRY (entry0)));
		prop->rate = rate;
		prop->scale = scale;
	  }
	if (prop->width > 0 && prop->height > 0 && prop->bit_count != 0)
	  {
		/* ͥ */
		prop->priority0
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin0));
		/*  */
		text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo0)->entry));
		for (i = 0; lang[i].text != NULL; i++)
			if (g_strcmp (gettext (lang[i].text), text) == 0)
			  {
				prop->language0 = lang[i].id;
				break;
			  }
		if (lang[i].text == NULL)
			if (misc_str_to_val (&value, text, 16, FALSE))
				prop->language0 = value;
		/* ̾ */
		text = gtk_entry_get_text (GTK_ENTRY (entry1));
		prop->name0 = text != NULL && text[0] != '\0' ? g_strdup (text) : NULL;
		/* ӥǥ */
		prop->width
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
		prop->height
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
		text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo1)->entry));
		for (i = 0; bit_count[i].text != NULL; i++)
			if (g_strcmp (gettext (bit_count[i].text), text) == 0)
				prop->bit_count = bit_count[i].bit;
		prop->x_pixels_per_meter
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
		prop->y_pixels_per_meter
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin4));
	  }
	if (prop->samples_per_sec != 0 && prop->channels != 0
												&& prop->bits_per_sample != 0)
	  {
		/* ͥ */
		prop->priority1
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin5));
		/*  */
		text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo2)->entry));
		for (i = 0; lang[i].text != NULL; i++)
			if (g_strcmp (gettext (lang[i].text), text) == 0)
			  {
				prop->language1 = lang[i].id;
				break;
			  }
		if (lang[i].text == NULL)
			if (misc_str_to_val (&value, text, 16, FALSE))
				prop->language1 = value;
		/* ̾ */
		text = gtk_entry_get_text (GTK_ENTRY (entry2));
		prop->name1 = text != NULL && text[0] != '\0' ? g_strdup (text) : NULL;
		/* ǥ */
		prop->samples_per_sec
				= gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin6));
		prop->channels = gtk_toggle_button_get_active
										(GTK_TOGGLE_BUTTON (radio0)) ? 1 : 2;
		prop->bits_per_sample = gtk_toggle_button_get_active
										(GTK_TOGGLE_BUTTON (radio2)) ? 8 : 16;
	  }
	gtk_widget_destroy (dialog);
	prop_clicked_ok = TRUE;
}


/* ȥ꡼/ԥܥǥ꥿󤬲줿 */
static void
prop_dialog_activate (GtkWidget *widget, PropertyDialog *prop)
{
	if (GTK_WIDGET_IS_SENSITIVE (button0))
		prop_dialog_clicked (widget, prop);
}


/* 饸ܥѹ줿 */
#define prop_dialog_toggled prop_dialog_changed
/* ܥܥå/ȥ꡼/ԥܥѹ줿 */
static void
prop_dialog_changed (GtkWidget *widget, PropertyDialog *prop)
{
	gboolean result = TRUE;
	const gchar *text;
	gint i, rate, scale, value;

	if (prop->width > 0 && prop->height > 0 && prop->bit_count != 0)
	  {
		text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo0)->entry));
		for (i = 0; lang[i].text != NULL; i++)
			if (g_strcmp (gettext (lang[i].text), text) == 0)
				break;
		if (lang[i].text == NULL)
			if (!misc_str_to_val (&value, text, 16, FALSE))
				result = FALSE;
	  }
	if (result && prop->samples_per_sec!=0 && prop->channels!=0
												&& prop->bits_per_sample!=0)
	  {
		text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo2)->entry));
		for (i = 0; lang[i].text != NULL; i++)
			if (g_strcmp (gettext (lang[i].text), text) == 0)
				break;
		if (lang[i].text == NULL)
			if (!misc_str_to_val (&value, text, 16, FALSE))
				result = FALSE;
	  }
	gtk_widget_set_sensitive (button0, result
		&& misc_str_to_float (&rate, &scale,
									gtk_entry_get_text (GTK_ENTRY (entry0)))
		&& rate > 0
		&& (prop->width <= 0 || prop->height <= 0 || prop->bit_count == 0
			|| (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1)) > 0
			&& gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2)) > 0))
		&& (prop->samples_per_sec == 0 || prop->channels == 0
												|| prop->bits_per_sample == 0
		|| gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin6)) > 0));
}


/* ȥ꡼ѹ줿 */
static void
prop_dialog_changed_entry (GtkWidget *widget, PropertyDialog *prop)
{
	prop_changed_entry = TRUE;
	prop_dialog_changed (widget, prop);
}


/* ESC줿 */
static gboolean
prop_dialog_key_press (GtkWidget *widget, GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval == GDK_Escape)
		gtk_widget_destroy (widget);
	return FALSE;
}


gboolean
property_dialog (PropertyDialog *prop)
{
	gchar *text;
	gint i;
	guint key;
	GList *glist;
	GtkAccelGroup *accel;
	GtkWidget *button1;
	GtkWidget *label0, *label1, *label2, *label3, *label4;
	GtkWidget *label5, *label6, *label7, *label8;
	GtkWidget *frame = NULL, *notebook, *radio1, *radio3, *hbox, *vbox;

	/* ᥤ󥦥ɥ */
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog), _("Property"));
	gtk_signal_connect_after (GTK_OBJECT (dialog), "key-press-event",
								GTK_SIGNAL_FUNC (prop_dialog_key_press), NULL);
	gtk_signal_connect (GTK_OBJECT (dialog), "destroy", gtk_main_quit, NULL);
	/* 졼 */
	accel = gtk_accel_group_new ();
	gtk_window_add_accel_group (GTK_WINDOW (dialog), accel);
	/* ܥ */
	button0 = gtk_button_new_with_label (_("OK"));
	button1 = gtk_button_new_with_label (_("Cancel"));
	gtk_signal_connect (GTK_OBJECT (button0), "clicked",
								GTK_SIGNAL_FUNC (prop_dialog_clicked), prop);
	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
					GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry0 = gtk_entry_new ();
	text = misc_str_from_float (prop->rate, prop->scale);
	gtk_entry_set_text (GTK_ENTRY (entry0), text);
	g_free (text);
	gtk_signal_connect (GTK_OBJECT (entry0), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
	gtk_signal_connect (GTK_OBJECT (entry0), "changed",
							GTK_SIGNAL_FUNC (prop_dialog_changed_entry), prop);
	gtk_editable_select_region (GTK_EDITABLE (entry0), 0, -1);
	/* ٥ */
	label0 = gtk_label_new ("");
	key = gtk_label_parse_uline (GTK_LABEL (label0), _("_Frame per second"));
	gtk_widget_add_accelerator (entry0, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);

	/* Ρȥ֥å/ե졼 */
	if (prop->width > 0 && prop->height > 0 && prop->bit_count != 0
						&& prop->samples_per_sec != 0 && prop->channels != 0
												&& prop->bits_per_sample != 0)
	  {
		notebook = gtk_notebook_new ();
		gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
	  }
	else
	  {
		notebook = NULL;
	  }
	if (prop->width > 0 && prop->height > 0 && prop->bit_count != 0)
	  {
		/* ܥܥå */
		glist = NULL;
		for (i = 3; lang[i].text != NULL; i++)
			glist = g_list_insert_sorted (glist,
					(gpointer)gettext (lang[i].text), (GCompareFunc)strcmp);
		for (i = 2; i >= 0; i--)
			glist = g_list_prepend (glist, (gpointer)gettext (lang[i].text));
		combo0 = gtk_combo_new ();
		gtk_combo_set_popdown_strings (GTK_COMBO (combo0), glist);
		gtk_combo_set_value_in_list (GTK_COMBO (combo0), FALSE, FALSE);
		for (i = 0; lang[i].text != NULL; i++)
			if (lang[i].id == prop->language0)
			  {
				gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo0)->entry),
													gettext (lang[i].text));
				break;
			  }
		if (lang[i].text == NULL)
		  {
			text = g_strdup_printf ("%X", prop->language0);
			gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo0)->entry), text);
			g_free (text);
		  }
		gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo0)->entry), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ܥܥå */
		glist = NULL;
		for (i = 0; bit_count[i].text != NULL; i++)
			glist = g_list_append (glist,
										(gpointer)gettext (bit_count[i].text));
		combo1 = gtk_combo_new ();
		gtk_combo_set_popdown_strings (GTK_COMBO (combo1), glist);
		gtk_combo_set_value_in_list (GTK_COMBO (combo1), TRUE, FALSE);
		gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo1)->entry),
																		FALSE);
		for (i = 0; bit_count[i].text != NULL; i++)
			if (bit_count[i].bit == prop->bit_count)
				gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(combo1)->entry),
												gettext (bit_count[i].text));
		gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo1)->entry), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ȥ꡼ */
		entry1 = gtk_entry_new ();
		if (prop->name0 != NULL)
			gtk_entry_set_text (GTK_ENTRY (entry1), prop->name0);
		gtk_signal_connect (GTK_OBJECT (entry1), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (entry1), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ԥܥ */
		spin0 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
							(prop->priority0, 0, G_MAXSHORT, 1, 5, 0)), 0, 0);
		spin1 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
								(prop->width, 1, G_MAXINT, 1, 5, 0)), 0, 0);
		spin2 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
								(prop->height, 1, G_MAXINT, 1, 5, 0)), 0, 0);
		spin3 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
					(prop->y_pixels_per_meter, 0, G_MAXINT, 1, 5, 0)), 0, 0);
		spin4 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
					(prop->y_pixels_per_meter, 0, G_MAXINT, 1, 5, 0)), 0, 0);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin0), TRUE);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), TRUE);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), TRUE);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), TRUE);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin4), TRUE);
#ifndef USE_GTK2
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin0),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin1),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin2),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin3),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin4),
																GTK_SHADOW_IN);
#endif
		gtk_signal_connect (GTK_OBJECT (spin0), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin1), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin2), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin3), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin4), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin0), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		gtk_signal_connect (GTK_OBJECT (spin1), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		gtk_signal_connect (GTK_OBJECT (spin2), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		gtk_signal_connect (GTK_OBJECT (spin3), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		gtk_signal_connect (GTK_OBJECT (spin4), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ٥ */
		label1 = gtk_label_new ("");
		label2 = gtk_label_new ("");
		label3 = gtk_label_new ("");
		label4 = gtk_label_new ("");
		label5 = gtk_label_new ("");
		label6 = gtk_label_new ("");
		label7 = gtk_label_new ("");
		label8 = gtk_label_new ("");
		key = gtk_label_parse_uline (GTK_LABEL (label1), _("_Name"));
		gtk_widget_add_accelerator (entry1, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label2), _("_Priority"));
		gtk_widget_add_accelerator (spin0, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label3), _("_Language"));
		gtk_widget_add_accelerator (GTK_COMBO (combo0)->entry, "grab-focus",
												accel, key, GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label4), _("_Width"));
		gtk_widget_add_accelerator (spin1, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label5), _("_Height"));
		gtk_widget_add_accelerator (spin2, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label6), _("_Color"));
		gtk_widget_add_accelerator (combo1, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label7),
													_("_X pixels per meter"));
		gtk_widget_add_accelerator (spin3, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key=gtk_label_parse_uline (GTK_LABEL (label8),
													_("_Y pixels per meter"));
		gtk_widget_add_accelerator (spin4, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);

		/* ե졼ȥܥå */
		vbox = gtk_vbox_new (FALSE, 8);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), entry1, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin0, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label3, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), combo0, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label4, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin1, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label5, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin2, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label6, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), combo1, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label7, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin3, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label8, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin4, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		if (notebook != NULL)
		  {
			gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
												gtk_label_new (_("Video")));
		  }
		else
		  {
			frame = gtk_frame_new (_("Video"));
			gtk_container_add (GTK_CONTAINER (frame), vbox);
		  }
	  }

	if (prop->samples_per_sec != 0 && prop->channels != 0
												&& prop->bits_per_sample != 0)
	  {
		/* ܥܥå */
		glist = NULL;
		for (i = 3; lang[i].text != NULL; i++)
			glist = g_list_insert_sorted (glist,
					(gpointer)gettext (lang[i].text), (GCompareFunc)strcmp);
		for (i = 2; i >= 0; i--)
			glist = g_list_prepend (glist, (gpointer)gettext (lang[i].text));
		combo2 = gtk_combo_new ();
		gtk_combo_set_popdown_strings (GTK_COMBO (combo2), glist);
		gtk_combo_set_value_in_list (GTK_COMBO (combo2), FALSE, FALSE);
		for (i = 0; lang[i].text != NULL; i++)
			if (lang[i].id == prop->language1)
			  {
				gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo2)->entry),
													gettext (lang[i].text));
				break;
			  }
		if (lang[i].text == NULL)
		  {
			text = g_strdup_printf ("%X", prop->language1);
			gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo2)->entry), text);
			g_free (text);
		  }
		gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo2)->entry), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ȥ꡼ */
		entry2 = gtk_entry_new ();
		if (prop->name1 != NULL)
			gtk_entry_set_text (GTK_ENTRY (entry2), prop->name1);
		gtk_signal_connect (GTK_OBJECT (entry2), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (entry2), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ԥܥ */
		spin5 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
							(prop->priority1, 0, G_MAXSHORT, 1, 5, 0)), 0, 0);
		spin6 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
						(prop->samples_per_sec, 1, G_MAXINT, 1, 5, 0)), 0, 0);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin5), TRUE);
		gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin6), TRUE);
#ifndef USE_GTK2
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin5),
																GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (spin6),
																GTK_SHADOW_IN);
#endif
		gtk_signal_connect (GTK_OBJECT (spin5), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin6), "activate",
								GTK_SIGNAL_FUNC (prop_dialog_activate), prop);
		gtk_signal_connect (GTK_OBJECT (spin5), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		gtk_signal_connect (GTK_OBJECT (spin6), "changed",
								GTK_SIGNAL_FUNC (prop_dialog_changed), prop);
		/* ٥ */
		label1 = gtk_label_new ("");
		label2 = gtk_label_new ("");
		label3 = gtk_label_new ("");
		label4 = gtk_label_new ("");
		key = gtk_label_parse_uline (GTK_LABEL (label1), _("_Name"));
		gtk_widget_add_accelerator (entry2, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label2), _("_Priority"));
		gtk_widget_add_accelerator (spin5, "grab-focus", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label3), _("_Language"));
		gtk_widget_add_accelerator (GTK_COMBO (combo2)->entry, "grab-focus",
												accel, key, GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (label4), _("_Rate"));
		gtk_widget_add_accelerator (spin6, "grab-focus", accel,key,
															GDK_MOD1_MASK, 0);
		/* 饸ܥ */
		radio0 = gtk_radio_button_new_with_label (NULL, "");
		radio1 = gtk_radio_button_new_with_label_from_widget
											(GTK_RADIO_BUTTON (radio0), "");
		radio2 = gtk_radio_button_new_with_label (NULL, "");
		radio3 = gtk_radio_button_new_with_label_from_widget
											(GTK_RADIO_BUTTON (radio2), "");
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio0)->child),
															_("_Monophone"));
		gtk_widget_add_accelerator (radio0, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio1)->child),
																_("_Stereo"));
		gtk_widget_add_accelerator (radio1, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio2)->child),
																_("_8 bits"));
		gtk_widget_add_accelerator (radio2, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
		key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio3)->child),
																_("_16 bits"));
		gtk_widget_add_accelerator (radio3, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
								(prop->channels == 1 ? radio0 : radio1), TRUE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
						(prop->bits_per_sample == 8 ? radio2 : radio3), TRUE);
		gtk_signal_connect (GTK_OBJECT (radio0), "toggled",
								GTK_SIGNAL_FUNC (prop_dialog_toggled), prop);
		gtk_signal_connect (GTK_OBJECT (radio1), "toggled",
								GTK_SIGNAL_FUNC (prop_dialog_toggled), prop);
		gtk_signal_connect (GTK_OBJECT (radio2), "toggled",
								GTK_SIGNAL_FUNC (prop_dialog_toggled), prop);
		gtk_signal_connect (GTK_OBJECT (radio3), "toggled",
								GTK_SIGNAL_FUNC (prop_dialog_toggled), prop);
		/* ե졼ȥܥå */
		vbox = gtk_vbox_new (FALSE, 8);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), entry2, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin5, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), label3, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), combo2, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE,0);
		gtk_box_pack_start (GTK_BOX (hbox), label4, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), spin6, TRUE, TRUE, 0);
		gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

		hbox = gtk_hbox_new (FALSE, 8);
		gtk_container_set_border_width (GTK_CONTAINER (hbox), 8);
		gtk_box_pack_start (GTK_BOX (hbox), radio0, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), radio1, FALSE, FALSE, 0);
		frame = gtk_frame_new (_("Channel"));
		gtk_container_add (GTK_CONTAINER (frame), hbox);
		gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
		/* ɽ */
		gtk_widget_set_sensitive (frame, FALSE);

		hbox = gtk_hbox_new (FALSE, 8);
		gtk_container_set_border_width (GTK_CONTAINER (hbox), 8);
		gtk_box_pack_start (GTK_BOX (hbox), radio2, FALSE, FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), radio3, FALSE, FALSE, 0);
		frame = gtk_frame_new (_("Bit"));
		gtk_container_add (GTK_CONTAINER (frame), hbox);
		gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
		/* ɽ */
		gtk_widget_set_sensitive (frame, FALSE);

		if (notebook != NULL)
		  {
			gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
												gtk_label_new (_("Audio")));
		  }
		else
		  {
			frame = gtk_frame_new (_("Audio"));
			gtk_container_add (GTK_CONTAINER (frame), vbox);
		  }
		/* ɽ */
		gtk_widget_set_sensitive (label4, FALSE);
		gtk_widget_set_sensitive (spin6, FALSE);
	}

	/* ե졼ȥܥå */
	vbox = gtk_vbox_new (FALSE, 8);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), label0, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), entry0, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (vbox),
						notebook != NULL ? notebook : frame, TRUE, TRUE, 0);

	hbox = gtk_hbox_new (FALSE, 8);
	gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (dialog), vbox);

	/* ɽ */
	gtk_widget_set_sensitive (button0, FALSE);
	gtk_widget_grab_focus (entry0);
	prop_clicked_ok = FALSE;
	prop_changed_entry = FALSE;

	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
	gtk_grab_add (dialog);
	gtk_widget_show_all (dialog);
	gtk_main ();

	return prop_clicked_ok;
}
