/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "argument.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "sigfile.h"
#include "sigmain.h"
#include "thread.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data)
{
	gint i,ascent,height;
	GList *glist;
	VmaidWindow *vmaid;

	/* ƥ࿧ */
	style=gtk_widget_get_style(widget);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->fg[3];
	system_color[3]=style->bg[3];
	if (system_font!=NULL)
		gdk_font_unref(system_font);
	/* ƥե */
	system_font=gdk_font_ref(gtk_style_get_font(style));
	for (i=0;i<256;i++) {
		gdk_text_extents(system_font,(gchar *)&i,1,
												NULL,NULL,NULL,&ascent,NULL);
		if (system_font_ascent<ascent)
			system_font_ascent=ascent;
		height=gdk_char_height(system_font,(gchar)i);
		if (system_font_height<height)
			system_font_height=height;
	}
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	for (i=g_list_length(glist)-1;i>=0;i--) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
		gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,
						system_font_height*2+((vmaid->avi_edit[0]!=NULL?1:0)
							+(vmaid->avi_edit[1]!=NULL?1:0))*vmaid->height);
		gtk_widget_queue_resize (GTK_WIDGET (window));
		gtk_widget_draw(vmaid->drawing,NULL);
	}
	g_list_free(glist);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(˥塼)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child)
{
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
	gtk_widget_grab_focus(
		((VmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child)))->drawing);
}


void signal_activate_menu_history(GtkWidget *widget,gchar *file)
{
#ifndef USE_GTK2
	pthread_t id;
#endif
	FileOpen *file_open;

	file_open=g_malloc(sizeof(FileOpen));
	file_open->file=g_strdup(file);
	file_open->merge=file_merge;
#ifdef USE_GTK2
	g_thread_create((GThreadFunc)file_open_edit,file_open,TRUE,NULL);
#else
	pthread_create(&id,NULL,(void *)file_open_edit,file_open);
	pthread_detach(id);
#endif
}


void signal_destroy_menu_history(GtkWidget *widget,gchar *file)
{
	g_free(file);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(Ρ)                                             *
*                                                                             *
******************************************************************************/
void signal_clicked(GtkWidget *widget,GtkWidget *child)
{
	if (prompt_close(
				(VmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child))))
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
}


void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data)
{
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(
					GTK_OBJECT(gtk_notebook_get_nth_page(notebook,page_num)));
	/* ˥塼ɽ */
	set_menu_bar(vmaid);
}


void signal_destroy_notebook(GtkWidget *widget,gpointer user_data)
{
	gtk_timeout_remove(timer_id);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ꥹ)                                             *
*                                                                             *
******************************************************************************/
#ifdef USE_GTK2
static void
signal_tree_selection_foreach (GtkTreeModel *model, GtkTreePath *path,
										GtkTreeIter *iter, gpointer user_data)
{
	(* (gint *)user_data) ++;
}


void
signal_changed (GtkTreeSelection *select, gpointer user_data)
{
	gint count;

	gtk_tree_selection_selected_foreach (select, signal_tree_selection_foreach,
																	&count);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU (
			gtk_item_factory_get_widget (item_factory_menu, "<main>/Task"))),
																	count > 0);
}


#else /* not USE_GTK2 */
void signal_select_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data)
{
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
		gtk_item_factory_get_widget(item_factory_menu,"<main>/Task"))),TRUE);
}


void signal_unselect_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data)
{
	gint i;

	for (i=0;i<GTK_CLIST(clist)->rows;i++)
		if (((GtkCListRow *)
					(g_list_nth(GTK_CLIST(clist)->row_list,i)->data))->state
														==GTK_STATE_SELECTED)
			break;
	if (i==GTK_CLIST(clist)->rows)
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
													"<main>/Task"))),FALSE);
}


gboolean signal_button_press_clist(GtkWidget *widget,GdkEventButton *event,
															gpointer user_data)
{
	gint row,column;

	if (event->type==GDK_BUTTON_PRESS && event->button==3
			&& gtk_clist_get_selection_info(GTK_CLIST(clist),
								(gint)event->x,(gint)event->y,&row,&column)) {
		/* å */
		gtk_clist_unselect_all(GTK_CLIST(clist));
		gtk_clist_select_row(GTK_CLIST(clist),row,column);
		gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_clist,"<main>")),
								NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	return FALSE;
}
#endif /* not USE_GTK2 */


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(쥯)                                       *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time)
{
	gchar **files;
	gint i;
	FileOpen *file_open;
#ifdef USE_GTK2
	gchar *file;
#else /* not USE_GTK2 */
	pthread_t id;
#endif /* not USE_GTK2 */

	files = g_strsplit (selection_data->data, "\r\n", G_MAXINT);
	for (i = 0; files[i] != NULL; i++)
	  {
#ifdef USE_GTK2
		file = g_filename_from_uri (files[i], NULL, NULL);
		if (file != NULL)
#else /* not USE_GTK2 */
		if (g_strncmp (files[i], "file:", 5) == 0)
#endif /* not USE_GTK2 */
		  {
			file_open = g_malloc (sizeof (FileOpen));
#ifdef USE_GTK2
			file_open->file = file;
#else /* not USE_GTK2 */
			file_open->file = g_strdup (files[i] + 5);
#endif /* not USE_GTK2 */
			file_open->merge = file_merge;
#ifdef USE_GTK2
			g_thread_create ((GThreadFunc)file_open_edit,
														file_open, TRUE, NULL);
#else /* not USE_GTK2 */
			pthread_create (&id, NULL, (void *)file_open_edit, file_open);
			pthread_detach (id);
#endif /* not USE_GTK2 */
		  }
	  }
	g_strfreev (files);
}


gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
															gpointer user_data)
{
	if (event->selection==atom_clipboard) {
		/* åץܡ */
		g_free(clipboard_scenario);
		clipboard_scenario=NULL;
	}
	return TRUE;
}


void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,gpointer user_data)
{
	gchar *text;

	if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (clipboard_scenario!=NULL && info==TARGET_VMAID)
			gtk_selection_data_set(data,atom_scenario,8,
					(guchar *)clipboard_scenario,g_strlen(clipboard_scenario));
	} else if (data->selection==atom_videomaid0) {
		/* ץ̿ */
		text="Video maid Selection";
		gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,8,
												(guchar *)text,g_strlen(text));
		gtk_selection_convert(window,atom_videomaid1,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
	} else if (data->selection==atom_videomaid1 && arg_text!=NULL) {
		/* ץ̿ */
		gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,8,
										(guchar *)arg_text,g_strlen(arg_text));
		g_free(arg_text);
		arg_text=NULL;
	}
}


void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data)
{
	gboolean result=TRUE,paste[2],*arg_files;
	gchar **argv;
	gint i,count,max,sx;
#ifndef USE_GTK2
	pthread_t id;
#endif
	AviEdit **avi_edit;
	FileOpen *file_open;
	GdkAtom *atoms;
	VmaidWindow *vmaid;
	VmaidHistory *d;

	if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (data->length>=0) {
			if (data->type==GDK_SELECTION_TYPE_ATOM) {
				atoms=(GdkAtom *)data->data;
				count=data->length/sizeof(GdkAtom);
				for (i=0;i<count;i++)
					if (atoms[i]==atom_scenario)
						break;
				if (i<count)
					gtk_selection_convert(widget,data->selection,atoms[i],
															GDK_CURRENT_TIME);
			} else if (data->type==atom_scenario) {
				/* Žդ */
				if ((avi_edit=avi_from_scenario(data->data))==NULL)
					return;
				vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
				if (vmaid->select.stream<0) {
					/* ϰϤʤȤUNDOν */
					d=g_malloc(sizeof(VmaidHistory));
					for (i=0;i<2;i++) {
						d->avi_edit[i]=NULL;
						if (vmaid->avi_edit[i]!=NULL
								&& (d->avi_edit[i]
										=avi_clone(vmaid->avi_edit[i]))==NULL)
							result=FALSE;
					}
					if (!result) {
						misc_message_box("Video maid",_("AVI Clone Error"),0,
																_("OK"),NULL);
						for (i=0;i<2;i++)
							if (d->avi_edit[i]!=NULL)
								avi_release(d->avi_edit[i]);
						g_free(d);
						for (i=0;avi_edit[i]!=NULL;i++)
							avi_release(avi_edit[i]);
						g_free(avi_edit);
						return;
					}
					d->cursor=vmaid->cursor;
					d->select=vmaid->select;
				} else {
					/* ϰϤФ */
					d=vmaid->redo;
					vmaid->redo=NULL;
					command_delete(NULL,0,widget);
					vmaid->redo=d;
				}
				paste[0]=paste[1]=FALSE;
				for (i=0;avi_edit[i]!=NULL;i++)
					switch (avi_type(avi_edit[i])) {
						case streamtypeVIDEO:
							if (paste[0]) {
								avi_release(avi_edit[i]);
							} else {
								if (vmaid->avi_edit[0]==NULL) {
									vmaid->avi_edit[0]=avi_edit[i];
								} else if (!avi_paste(vmaid->avi_edit[0],
										MIN(vmaid->cursor.frame,
											avi_length(vmaid->avi_edit[0])),
																avi_edit[i])) {
									avi_release(avi_edit[i]);
									result=FALSE;
								}
								paste[0]=TRUE;
							}
							break;
						case streamtypeAUDIO:
							if (paste[1]) {
								avi_release(avi_edit[i]);
							} else {
								if (vmaid->avi_edit[1]==NULL) {
									vmaid->avi_edit[1]=avi_edit[i];
								} else if (!avi_paste(vmaid->avi_edit[1],
									MIN(avi_time_to_sample(vmaid->avi_edit[1],
											(gint64)vmaid->cursor.frame*1000
													*vmaid->scale/vmaid->rate),
										avi_length(vmaid->avi_edit[0])),
																avi_edit[i])) {
									avi_release(avi_edit[i]);
									result=FALSE;
								}
								paste[1]=TRUE;
							}
							break;
						default:
							avi_release(avi_edit[i]);
							result=FALSE;
					}
				g_free(avi_edit);
				if (!result || (!paste[0] && !paste[1])) {
					misc_message_box("Video maid",_("AVI Paste Error"),0,
																_("OK"),NULL);
					for (i=0;i<2;i++)
						if (vmaid->avi_edit[i]!=NULL)
							avi_release(vmaid->avi_edit[i]);
					d=vmaid->undo;
					vmaid->undo=vmaid->undo->next;
					for (i=0;i<2;i++)
						vmaid->avi_edit[i]=d->avi_edit[i];
					g_free(d);
					return;
				}
				if (vmaid->avi_edit[0]!=NULL) {
					vmaid->rate=avi_get_rate(vmaid->avi_edit[0]);
					vmaid->scale=avi_get_scale(vmaid->avi_edit[0]);
				}
				max=get_max_frame(vmaid,-1)+1;
				sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
				if (vmaid->avi_edit[0]!=NULL && vmaid->avi_edit[1]==NULL)
					vmaid->cursor.stream=0;
				else if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]!=NULL)
					vmaid->cursor.stream=1;
				if (vmaid->cursor.frame>max)
					vmaid->cursor.frame=max;
				if (vmaid->top>vmaid->cursor.frame)
					vmaid->top=vmaid->cursor.frame;
				else if (vmaid->top<vmaid->cursor.frame-sx)
					vmaid->top=MAX(vmaid->cursor.frame-sx,0);
				/* ˥塼,ơȥ,ҥɥ */
				set_menu_bar(vmaid);
				gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,
						system_font_height*2+((vmaid->avi_edit[0]!=NULL?1:0)
							+(vmaid->avi_edit[1]!=NULL?1:0))*vmaid->height);
				gtk_widget_queue_resize (GTK_WIDGET (window));
				gtk_widget_draw(vmaid->drawing,NULL);
				draw_caret(vmaid,NULL);
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
				vmaid_change_edit (vmaid, TRUE);
			}
		}
	} else if (data->selection==atom_videomaid0) {
		/* ץ̿ */
		instance=MAX(data->length,0);
	} else if (data->selection==atom_videomaid1 && data->length>0) {
		/* ץ̿ */
		/* ޥɥ饤β */
		argv=g_strsplit(data->data,"\n",G_MAXINT);
		arg_files=arg_analyse(argv,FALSE);
		for (i = 1; argv[i] != NULL; i++)
			if (arg_files[i]) {
				file_open=g_malloc(sizeof(FileOpen));
				file_open->file=g_strdup(argv[i]);
				file_open->merge=file_merge;
#ifdef USE_GTK2
				g_thread_create((GThreadFunc)file_open_edit,
														file_open,TRUE,NULL);
#else
				pthread_create(&id,NULL,(void *)file_open_edit,file_open);
				pthread_detach(id);
#endif
			}
		g_free(arg_files);
		g_strfreev(argv);
	}
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ᥤ)                                             *
*                                                                             *
******************************************************************************/
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data)
{
	gint page;
#ifndef USE_GTK2
	pthread_t id;
#endif
	VmaidWindow *vmaid;

	while ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (!prompt_close(vmaid))
			return TRUE;
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
#ifdef USE_GTK2
	g_thread_create((GThreadFunc)close_program,NULL,TRUE,NULL);
#else
	pthread_create(&id,NULL,(void *)close_program,NULL);
	pthread_detach(id);
#endif
	return TRUE;
}


void signal_destroy_window(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GList *glist;
	GtkWidget *menu_shell;

	g_memset(history_files,0,sizeof(gchar *)*10);
	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
																"<main>/File");
	glist = gtk_container_children (GTK_CONTAINER (menu_shell));
	for (i=0;i<(gint)g_list_length(glist)-MENUFILE-1;i++)
		history_files[i]=g_strdup(gtk_object_get_user_data(
							GTK_OBJECT(g_list_nth_data(glist,i+MENUFILE-1))));
	g_list_free(glist);
	gtk_main_quit();
}
