/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "vmaid.h"
#include <gdk/gdkrgb.h>
#include <locale.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "argument.h"
#include "command.h"
#include "conf.h"
#include "file.h"
#include "general.h"
#include "sigfile.h"
#include "sigmain.h"
#include "thread.h"
#include "toolbar.h"
#include "version.h"
#include "misc/misc.h"
#include "misc/profile.h"


gboolean caret=FALSE;				/* åȤη */
gboolean newfile=FALSE;				/* TRUE:ե,FALSE:ʤ */
gboolean second=FALSE;				/* TRUE:,FALSE:¸ */
gboolean default_ratio=FALSE;		/* TRUE:/Ψݻʤ */
gboolean file_merge=FALSE;			/* TRUE:Ϣ,FALSE:ñ */
gchar *history_files[10];			/* ե */
gchar *open_path=NULL;				/* Υѥ */
gchar *save_path=NULL;				/* ̾դ¸Υѥ */
gchar *clipboard_scenario=NULL;		/* åץܡɤΥƥ */
gchar *arg_text=NULL;				/* ץ̿ѿ */
gint def_width,def_height;			/* ǥեȤΥɥΥ */
gint history=4;						/* ե */
gint instance=-1;					/* ץ̿ѿ */
gint default_view=6;				/* ɥν */
guint default_rate=15;				/* ɥν */
guint timer_id=0;					/* ID */
GdkAtom atom_clipboard;				/* åץܡ */
GdkAtom atom_targets;				/* å */
GdkAtom atom_scenario;				/* ʥꥪ֥ */
GdkAtom atom_videomaid0;			/* ץ̿ѥȥ */
GdkAtom atom_videomaid1;			/* ץ̿ѥȥ */
GdkBitmap *bitmap0;					/* ط */
GdkBitmap *bitmap1;					/* ط */
GtkWidget *window;					/* ɥ */
GtkWidget *notebook;				/* Ρȥ֥å */
GtkWidget *clist;					/* ꥹȥܥå */
GtkWidget *status;					/* ơɥ */
GtkPositionType n_pos=GTK_POS_TOP;	/* Ρȥ֥åΰ */
GtkItemFactory *item_factory_menu;	/* ˥塼 */
GtkItemFactory *item_factory_popup;	/* ݥåץå */
GtkItemFactory *item_factory_clist;	/* ݥåץå */
GdkFont *system_font=NULL;
gint system_font_height;			/* եȤι⤵ */
gint system_font_ascent;			/* եȤΥȤι⤵ */
#ifdef USE_GTK2
GtkListStore *list_store;			/* ꥹ */
#endif /* USE_GTK2 */
GdkColor system_color[4]={	{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
							{0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000}};
GtkTargetEntry targets_vmaid[]={	/* Video maid󶡲ǽʥ쥯 */
	{"Video maid Scenario Object",0,TARGET_VMAID}};
GtkTargetEntry targets_comm[]={		/* Video maid󶡲ǽʥ쥯 */
	{"STRING",0,TARGET_STRING}};


/******************************************************************************
*                                                                             *
* ᥤؿ                                                                  *
*                                                                             *
******************************************************************************/
static gchar *
menu_translate(const gchar *path,gpointer func_data)
{
   return (gchar *)gettext (path);
}


int main(int argc,char *argv[])
{
	gboolean *arg_files;
	gchar *arg,*key;
	gint i,count=0,ascent,height,leng,length=0;
	FileOpen *file_open;
	Profile *profile;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkAccelGroup *accel_group;
	GtkStyle *style;
	GtkWidget *toolbar,*text,*handle,*scroll,*vbox;
	GtkWidget *menu_bar, *menu_shell, *menu_item;
#ifdef USE_GTK2
	GtkTreeSelection *select;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;
#else /* not USE_GTK2 */
	pthread_t id;
#endif /* not USE_GTK2 */
	gchar *title[4]={N_("Mode"),N_("File"),N_("Time"),N_("Status")};
	GtkItemFactoryEntry menu_items[]={
{N_("/_File"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/File/_New"),               "<control>N", command_new,     0,"<Item>"},
{N_("/File/_Open..."),           "<control>O", command_open,    0,"<Item>"},
{N_("/File/_Close"),             "<control>W", command_close,   0,"<Item>"},
{N_("/File/Save _As..."),        "<control>S", command_save,    0,"<Item>"},
{N_("/File/Sep1"),               NULL,         NULL,            0,"<Separator>"},
{N_("/File/Pre_view..."),        "<control>P", NULL,            0,"<Item>"},
{N_("/File/Propert_ies..."),     "<alt>Return",command_property,0,"<Item>"},
{N_("/File/Sep2"),               NULL,         NULL,            0,"<Separator>"},
{N_("/File/E_xit"),              "<control>Q", command_exit,    0,"<Item>"},
{N_("/_Edit"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Edit/_Undo"),              "<control>Z", command_undo,    0,"<Item>"},
{N_("/Edit/_Redo"),              "F4",         command_redo,    0,"<Item>"},
{N_("/Edit/Sep1"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/Cu_t"),               "<control>X", command_cut,     0,"<Item>"},
{N_("/Edit/_Copy"),              "<control>C", command_copy,    0,"<Item>"},
{N_("/Edit/_Paste"),             "<control>V", command_paste,   0,"<Item>"},
{N_("/Edit/De_lete"),            NULL,         command_delete,  0,"<Item>"},
{N_("/Edit/Sep2"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_Merge..."),          "<control>M", NULL,            0,"<Item>"},
{N_("/Edit/_Jump..."),           "<control>J", command_jump,    0,"<Item>"},
{N_("/Edit/Sep3"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_All"),               "<control>A", command_all,     0,"<Item>"},
{N_("/_View"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/View/S_ize..."),           NULL,         command_size,    0,"<Item>"},
{N_("/_Option"),                 NULL,         NULL,            0,"<Branch>"},
{N_("/Option/_Configuration..."),NULL,         conf_dialog,     0,"<Item>"},
{N_("/_Task"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Task/_Cancel"),            NULL,         command_cancel,  0,"<Item>"},
{N_("/_Window"),                 NULL,         NULL,            0,"<Branch>"},
{N_("/_Help"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Help/_About..."),          NULL,         version_dialog,  0,"<Item>"}};
	GtkItemFactoryEntry popup_items[]={
{N_("/_Undo"),                   "<control>Z", NULL,            0,"<Item>"},
{"/Sep1",                        NULL,         NULL,            0,"<Separator>"},
{N_("/Cu_t"),                    "<control>X", NULL,            0,"<Item>"},
{N_("/_Copy"),                   "<control>C", NULL,            0,"<Item>"},
{N_("/_Paste"),                  "<control>V", NULL,            0,"<Item>"},
{N_("/De_lete"),                 NULL,         NULL,            0,"<Item>"},
{"/Sep2",                        NULL,         NULL,            0,"<Separator>"},
{N_("/_All"),                    "<control>A", NULL,            0,"<Item>"}};
	GtkItemFactoryEntry clist_items[]={
{N_("/_Cancel"),                 NULL,         command_cancel,  0,"<Item>"}};
	/* Drag&Drop */
	GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};
	static gchar *xpm0[]={
"4 8 2 1",
" 	c None",
".	c #000000",
".   ",
".   ",
"   .",
"   .",
"  . ",
"  . ",
" .  ",
" .  "};
	static gchar *xpm1[]={
"2 2 2 1",
" 	c None",
".	c #000000",
". ",
" ."};


	/*  */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
#ifdef USE_GTK2
	bind_textdomain_codeset(PACKAGE,"UTF-8");
#endif
	textdomain(PACKAGE);
	g_thread_init(NULL);
#ifdef USE_GTK2
	gdk_threads_init();
#endif
	gtk_set_locale();
	gtk_init(&argc,&argv);
	gdk_rgb_init();
	avi_init();
	g_atexit((GVoidFunc)avi_exit);

	def_width=gdk_screen_width()*2/3;
	def_height=gdk_screen_height()*2/3;
	g_memset(history_files,0,sizeof(gchar *)*10);
	/* 쥸ȥ꤫ɤ߽Ф */
	if ((profile=profile_open(NULL))!=NULL) {
		if (!profile_get_value(profile,"vmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			history=4;
		if (!profile_get_value(profile,"vmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			newfile=FALSE;
		if (!profile_get_value(profile,"vmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			second=FALSE;
		if (!profile_get_value(profile,"vmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_width=gdk_screen_width()*2/3;
		if (!profile_get_value(profile,"vmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_height=gdk_screen_height()*2/3;
		if (!profile_get_value(profile,"vmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			n_pos=GTK_POS_TOP;
		if (!profile_get_value(profile,"vmaid","ratio",
				(gpointer)&default_ratio,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			default_ratio=FALSE;
		if (!profile_get_value(profile,"vmaid","merge",
				(gpointer)&file_merge,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			file_merge=FALSE;
		if (!profile_get_value(profile,"vmaid","view",
				(gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			default_view=6;
		if (!profile_get_value(profile,"vmaid","rate",
				(gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT))
			default_rate=15;
		open_path=profile_get_string(profile,"vmaid","openpath");
		save_path=profile_get_string(profile,"vmaid","savepath");
		/* ե */
		for (i=0;i<history;i++) {
			key=g_strdup_printf("history%d",i);
			history_files[i]=profile_get_string(profile,"vmaid",key);
			g_free(key);
			if (history_files[i]==NULL)
				break;
			if (*history_files[i]=='\0') {
				g_free(history_files[i]);
				history_files[i]=NULL;
				break;
			}
		}
		profile_close(profile);
	}

	/* ޥɥ饤β */
	if ((arg_files=arg_analyse(argv,TRUE))==NULL)
		gtk_exit(0);

	/* ᥤ󥦥ɥ */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),"Video maid");
	gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
	gtk_signal_connect(GTK_OBJECT(window),"delete-event",
										GTK_SIGNAL_FUNC(signal_delete),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_window),NULL);
	gtk_widget_realize(window);
	/* Drag and Drop */
	gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
						| GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
												drag_types,1,GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(window),"drag-data-received",
							GTK_SIGNAL_FUNC(signal_drag_data_received),NULL);
	/* åץܡ/ץ̿ */
	atom_clipboard=gdk_atom_intern("CLIPBOARD",FALSE);
	atom_targets=gdk_atom_intern("TARGETS",FALSE);
	atom_scenario=gdk_atom_intern("Video maid Scenario Object",FALSE);
	atom_videomaid0=gdk_atom_intern("Video maid InterProcess communication 0",
																		FALSE);
	atom_videomaid1=gdk_atom_intern("Video maid InterProcess communication 1",
																		FALSE);
	gtk_selection_add_targets(window,atom_clipboard,
				targets_vmaid,sizeof(targets_vmaid)/sizeof(GtkTargetEntry));
	if (!second) {
		gtk_selection_add_targets(window,atom_videomaid0,targets_comm,1);
		gtk_selection_add_targets(window,atom_videomaid1,targets_comm,1);
	}
	gtk_signal_connect(GTK_OBJECT(window),"selection-clear-event",
								GTK_SIGNAL_FUNC(signal_selection_clear),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-get",
								GTK_SIGNAL_FUNC(signal_selection_get),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-received",
							GTK_SIGNAL_FUNC(signal_selection_received),NULL);
	/* Ρȥ֥å */
	notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
	gtk_signal_connect(GTK_OBJECT(notebook),"switch-page",
								GTK_SIGNAL_FUNC(signal_switch_page),NULL);
	gtk_signal_connect(GTK_OBJECT(notebook),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_notebook),NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_popup=gtk_item_factory_new(GTK_TYPE_MENU,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_popup,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_popup,
			sizeof(popup_items)/sizeof(GtkItemFactoryEntry),popup_items,NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_clist=gtk_item_factory_new(GTK_TYPE_MENU,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_clist,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_clist,
			sizeof(clist_items)/sizeof(GtkItemFactoryEntry),clist_items,NULL);
	/* ˥塼 */
	accel_group=gtk_accel_group_new();
	item_factory_menu=gtk_item_factory_new(GTK_TYPE_MENU_BAR,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_menu,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_menu,
			sizeof(menu_items)/sizeof(GtkItemFactoryEntry),menu_items,NULL);
	gtk_window_add_accel_group(GTK_WINDOW(window),accel_group);
	menu_bar = gtk_item_factory_get_widget (item_factory_menu, "<main>");
	/* ġС */
#ifdef USE_GTK2
	toolbar=gtk_toolbar_new();
	gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar),
												GTK_ORIENTATION_HORIZONTAL);
	gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_ICONS);
#else
	toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
#endif
	for (i=0;toolbar_items[i].name!=(gpointer)-1;i++)
		if (toolbar_items[i].name==NULL) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			pixmap=gdk_pixmap_create_from_xpm_d(window->window,
											&mask,NULL,toolbar_items[i].xpm);
			toolbar_items[i].item = gtk_toolbar_append_item
						(GTK_TOOLBAR(toolbar),
						NULL, _(toolbar_items[i].name), NULL,
						gtk_pixmap_new (pixmap,mask),
						GTK_SIGNAL_FUNC (toolbar_items[i].callback),
						toolbar_items[i].user_data);
		}
	/* ꥹȥܥå */
#ifdef USE_GTK2
	list_store = gtk_list_store_new (5,
									G_TYPE_STRING,
									G_TYPE_STRING,
									G_TYPE_STRING,
									G_TYPE_STRING,
									G_TYPE_POINTER);
	clist = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
	for (i = 0; i < 4; i++)
	  {
		renderer = gtk_cell_renderer_text_new ();
		column = gtk_tree_view_column_new_with_attributes (gettext (title[i]),
													renderer, "text", i, NULL);
		gtk_tree_view_column_set_resizable (column, TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (clist), column);
	  }
	g_object_set (G_OBJECT (renderer), "xalign", (gfloat)1.0, NULL);
	gtk_tree_view_column_set_alignment (column, 1.0);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (clist));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_MULTIPLE);
	g_signal_connect (G_OBJECT (select), "changed",
											G_CALLBACK (signal_changed), NULL);
#else /* not USE_GTK2 */
	clist=gtk_clist_new(4);
	for (i=0;i<4;i++)
		gtk_clist_set_column_title(GTK_CLIST(clist),i,gettext(title[i]));
	gtk_clist_column_titles_show(GTK_CLIST(clist));
	gtk_clist_column_titles_passive(GTK_CLIST(clist));
	gtk_clist_set_column_justification(GTK_CLIST(clist),3,GTK_JUSTIFY_RIGHT);
	gtk_clist_set_selection_mode(GTK_CLIST(clist),GTK_SELECTION_MULTIPLE);
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",
									GTK_SIGNAL_FUNC(signal_select_row),NULL);
	gtk_signal_connect(GTK_OBJECT(clist),"unselect-row",
									GTK_SIGNAL_FUNC(signal_unselect_row),NULL);
	gtk_signal_connect(GTK_OBJECT(clist),"button-press-event",
							GTK_SIGNAL_FUNC(signal_button_press_clist),NULL);
	gtk_widget_add_events(clist,GDK_BUTTON_PRESS_MASK);
#endif /* not USE_GTK2 */
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scroll),clist);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	/* ơС */
	status=gtk_statusbar_new();
	/* ƥ */
#ifdef USE_GTK2
	text=gtk_label_new("");
#else
	text=gtk_text_new(NULL,NULL);
#endif
	gtk_signal_connect(GTK_OBJECT(text),"style-set",
									GTK_SIGNAL_FUNC(signal_style_set),NULL);
	/* ľܥå/ϥɥܥå */
	vbox=gtk_vbox_new(FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add (GTK_CONTAINER (handle), menu_bar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),toolbar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(vbox),status,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),text,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	/* ե */
	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
																"<main>/File");
	for (i=0;i<history && history_files[i]!=NULL;i++) {
		menu_item=gtk_menu_item_new_with_label(history_files[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
			GTK_SIGNAL_FUNC(signal_activate_menu_history),history_files[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
				GTK_SIGNAL_FUNC(signal_destroy_menu_history),history_files[i]);
		gtk_object_set_user_data(GTK_OBJECT(menu_item),history_files[i]);
		gtk_menu_insert (GTK_MENU (menu_shell), menu_item, i + MENUFILE - 1);
	}
	if (i>0)
		gtk_menu_insert (GTK_MENU (menu_shell), gtk_menu_item_new (),
															i + MENUFILE - 1);
	/*  */
	timer_id=gtk_timeout_add(500,signal_timeout,NULL);

	/* ˥塼ɽ */
	set_menu_bar(NULL);

	/* ˵ưƤ뤫å */
	if (!second) {
		if (argc > 1)
			for (i = 0; i < argc; i++)
			  {
				if (arg_files[i])
				  {
					arg = misc_get_full_path (argv[i]);
					leng = g_strlen (arg) * sizeof (gchar);
					arg_text = g_realloc (arg_text,
											length + leng + sizeof (gchar));
					g_memmove (arg_text + length, arg, leng);
					g_free (arg);
				  }
				else
				  {
					leng = g_strlen (argv[i]) * sizeof (gchar);
					arg_text = g_realloc (arg_text,
											length + leng + sizeof (gchar));
					g_memmove (arg_text + length, argv[i], leng);
				  }
				length += leng;
				arg_text[length++] = '\n';
			  }
		if (length > 0)
		  {
			arg_text[length - 1] = '\0';
			gtk_selection_owner_set (window, atom_videomaid1,
															GDK_CURRENT_TIME);
		  }
		gtk_selection_convert(window,atom_videomaid0,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
		gdk_threads_enter();
		while (instance<0)
			while (gtk_events_pending())
				gtk_main_iteration();
		gdk_threads_leave();
		if (instance>0) {
			/* ˵ưƤȤ */
			gdk_threads_enter();
			while (arg_text!=NULL)
				while (gtk_events_pending())
					gtk_main_iteration();
			gdk_threads_leave();
			g_free(arg_files);
			gtk_exit(0);
		}
		g_free(arg_text);
		gtk_selection_owner_set(window,atom_videomaid0,GDK_CURRENT_TIME);
	}

	/* ɽ */
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
													"<main>/Task"))),FALSE);
	gtk_widget_show_all(window);
	gtk_widget_hide_all(text);
	gtk_window_set_policy(GTK_WINDOW(window),FALSE,TRUE,TRUE);

	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap0,NULL,xpm0);
	gdk_pixmap_unref(pixmap);
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap1,NULL,xpm1);
	gdk_pixmap_unref(pixmap);

	/* ƥ࿧ */
	style=gtk_widget_get_style(text);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->bg[3];
	/* ƥե */
	system_font=gdk_font_ref(gtk_style_get_font(style));
	for (i=0;i<256;i++) {
		gdk_text_extents(system_font,(gchar *)&i,1,
												NULL,NULL,NULL,&ascent,NULL);
		if (system_font_ascent<ascent)
			system_font_ascent=ascent;
		height = gdk_char_height (system_font, (gchar)i);
		if (system_font_height<height)
			system_font_height=height;
	}

	/* ɥ */
	for (i=1;i<argc;i++)
		if (arg_files[i]) {
			file_open=g_malloc(sizeof(FileOpen));
			file_open->file=g_strdup(argv[i]);
			file_open->merge=file_merge;
#ifdef USE_GTK2
			g_thread_create((GThreadFunc)file_open_edit,file_open,TRUE,NULL);
#else
			pthread_create(&id,NULL,(void *)file_open_edit,file_open);
			pthread_detach(id);
#endif
			count++;
		}
	g_free(arg_files);
	if (newfile && count<=0) {
#ifdef USE_GTK2
		g_thread_create((GThreadFunc)file_open_edit,NULL,TRUE,NULL);
#else
		pthread_create(&id,NULL,(void *)file_open_edit,NULL);
		pthread_detach(id);
#endif
	}

	gdk_threads_enter();
	gtk_main();
	gdk_threads_leave();

	gdk_bitmap_unref(bitmap0);
	gdk_bitmap_unref(bitmap1);

	/* 쥸ȥ˽񤭹 */
	if ((profile=profile_open(NULL))!=NULL) {
		profile_set_value(profile,"vmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","n_pos",
				(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","ratio",
			(gpointer)&default_ratio,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","merge",
			(gpointer)&file_merge,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"vmaid","view",
				(gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"vmaid","rate",
				(gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT);
		if (open_path!=NULL)
			profile_set_value(profile,"vmaid","openpath",(gpointer)open_path,
										(g_strlen(open_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		if (save_path!=NULL)
			profile_set_value(profile,"vmaid","savepath",(gpointer)save_path,
										(g_strlen(save_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		/* ե */
		for (i=0;i<history && history_files[i]!=NULL;i++) {
			key=g_strdup_printf("history%d",i);
			profile_set_value(profile,"vmaid",key,(gpointer)history_files[i],
								(g_strlen(history_files[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<10) {
			key=g_strdup_printf("history%d",i++);
			profile_set_value(profile,"vmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		profile_close(profile);
	}
	gdk_font_unref(system_font);
	g_free(clipboard_scenario);
	g_free(open_path);
	g_free(save_path);
	for (i=0;i<history;i++)
		g_free(history_files[i]);
	gtk_exit(0);
	return 0;
}
