/*
 * Knob.cpp
 *
 *  Created on: 2008/08/06
 *      Author: syn
 */

#include <iostream>
#include <math.h>
#include <GL/gl.h>
#include "Knob.h"

Knob::Knob(const int min, const int max, const int val, KnobListener* listener)
:Controller(){
	mMin = min;
	mMax = max;
	mVal = val;
	mMousePressed = false;
	mListener = listener;
}

Knob::~Knob() {
	// TODO Auto-generated destructor stub
}

int mValDelta = 1;

void Knob::render(){
	float x, y;

	glPushMatrix();

	glTranslatef((float)mLocX, (float)mLocY, 0);
	glRotatef(240, 0, 0, -1);
	float rot;
	rot = 300.0*(float)(mVal-mMin)/(float)(mMax-mMin);
	glRotatef(rot, 0, 0, 1);

	if(mMousePressed){
		glColor3f(1, 0.7, 0);
	}else{
		glColor3f(1, 1, 1);
	}
	// Circle
	glBegin(GL_LINE_STRIP);
	for(int i = 0; i <= 32; i++){
		x = sin((float)i*M_PI/16.0)*8;
		y = cos((float)i*M_PI/16.0)*8;
		glVertex3f(x, y, 0);
	}
	glEnd();

	// Indicator
	glBegin(GL_LINE_STRIP);
	glVertex3f(0, 0, 0);
	glVertex3f(10, 0, 0);
	glEnd();

	glPopMatrix();
}

void Knob::handleMouseButtonDown(const int x, const int y){
	if(x < -8 || x > 8){
		return;
	}
	if(y < -8 || y > 8){
		return;
	}

	mMousePressed = true;
	mControllBaseY = y;
	mControllBaseVal = mVal;
}

void Knob::handleMouseButtonUp(const int x, const int y){
	mMousePressed = false;
}

void Knob::handleMouseMotion(const int btn, const int x, const int y){
	if(!mMousePressed){
		return;
	}

	int oldVal = mVal;

	int d = y-mControllBaseY;
	float k = (float)(mMax-mMin)/100.0;
	d *= -1;	// flip Y-axis
	d = (int)(d*k);
	mVal = mControllBaseVal + d;
	if(mVal < mMin)	mVal = mMin;
	if(mVal > mMax)	mVal = mMax;

	if(mVal != oldVal){
		if(mListener){
			mListener->knobValueChanged(this, mVal);
		}
	}
}
